/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.block.upgrade;

import com.buuz135.industrial.api.conveyor.ConveyorUpgrade;
import com.buuz135.industrial.api.conveyor.ConveyorUpgradeFactory;
import com.buuz135.industrial.api.conveyor.IConveyorContainer;
import com.buuz135.industrial.api.conveyor.gui.IGuiComponent;
import com.buuz135.industrial.gui.component.FilterGuiComponent;
import com.buuz135.industrial.gui.component.StateButtonInfo;
import com.buuz135.industrial.gui.component.TexturedStateButtonGuiComponent;
import com.buuz135.industrial.proxy.ItemRegistry;
import com.buuz135.industrial.proxy.block.Cuboid;
import com.buuz135.industrial.proxy.block.filter.IFilter;
import com.buuz135.industrial.proxy.block.filter.ItemStackFilter;
import com.buuz135.industrial.registry.IFRegistries;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ConveyorExtractionUpgrade
extends ConveyorUpgrade {
    public static Cuboid NORTHBB = new Cuboid(0.25, 0.1875, -0.125, 0.75, 0.6875, 0.1875, EnumFacing.NORTH.func_176745_a());
    public static Cuboid SOUTHBB = new Cuboid(0.25, 0.1875, 0.8125, 0.75, 0.6875, 1.125, EnumFacing.SOUTH.func_176745_a());
    public static Cuboid EASTBB = new Cuboid(0.8125, 0.1875, 0.25, 1.125, 0.6875, 0.75, EnumFacing.EAST.func_176745_a());
    public static Cuboid WESTBB = new Cuboid(-0.125, 0.1875, 0.25, 0.1875, 0.6875, 0.75, EnumFacing.WEST.func_176745_a());
    private boolean fast = false;
    private ItemStackFilter filter = new ItemStackFilter(20, 20, 5, 3);
    private boolean whitelist = false;
    private List<EntityItem> items = new ArrayList<EntityItem>();

    public ConveyorExtractionUpgrade(IConveyorContainer container, ConveyorUpgradeFactory factory, EnumFacing side) {
        super(container, factory, side);
    }

    @Override
    public Cuboid getBoundingBox() {
        switch (this.getSide()) {
            default: {
                return NORTHBB;
            }
            case SOUTH: {
                return SOUTHBB;
            }
            case EAST: {
                return EASTBB;
            }
            case WEST: 
        }
        return WESTBB;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("fast", this.fast);
        compound.func_74782_a("Filter", (NBTBase)this.filter.serializeNBT());
        compound.func_74757_a("Whitelist", this.whitelist);
        return compound;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        this.fast = nbt.func_74767_n("fast");
        if (nbt.func_74764_b("Filter")) {
            this.filter.deserializeNBT(nbt.func_74775_l("Filter"));
        }
        this.whitelist = nbt.func_74767_n("Whitelist");
    }

    @Override
    public boolean onUpgradeActivated(EntityPlayer player, EnumHand hand) {
        ItemStack held = player.func_184586_b(hand);
        if (held.func_77973_b() == Items.field_151114_aO && !this.fast) {
            this.fast = true;
            held.func_190918_g(1);
            return true;
        }
        return false;
    }

    @Override
    public Collection<ItemStack> getDrops() {
        if (!this.fast) {
            return super.getDrops();
        }
        return Sets.newHashSet((Object[])new ItemStack[]{new ItemStack((Item)ItemRegistry.conveyorUpgradeItem, 1, IFRegistries.CONVEYOR_UPGRADE_REGISTRY.getID((IForgeRegistryEntry)this.getFactory()) - 1), new ItemStack(Items.field_151114_aO)});
    }

    @Override
    public void update() {
        IItemHandler itemHandler;
        if (this.getWorld().field_72995_K) {
            return;
        }
        this.items.removeIf(entityItem -> entityItem.func_92059_d().func_190926_b() || entityItem.field_70128_L);
        if (this.items.size() >= 20) {
            return;
        }
        if (this.getWorld().func_82737_E() % (long)(this.fast ? 10 : 20) == 0L && (itemHandler = this.getHandlerCapability()) != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.extractItem(i, 4, true);
                if (stack.func_190926_b() || this.whitelist != this.filter.matches(stack)) continue;
                EntityItem item = new EntityItem(this.getWorld(), (double)this.getPos().func_177958_n() + 0.5, (double)this.getPos().func_177956_o() + 0.5, (double)this.getPos().func_177952_p() + 0.5);
                item.field_70159_w = 0.0;
                item.field_70181_x = 0.0;
                item.field_70179_y = 0.0;
                item.func_174867_a(40);
                item.func_92058_a(itemHandler.extractItem(i, 4, false));
                this.getWorld().func_72838_d((Entity)item);
                this.items.add(item);
                break;
            }
        }
    }

    @Nullable
    private IItemHandler getHandlerCapability() {
        BlockPos offsetPos = this.getPos().func_177972_a(this.getSide());
        TileEntity tile = this.getWorld().func_175625_s(offsetPos);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getSide().func_176734_d())) {
            return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.getSide().func_176734_d());
        }
        Iterator iterator = this.getWorld().func_175647_a(Entity.class, new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(offsetPos), EntitySelectors.field_180132_d).iterator();
        while (iterator.hasNext()) {
            Entity entity;
            if (!entity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (entity = (Entity)iterator.next()) instanceof EntityPlayerMP ? null : this.getSide().func_176734_d())) continue;
            return (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, entity instanceof EntityPlayerMP ? null : this.getSide().func_176734_d());
        }
        return null;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void handleButtonInteraction(int buttonId, NBTTagCompound compound) {
        super.handleButtonInteraction(buttonId, compound);
        if (buttonId >= 0 && buttonId < this.filter.getFilter().length) {
            this.filter.setFilter(buttonId, new ItemStack(compound));
            this.getContainer().requestSync();
        }
        if (buttonId == 16) {
            this.whitelist = !this.whitelist;
            this.getContainer().requestSync();
        }
    }

    @Override
    public void addComponentsToGui(List<IGuiComponent> componentList) {
        super.addComponentsToGui(componentList);
        componentList.add(new FilterGuiComponent(this.filter.getLocX(), this.filter.getLocY(), this.filter.getSizeX(), this.filter.getSizeY()){

            @Override
            public IFilter getFilter() {
                return ConveyorExtractionUpgrade.this.filter;
            }
        });
        ResourceLocation res = new ResourceLocation("industrialforegoing", "textures/gui/machines.png");
        componentList.add(new TexturedStateButtonGuiComponent(16, 133, 20, 18, 18, new StateButtonInfo[]{new StateButtonInfo(0, res, 1, 214, new String[]{"whitelist"}), new StateButtonInfo(1, res, 20, 214, new String[]{"blacklist"})}){

            @Override
            public int getState() {
                return ConveyorExtractionUpgrade.this.whitelist ? 0 : 1;
            }
        });
    }

    public static class Factory
    extends ConveyorUpgradeFactory {
        public Factory() {
            this.setRegistryName("extraction");
        }

        @Override
        public ConveyorUpgrade create(IConveyorContainer container, EnumFacing face) {
            return new ConveyorExtractionUpgrade(container, this, face);
        }

        @Override
        @Nonnull
        public ResourceLocation getModel(EnumFacing upgradeSide, EnumFacing conveyorFacing) {
            return new ResourceLocation("industrialforegoing", "block/conveyor_upgrade_extractor_" + upgradeSide.func_176610_l().toLowerCase());
        }

        @Override
        @Nonnull
        public ResourceLocation getItemModel() {
            return new ResourceLocation("industrialforegoing", "conveyor_extraction_upgrade");
        }
    }
}

