/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.model.ITransformation;
import org.lwjgl.util.vector.Vector3f;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.render.CharsetFaceBakery;
import pl.asie.charset.lib.render.model.ModelFactory;
import pl.asie.charset.lib.render.model.SimpleBakedModel;
import pl.asie.charset.lib.wires.IWireContainer;
import pl.asie.charset.lib.wires.IWireRenderContainer;
import pl.asie.charset.lib.wires.ItemWire;
import pl.asie.charset.lib.wires.Wire;
import pl.asie.charset.lib.wires.WireNeighborWHCache;
import pl.asie.charset.lib.wires.WireProvider;
import pl.asie.charset.lib.wires.WireRenderHandler;
import pl.asie.charset.lib.wires.WireUtils;

public class RendererWire
extends ModelFactory<Wire> {
    private final ModelRotation[] ROTATIONS = new ModelRotation[]{ModelRotation.X0_Y0, ModelRotation.X180_Y0, ModelRotation.X270_Y0, ModelRotation.X270_Y180, ModelRotation.X270_Y270, ModelRotation.X270_Y90};
    private final Map<WireProvider, IWireRenderContainer> containerMap = new HashMap<WireProvider, IWireRenderContainer>();

    public RendererWire() {
        super(Wire.PROPERTY, TextureMap.field_174945_f);
        this.addDefaultBlockTransforms();
    }

    private <T> void addNonNull(Collection<T> coll, T object) {
        if (object != null) {
            coll.add(object);
        }
    }

    public IWireRenderContainer getContainer(WireProvider type) {
        return this.containerMap.get(type);
    }

    private boolean wc(Wire wire, EnumFacing facing) {
        return wire.connects(facing);
    }

    private boolean isCenterEdge(Wire wire, WireFace side) {
        return false;
    }

    private float getCL(WireRenderHandler handler, Wire wire, WireFace side) {
        WireNeighborWHCache cache;
        float h = 0.0f;
        if (wire != null && this.isCenterEdge(wire, side)) {
            h = 0.0f;
        }
        if (!this.wc(wire, side.facing)) {
            h = 8.0f - handler.getWidth() * 8.0f;
        } else if (wire.getLocation() == WireFace.CENTER && side != WireFace.CENTER && (cache = wire.getNeighborWHCache()) != null) {
            float myWidth = handler.getWidth();
            float otherWidth = cache.getWidth(side.facing);
            if (otherWidth == myWidth) {
                h = cache.getHeight(side.facing) * 16.0f;
            }
        }
        return side.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 16.0f - h : h;
    }

    protected void addTopFaceCplxInner(WireRenderHandler handler, Wire wire, EnumFacing facing, EnumFacing renderFace, EnumFacing[] dirs, int dirI, Vector3f from, Vector3f to, List<BakedQuad> quads, int connMask, ModelRotation rot) {
        float minX = 8.0f - handler.getWidth() * 8.0f;
        float maxX = 16.0f - minX;
        float minZ = minX;
        float maxZ = maxX;
        int dirP = dirI;
        switch (facing) {
            case UP: {
                if (dirP >= 2) break;
                dirP ^= 1;
                break;
            }
            case SOUTH: 
            case EAST: {
                if (dirP < 2) break;
                dirP ^= 1;
            }
        }
        switch (dirP) {
            case 0: {
                minZ = 0.0f;
                maxZ = minX;
                break;
            }
            case 1: {
                minZ = maxZ;
                maxZ = 16.0f;
                break;
            }
            case 2: {
                minX = 0.0f;
                maxX = minZ;
                break;
            }
            case 3: {
                minX = maxX;
                maxX = 16.0f;
                break;
            }
        }
        switch (renderFace.func_176740_k()) {
            case X: {
                from = new Vector3f(from.x, minX, minZ);
                to = new Vector3f(to.x, maxX, maxZ);
                break;
            }
            case Y: {
                from = new Vector3f(minX, from.y, minZ);
                to = new Vector3f(maxX, to.y, maxZ);
                break;
            }
            case Z: {
                from = new Vector3f(minX, minZ, from.z);
                to = new Vector3f(maxX, maxZ, to.z);
            }
        }
        this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(from, to, handler.getColor(WireRenderHandler.TextureType.TOP, wire, dirI < 0 ? null : dirs[dirI]), new float[]{minX, minZ, maxX, maxZ}, handler.getTexture(WireRenderHandler.TextureType.TOP, wire, dirI < 0 ? null : dirs[dirI], connMask), renderFace, (ITransformation)rot, true));
    }

    protected void makeTopFace(List<BakedQuad> quads, WireRenderHandler handler, Wire wire, Vector3f from, Vector3f to, int connMask, EnumFacing facing, EnumFacing renderFacing, ModelRotation rot) {
        if (!handler.isTopSimple()) {
            EnumFacing[] dirs = WireUtils.getConnectionsForRender(WireFace.get(EnumFacing.func_82600_a((int)(facing.ordinal() & 0xFFFFFFFE))));
            this.addTopFaceCplxInner(handler, wire, facing, renderFacing, dirs, -1, from, to, quads, connMask, rot);
            switch (facing) {
                case UP: {
                    connMask = connMask & 3 | (connMask & 8) >> 1 | (connMask & 4) << 1;
                    break;
                }
                case SOUTH: 
                case EAST: {
                    connMask = connMask & 0xC | (connMask & 2) >> 1 | (connMask & 1) << 1;
                }
            }
            if ((connMask & 8) != 0) {
                this.addTopFaceCplxInner(handler, wire, facing, renderFacing, dirs, 0, from, to, quads, connMask, rot);
            }
            if ((connMask & 4) != 0) {
                this.addTopFaceCplxInner(handler, wire, facing, renderFacing, dirs, 1, from, to, quads, connMask, rot);
            }
            if ((connMask & 2) != 0) {
                this.addTopFaceCplxInner(handler, wire, facing, renderFacing, dirs, 2, from, to, quads, connMask, rot);
            }
            if ((connMask & 1) != 0) {
                this.addTopFaceCplxInner(handler, wire, facing, renderFacing, dirs, 3, from, to, quads, connMask, rot);
            }
            return;
        }
        this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(from, to, handler.getColor(WireRenderHandler.TextureType.TOP, wire, null), handler.getTexture(WireRenderHandler.TextureType.TOP, wire, null, connMask), renderFacing, (ITransformation)rot, true));
    }

    public void addWireFreestanding(WireRenderHandler handler, Wire wire, List<BakedQuad> quads) {
        float min = 8.0f - handler.getWidth() * 8.0f;
        float max = 16.0f - min;
        Vector3f minX = new Vector3f(min, this.getCL(handler, wire, WireFace.DOWN), this.getCL(handler, wire, WireFace.NORTH));
        Vector3f maxX = new Vector3f(min, this.getCL(handler, wire, WireFace.UP), this.getCL(handler, wire, WireFace.SOUTH));
        Vector3f minY = new Vector3f(this.getCL(handler, wire, WireFace.WEST), min, this.getCL(handler, wire, WireFace.NORTH));
        Vector3f maxY = new Vector3f(this.getCL(handler, wire, WireFace.EAST), min, this.getCL(handler, wire, WireFace.SOUTH));
        Vector3f minZ = new Vector3f(this.getCL(handler, wire, WireFace.WEST), this.getCL(handler, wire, WireFace.DOWN), min);
        Vector3f maxZ = new Vector3f(this.getCL(handler, wire, WireFace.EAST), this.getCL(handler, wire, WireFace.UP), min);
        int cmcX = (this.wc(wire, EnumFacing.UP) ? 8 : 0) | (this.wc(wire, EnumFacing.DOWN) ? 4 : 0) | (this.wc(wire, EnumFacing.NORTH) ? 2 : 0) | (this.wc(wire, EnumFacing.SOUTH) ? 1 : 0);
        int cmcY = (this.wc(wire, EnumFacing.NORTH) ? 4 : 0) | (this.wc(wire, EnumFacing.SOUTH) ? 8 : 0) | (this.wc(wire, EnumFacing.WEST) ? 2 : 0) | (this.wc(wire, EnumFacing.EAST) ? 1 : 0);
        int cmcZ = (this.wc(wire, EnumFacing.UP) ? 8 : 0) | (this.wc(wire, EnumFacing.DOWN) ? 4 : 0) | (this.wc(wire, EnumFacing.WEST) ? 1 : 0) | (this.wc(wire, EnumFacing.EAST) ? 2 : 0);
        this.makeTopFace(quads, handler, wire, minX, maxX, cmcX, EnumFacing.WEST, EnumFacing.WEST, ModelRotation.X0_Y0);
        this.makeTopFace(quads, handler, wire, minY, maxY, cmcY, EnumFacing.DOWN, EnumFacing.DOWN, ModelRotation.X0_Y0);
        this.makeTopFace(quads, handler, wire, minZ, maxZ, cmcZ, EnumFacing.NORTH, EnumFacing.NORTH, ModelRotation.X0_Y0);
        minX.setX(max);
        maxX.setX(max);
        minY.setY(max);
        maxY.setY(max);
        minZ.setZ(max);
        maxZ.setZ(max);
        cmcY = cmcY & 3 | (cmcY & 8) >> 1 | (cmcY & 4) << 1;
        cmcZ = cmcZ & 0xC | (cmcZ & 2) >> 1 | (cmcZ & 1) << 1;
        cmcX = cmcX & 0xC | (cmcX & 2) >> 1 | (cmcX & 1) << 1;
        this.makeTopFace(quads, handler, wire, minX, maxX, cmcX, EnumFacing.EAST, EnumFacing.EAST, ModelRotation.X0_Y0);
        this.makeTopFace(quads, handler, wire, minY, maxY, cmcY, EnumFacing.UP, EnumFacing.UP, ModelRotation.X0_Y0);
        this.makeTopFace(quads, handler, wire, minZ, maxZ, cmcZ, EnumFacing.SOUTH, EnumFacing.SOUTH, ModelRotation.X0_Y0);
        for (EnumFacing f : EnumFacing.field_82609_l) {
            float[] fArray;
            if (!this.wc(wire, f)) continue;
            Vector3f vector3f = new Vector3f(min, 0.0f, min);
            Vector3f vector3f2 = new Vector3f(max, 0.0f, max);
            int n = handler.getColor(WireRenderHandler.TextureType.EDGE, wire, f);
            if (f.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                float[] fArray2 = new float[4];
                fArray2[0] = max;
                fArray2[1] = min;
                fArray2[2] = min;
                fArray = fArray2;
                fArray2[3] = max;
            } else {
                float[] fArray3 = new float[4];
                fArray3[0] = min;
                fArray3[1] = min;
                fArray3[2] = max;
                fArray = fArray3;
                fArray3[3] = max;
            }
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(vector3f, vector3f2, n, fArray, handler.getTexture(WireRenderHandler.TextureType.EDGE, wire, f, 15), EnumFacing.DOWN, (ITransformation)this.ROTATIONS[f.ordinal()], true));
        }
    }

    public void addCorner(WireRenderHandler handler, Wire wire, EnumFacing dir, List<BakedQuad> quads) {
        if (wire.getProvider().isFlat()) {
            return;
        }
        int width = (int)(handler.getWidth() * 16.0f);
        int height = (int)(handler.getHeight() * 16.0f);
        ModelRotation rot = this.ROTATIONS[wire.getLocation().ordinal()];
        float min = 8.0f - (float)(width / 2);
        float max = 16.0f - min;
        float[] edgeUV = new float[]{min, 0.0f, max, height};
        float[] edgeUVFlipped = new float[]{max, 0.0f, min, height};
        if (dir == EnumFacing.NORTH) {
            float[] topUV = new float[]{min, 16 - height, max, 16.0f};
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(min, 0.0f, (float)(-height)), new Vector3f(max, (float)height, (float)(-height)), handler.getColor(WireRenderHandler.TextureType.TOP, wire, EnumFacing.NORTH), edgeUVFlipped, handler.getTexture(WireRenderHandler.TextureType.TOP, wire, null, 15), EnumFacing.NORTH, (ITransformation)rot, false));
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(min, (float)height, (float)(-height)), new Vector3f(max, (float)height, 0.0f), handler.getColor(WireRenderHandler.TextureType.TOP, wire, EnumFacing.UP), topUV, handler.getTexture(WireRenderHandler.TextureType.TOP, wire, null, 15), EnumFacing.UP, (ITransformation)rot, false));
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(min, 0.0f, (float)(-height)), new Vector3f(max, 0.0f, 0.0f), handler.getColor(WireRenderHandler.TextureType.TOP, wire, EnumFacing.DOWN), topUV, handler.getTexture(WireRenderHandler.TextureType.TOP, wire, null, 15), EnumFacing.DOWN, (ITransformation)rot, false));
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(min, 0.0f, (float)(-height)), new Vector3f(min, (float)height, 0.0f), handler.getColor(WireRenderHandler.TextureType.EDGE, wire, null), edgeUV, handler.getTexture(WireRenderHandler.TextureType.EDGE, wire, null, 15), EnumFacing.WEST, (ITransformation)rot, false));
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(max, 0.0f, (float)(-height)), new Vector3f(max, (float)height, 0.0f), handler.getColor(WireRenderHandler.TextureType.EDGE, wire, null), edgeUVFlipped, handler.getTexture(WireRenderHandler.TextureType.EDGE, wire, null, 15), EnumFacing.EAST, (ITransformation)rot, false));
        } else if (dir == EnumFacing.SOUTH) {
            float[] topUV = new float[]{min, 0.0f, max, height};
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(min, 0.0f, (float)(16 + height)), new Vector3f(max, (float)height, (float)(16 + height)), handler.getColor(WireRenderHandler.TextureType.TOP, wire, EnumFacing.SOUTH), edgeUVFlipped, handler.getTexture(WireRenderHandler.TextureType.TOP, wire, null, 15), EnumFacing.SOUTH, (ITransformation)rot, false));
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(min, (float)height, 16.0f), new Vector3f(max, (float)height, (float)(16 + height)), handler.getColor(WireRenderHandler.TextureType.TOP, wire, EnumFacing.UP), topUV, handler.getTexture(WireRenderHandler.TextureType.TOP, wire, null, 15), EnumFacing.UP, (ITransformation)rot, false));
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(min, 0.0f, 16.0f), new Vector3f(max, 0.0f, (float)(16 + height)), handler.getColor(WireRenderHandler.TextureType.TOP, wire, EnumFacing.DOWN), topUV, handler.getTexture(WireRenderHandler.TextureType.TOP, wire, null, 15), EnumFacing.DOWN, (ITransformation)rot, false));
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(min, 0.0f, 16.0f), new Vector3f(min, (float)height, (float)(16 + height)), handler.getColor(WireRenderHandler.TextureType.EDGE, wire, null), edgeUV, handler.getTexture(WireRenderHandler.TextureType.EDGE, wire, null, 15), EnumFacing.WEST, (ITransformation)rot, false));
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(max, 0.0f, 16.0f), new Vector3f(max, (float)height, (float)(16 + height)), handler.getColor(WireRenderHandler.TextureType.EDGE, wire, null), edgeUVFlipped, handler.getTexture(WireRenderHandler.TextureType.EDGE, wire, null, 15), EnumFacing.EAST, (ITransformation)rot, false));
        } else if (dir == EnumFacing.WEST) {
            float[] topUV = new float[]{16 - height, min, 16.0f, max};
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f((float)(-height), (float)height, min), new Vector3f(0.0f, (float)height, max), handler.getColor(WireRenderHandler.TextureType.TOP, wire, EnumFacing.UP), topUV, handler.getTexture(WireRenderHandler.TextureType.TOP, wire, null, 15), EnumFacing.UP, (ITransformation)rot, false));
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f((float)(-height), 0.0f, min), new Vector3f(0.0f, 0.0f, max), handler.getColor(WireRenderHandler.TextureType.TOP, wire, EnumFacing.DOWN), topUV, handler.getTexture(WireRenderHandler.TextureType.TOP, wire, null, 15), EnumFacing.DOWN, (ITransformation)rot, false));
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f((float)(-height), 0.0f, min), new Vector3f((float)(-height), (float)height, max), handler.getColor(WireRenderHandler.TextureType.TOP, wire, EnumFacing.WEST), edgeUV, handler.getTexture(WireRenderHandler.TextureType.TOP, wire, null, 15), EnumFacing.WEST, (ITransformation)rot, false));
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f((float)(-height), 0.0f, min), new Vector3f(0.0f, (float)height, min), handler.getColor(WireRenderHandler.TextureType.EDGE, wire, null), edgeUVFlipped, handler.getTexture(WireRenderHandler.TextureType.EDGE, wire, null, 15), EnumFacing.NORTH, (ITransformation)rot, false));
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f((float)(-height), 0.0f, max), new Vector3f(0.0f, (float)height, max), handler.getColor(WireRenderHandler.TextureType.EDGE, wire, null), edgeUV, handler.getTexture(WireRenderHandler.TextureType.EDGE, wire, null, 15), EnumFacing.SOUTH, (ITransformation)rot, false));
        } else if (dir == EnumFacing.EAST) {
            float[] topUV = new float[]{0.0f, min, height, max};
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(16.0f, (float)height, min), new Vector3f((float)(16 + height), (float)height, max), handler.getColor(WireRenderHandler.TextureType.TOP, wire, EnumFacing.UP), topUV, handler.getTexture(WireRenderHandler.TextureType.TOP, wire, null, 15), EnumFacing.UP, (ITransformation)rot, false));
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(16.0f, 0.0f, min), new Vector3f((float)(16 + height), 0.0f, max), handler.getColor(WireRenderHandler.TextureType.TOP, wire, EnumFacing.DOWN), topUV, handler.getTexture(WireRenderHandler.TextureType.TOP, wire, null, 15), EnumFacing.DOWN, (ITransformation)rot, false));
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f((float)(16 + height), 0.0f, min), new Vector3f((float)(16 + height), (float)height, max), handler.getColor(WireRenderHandler.TextureType.TOP, wire, EnumFacing.EAST), edgeUV, handler.getTexture(WireRenderHandler.TextureType.TOP, wire, null, 15), EnumFacing.EAST, (ITransformation)rot, false));
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(16.0f, 0.0f, min), new Vector3f((float)(16 + height), (float)height, min), handler.getColor(WireRenderHandler.TextureType.EDGE, wire, null), edgeUVFlipped, handler.getTexture(WireRenderHandler.TextureType.EDGE, wire, null, 15), EnumFacing.NORTH, (ITransformation)rot, false));
            this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(16.0f, 0.0f, max), new Vector3f((float)(16 + height), (float)height, max), handler.getColor(WireRenderHandler.TextureType.EDGE, wire, null), edgeUV, handler.getTexture(WireRenderHandler.TextureType.EDGE, wire, null, 15), EnumFacing.SOUTH, (ITransformation)rot, false));
        }
    }

    public void addWire(WireRenderHandler handler, Wire wire, List<BakedQuad> quads) {
        WireFace side = wire.getLocation();
        if (side == WireFace.CENTER) {
            this.addWireFreestanding(handler, wire, quads);
            return;
        }
        float min = 8.0f - handler.getWidth() * 8.0f;
        float max = 16.0f - min;
        float minH = 0.0f;
        float maxH = handler.getHeight() * 16.0f;
        EnumFacing[] dirs = WireUtils.getConnectionsForRender(side);
        boolean[] connectionMatrix = new boolean[]{wire.connectsAny(dirs[0]), wire.connectsAny(dirs[1]), wire.connectsAny(dirs[2]), wire.connectsAny(dirs[3])};
        int cmc = (connectionMatrix[0] ? 8 : 0) | (connectionMatrix[1] ? 4 : 0) | (connectionMatrix[2] ? 2 : 0) | (connectionMatrix[3] ? 1 : 0);
        boolean[] cornerConnectionMatrix = new boolean[]{wire.connectsCorner(dirs[0]), wire.connectsCorner(dirs[1]), wire.connectsCorner(dirs[2]), wire.connectsCorner(dirs[3])};
        ModelRotation rot = this.ROTATIONS[side.ordinal()];
        Vector3f from = new Vector3f(min, maxH, min);
        Vector3f to = new Vector3f(max, maxH, max);
        if (connectionMatrix[0]) {
            from.setZ(0.0f);
        }
        if (connectionMatrix[1]) {
            to.setZ(16.0f);
        }
        if (connectionMatrix[2]) {
            from.setX(0.0f);
        }
        if (connectionMatrix[3]) {
            to.setX(16.0f);
        }
        this.makeTopFace(quads, handler, wire, from, to, cmc, wire.getLocation().facing, EnumFacing.UP, rot);
        if (!wire.getProvider().isFlat()) {
            boolean renderSideZ;
            from.setY(0.0f);
            to.setY(0.0f);
            this.makeTopFace(quads, handler, wire, from, to, cmc, wire.getLocation().facing, EnumFacing.DOWN, rot);
            Vector3f fromZ = new Vector3f(from.getX(), 0.0f, min);
            Vector3f toZ = new Vector3f(to.getX(), maxH, min);
            Vector3f fromX = new Vector3f(min, 0.0f, from.getZ());
            Vector3f toX = new Vector3f(min, maxH, to.getZ());
            boolean crossroadsX = connectionMatrix[2] && !connectionMatrix[3];
            boolean crossroadsZ = connectionMatrix[0] && !connectionMatrix[1];
            boolean renderSideX = connectionMatrix[0] || connectionMatrix[1];
            boolean bl = renderSideZ = connectionMatrix[2] || connectionMatrix[3];
            if (!connectionMatrix[2] || renderSideX) {
                this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(fromX, toX, handler.getColor(WireRenderHandler.TextureType.SIDE, wire, EnumFacing.WEST), new float[]{fromX.getZ(), fromX.getY(), toX.getZ(), toX.getY()}, handler.getTexture(WireRenderHandler.TextureType.SIDE, wire, EnumFacing.WEST, cmc), EnumFacing.WEST, (ITransformation)rot, false));
            }
            if (!connectionMatrix[0] || renderSideZ) {
                this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(fromZ, toZ, handler.getColor(WireRenderHandler.TextureType.SIDE, wire, EnumFacing.NORTH), new float[]{toZ.getX(), fromZ.getY(), fromZ.getX(), toZ.getY()}, handler.getTexture(WireRenderHandler.TextureType.SIDE, wire, EnumFacing.NORTH, cmc), EnumFacing.NORTH, (ITransformation)rot, false));
            }
            fromX.setX(max);
            toX.setX(max);
            fromZ.setZ(max);
            toZ.setZ(max);
            if (!connectionMatrix[3] || renderSideX) {
                this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(fromX, toX, handler.getColor(WireRenderHandler.TextureType.SIDE, wire, EnumFacing.EAST), new float[]{toX.getZ(), fromX.getY(), fromX.getZ(), toX.getY()}, handler.getTexture(WireRenderHandler.TextureType.SIDE, wire, EnumFacing.EAST, cmc), EnumFacing.EAST, (ITransformation)rot, false));
            }
            if (!connectionMatrix[1] || renderSideZ) {
                this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(fromZ, toZ, handler.getColor(WireRenderHandler.TextureType.SIDE, wire, EnumFacing.SOUTH), new float[]{fromZ.getX(), fromZ.getY(), toZ.getX(), toZ.getY()}, handler.getTexture(WireRenderHandler.TextureType.SIDE, wire, EnumFacing.SOUTH, cmc), EnumFacing.SOUTH, (ITransformation)rot, false));
            }
            float[] edgeUV = new float[]{min, minH, max, maxH};
            float[] edgeUVFlipped = new float[]{max, minH, min, maxH};
            if (connectionMatrix[0]) {
                this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(min, minH, 0.0f), new Vector3f(max, maxH, 0.0f), handler.getColor(WireRenderHandler.TextureType.EDGE, wire, EnumFacing.NORTH), edgeUVFlipped, handler.getTexture(WireRenderHandler.TextureType.EDGE, wire, EnumFacing.NORTH, 15), EnumFacing.NORTH, (ITransformation)rot, false));
            }
            if (connectionMatrix[1]) {
                this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(min, minH, 16.0f), new Vector3f(max, maxH, 16.0f), handler.getColor(WireRenderHandler.TextureType.EDGE, wire, EnumFacing.SOUTH), edgeUV, handler.getTexture(WireRenderHandler.TextureType.EDGE, wire, EnumFacing.SOUTH, 15), EnumFacing.SOUTH, (ITransformation)rot, false));
            }
            if (connectionMatrix[2]) {
                this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(0.0f, minH, min), new Vector3f(0.0f, maxH, max), handler.getColor(WireRenderHandler.TextureType.EDGE, wire, EnumFacing.WEST), edgeUV, handler.getTexture(WireRenderHandler.TextureType.EDGE, wire, EnumFacing.WEST, 15), EnumFacing.WEST, (ITransformation)rot, false));
            }
            if (connectionMatrix[3]) {
                this.addNonNull(quads, CharsetFaceBakery.INSTANCE.makeBakedQuad(new Vector3f(16.0f, minH, min), new Vector3f(16.0f, maxH, max), handler.getColor(WireRenderHandler.TextureType.EDGE, wire, EnumFacing.EAST), edgeUVFlipped, handler.getTexture(WireRenderHandler.TextureType.EDGE, wire, EnumFacing.EAST, 15), EnumFacing.EAST, (ITransformation)rot, false));
            }
            EnumFacing[] dirs0 = WireUtils.getConnectionsForRender(WireFace.DOWN);
            for (int i = 0; i < 4; ++i) {
                if (!cornerConnectionMatrix[i]) continue;
                this.addCorner(handler, wire, dirs0[i], quads);
            }
        }
    }

    protected IBakedModel bakeWire(Wire wire, boolean isDynamic, boolean isItem, BlockRenderLayer blockLayer) {
        IWireRenderContainer container;
        boolean hasDynamic = false;
        SimpleBakedModel model = new SimpleBakedModel(this);
        if (wire != null && (container = this.containerMap.get(wire.getProvider())) != null) {
            for (int i = 0; i < container.getLayerCount(); ++i) {
                WireRenderHandler handler = container.get(i);
                if (i == 0) {
                    model.setParticle(handler.getTexture(WireRenderHandler.TextureType.PARTICLE, wire, null, 15));
                }
                if (!isItem && (handler.isDynamic() != isDynamic || blockLayer != handler.getRenderLayer())) continue;
                hasDynamic = true;
                this.addWire(handler, wire, model.func_188616_a(null, null, 0L));
            }
        }
        return !isItem && isDynamic && !hasDynamic ? null : model;
    }

    @Override
    public IBakedModel bake(Wire wire, boolean isItem, BlockRenderLayer blockLayer) {
        return this.bakeWire(wire, false, isItem, blockLayer);
    }

    @Override
    public Wire fromItemStack(ItemStack stack) {
        Wire wire = ((ItemWire)stack.func_77973_b()).fromStack(new IWireContainer.Dummy(), stack, EnumFacing.DOWN);
        if (wire != null) {
            wire.setConnectionsForItemRender();
        }
        return wire;
    }

    public void registerContainer(WireProvider provider, IWireRenderContainer container) {
        this.containerMap.put(provider, container);
    }

    protected void reloadTextures(TextureMap map) {
        for (IWireRenderContainer container : this.containerMap.values()) {
            for (int i = 0; i < container.getLayerCount(); ++i) {
                WireRenderHandler handler = container.get(i);
                handler.refresh(map);
            }
        }
    }
}

