/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.network.login.INetHandlerLoginClient;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.block.BlockBase;
import pl.asie.charset.lib.block.PacketCustomBlockDust;
import pl.asie.charset.lib.handlers.FluidExtraInformationHandler;
import pl.asie.charset.lib.item.FontRendererFancy;
import pl.asie.charset.lib.render.ParticleBlockDustCharset;
import pl.asie.charset.lib.render.ParticleDiggingCharset;
import pl.asie.charset.lib.render.model.IStateParticleBakedModel;
import pl.asie.charset.lib.utils.ThreeState;
import pl.asie.charset.lib.utils.UtilProxyCommon;

public class UtilProxyClient
extends UtilProxyCommon {
    public static FontRenderer FONT_RENDERER_FANCY;

    @Override
    public boolean addRunningParticles(IBlockState state, World world, BlockPos pos, Entity entity) {
        IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        if (model instanceof IStateParticleBakedModel) {
            state = state.func_177230_c().getExtendedState(state.func_185899_b((IBlockAccess)world, pos), (IBlockAccess)world, pos);
            TextureAtlasSprite sprite = ((IStateParticleBakedModel)model).getParticleTexture(state, EnumFacing.UP);
            ParticleDiggingCharset particle = new ParticleDiggingCharset(world, entity.field_70165_t + ((double)PacketCustomBlockDust.rand.nextFloat() - 0.5) * (double)entity.field_70130_N, entity.func_174813_aQ().field_72338_b + 0.1, entity.field_70161_v + ((double)PacketCustomBlockDust.rand.nextFloat() - 0.5) * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, state, pos, sprite, ((BlockBase)state.func_177230_c()).getParticleTintIndex());
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
            return true;
        }
        return false;
    }

    @Override
    public void addInformation(Object o, World world, List<String> list, ThreeState isAdvanced) {
        ITooltipFlag.TooltipFlags flag;
        switch (isAdvanced) {
            default: {
                flag = ITooltipFlag.TooltipFlags.NORMAL;
                break;
            }
            case YES: {
                flag = ITooltipFlag.TooltipFlags.ADVANCED;
                break;
            }
            case MAYBE: {
                flag = Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            }
        }
        try {
            if (o instanceof ItemStack) {
                ((ItemStack)o).func_77973_b().func_77624_a((ItemStack)o, world, list, (ITooltipFlag)flag);
            } else if (o instanceof FluidStack) {
                FluidExtraInformationHandler.addInformation((FluidStack)o, list, (ITooltipFlag)flag);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            list.add("" + TextFormatting.RED + TextFormatting.BOLD + "ERROR");
        }
    }

    @Override
    public void init() {
        super.init();
        try {
            FONT_RENDERER_FANCY = new FontRendererFancy(Minecraft.func_71410_x().field_71466_p);
        }
        catch (Exception e) {
            e.printStackTrace();
            FONT_RENDERER_FANCY = Minecraft.func_71410_x().field_71466_p;
        }
    }

    @Override
    public String getLanguageCode() {
        return Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a().toLowerCase();
    }

    @Override
    public World getWorld(INetHandler handler, int dim) {
        if (handler instanceof INetHandlerPlayClient || handler instanceof INetHandlerLoginClient) {
            World w = this.getPlayer((INetHandler)handler).field_70170_p;
            if (w.field_73011_w.getDimension() == dim) {
                return w;
            }
            return null;
        }
        return super.getWorld(handler, dim);
    }

    @Override
    public EntityPlayer getPlayer(INetHandler handler) {
        return handler instanceof INetHandlerPlayClient || handler instanceof INetHandlerLoginClient ? this.getLocalPlayer() : super.getPlayer(handler);
    }

    @Override
    public EntityPlayer getLocalPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public EntityPlayer findPlayer(MinecraftServer server, String name) {
        if (server == null) {
            if (Minecraft.func_71410_x().field_71441_e != null) {
                return Minecraft.func_71410_x().field_71441_e.func_72924_a(name);
            }
            return null;
        }
        return super.findPlayer(server, name);
    }

    @Override
    public void registerItemModel(Item item, int meta, String name) {
        if (name.contains("#")) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(name.split("#")[0], name.split("#")[1]));
        } else {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
        }
    }

    @Override
    public World getLocalWorld(int dim) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            WorldClient w = Minecraft.func_71410_x().field_71441_e;
            if (w != null && w.field_73011_w.getDimension() == dim) {
                return w;
            }
            return null;
        }
        return DimensionManager.getWorld((int)dim);
    }

    @Override
    public World getServerWorldOrDefault(World def) {
        if (def instanceof WorldClient && Minecraft.func_71410_x().func_71387_A()) {
            return DimensionManager.getWorld((int)def.field_73011_w.getDimension());
        }
        return def;
    }

    @Override
    public void onServerStop() {
        super.onServerStop();
    }

    @Override
    public boolean func_152345_ab() {
        return Minecraft.func_71410_x().func_152345_ab();
    }

    @Override
    public ListenableFuture<Object> func_152344_a(Runnable runnable) {
        return Minecraft.func_71410_x().func_152344_a(runnable);
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void setTabAndNameIfNotPresent(IForgeRegistryEntry entry, String name, CreativeTabs tab) {
        super.setTabAndNameIfNotPresent(entry, name, tab);
    }

    @Override
    public void spawnBlockDustClient(World world, BlockPos pos, Random rand, float posX, float posY, float posZ, int numberOfParticles, float particleSpeed, EnumFacing facing) {
        TextureAtlasSprite sprite;
        IBakedModel model;
        int tintIndex = -1;
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockBase) {
            tintIndex = ((BlockBase)state.func_177230_c()).getParticleTintIndex();
        }
        if ((model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state)) instanceof IStateParticleBakedModel) {
            state = state.func_177230_c().getExtendedState(state.func_185899_b((IBlockAccess)world, pos), (IBlockAccess)world, pos);
            sprite = ((IStateParticleBakedModel)model).getParticleTexture(state, facing);
        } else {
            sprite = model.func_177554_e();
        }
        ParticleManager manager = Minecraft.func_71410_x().field_71452_i;
        for (int i = 0; i < numberOfParticles; ++i) {
            double xSpeed = rand.nextGaussian() * (double)particleSpeed;
            double ySpeed = rand.nextGaussian() * (double)particleSpeed;
            double zSpeed = rand.nextGaussian() * (double)particleSpeed;
            try {
                ParticleBlockDustCharset particle = new ParticleBlockDustCharset(world, posX, posY, posZ, xSpeed, ySpeed, zSpeed, state, pos, sprite, tintIndex);
                manager.func_78873_a((Particle)particle);
                continue;
            }
            catch (Throwable var16) {
                ModCharset.logger.warn("Could not spawn block particle!");
                return;
            }
        }
    }

    @Override
    public World getLocalWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }
}

