/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class RayTraceUtils {
    private RayTraceUtils() {
    }

    public static Result getCollision(World world, Vec3d from, Vec3d to, Predicate<BlockPos> ignoreCheck) {
        int steps = (int)Math.ceil(from.func_72438_d(to));
        if (steps <= 0) {
            return new Result(null, null);
        }
        double xd = (to.field_72450_a - from.field_72450_a) / (double)steps;
        double yd = (to.field_72448_b - from.field_72448_b) / (double)steps;
        double zd = (to.field_72449_c - from.field_72449_c) / (double)steps;
        BlockPos lastPos = new BlockPos(from);
        Vec3d vecPos = from.func_72441_c(xd, yd, zd);
        for (int i = 1; i <= steps; ++i) {
            BlockPos pos = new BlockPos(vecPos);
            if (!pos.equals((Object)lastPos) && !ignoreCheck.test(pos)) {
                IBlockState state = world.func_180495_p(pos);
                ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
                state.func_185908_a(world, pos, new AxisAlignedBB(pos), list, null, false);
                Result result = RayTraceUtils.getCollision(world, pos, from, to, list, false);
                if (result.valid()) {
                    return result;
                }
            }
            vecPos = vecPos.func_72441_c(xd, yd, zd);
            lastPos = pos;
        }
        return new Result(null, null);
    }

    public static Vec3d getStart(EntityLivingBase player) {
        return new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
    }

    public static Vec3d getEnd(EntityLivingBase player) {
        IAttributeInstance attributeInstance = player.func_110148_a(EntityPlayer.REACH_DISTANCE);
        double reachDistance = attributeInstance != null ? attributeInstance.func_111126_e() : 5.0;
        Vec3d lookVec = player.func_70040_Z();
        return RayTraceUtils.getStart(player).func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
    }

    public static Result getCollision(World world, BlockPos pos, EntityLivingBase player, List<AxisAlignedBB> list, boolean adjust) {
        Vec3d origin = RayTraceUtils.getStart(player);
        Vec3d direction = RayTraceUtils.getEnd(player);
        return RayTraceUtils.getCollision(world, pos, origin, direction, list, adjust);
    }

    public static RayTraceResult getCollision(World world, BlockPos pos, EntityLivingBase player, AxisAlignedBB aabb, boolean adjust) {
        Vec3d origin = RayTraceUtils.getStart(player);
        Vec3d direction = RayTraceUtils.getEnd(player);
        return RayTraceUtils.getCollision(pos, origin, direction, aabb, adjust);
    }

    public static Result getCollision(World world, BlockPos pos, Vec3d origin, Vec3d direction, List<AxisAlignedBB> list, boolean adjust) {
        double minDistance = Double.POSITIVE_INFINITY;
        RayTraceResult hit = null;
        Vec3d origin0 = !adjust ? origin : origin.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        Vec3d direction0 = !adjust ? direction : direction.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        for (int i = 0; i < list.size(); ++i) {
            double d;
            RayTraceResult mop;
            if (list.get(i) == null || (mop = RayTraceUtils.getCollisionPreAdjusted(pos, origin0, direction0, list.get(i), i)) == null || !((d = mop.field_72307_f.func_72436_e(origin)) < minDistance)) continue;
            minDistance = d;
            hit = mop;
        }
        return new Result(hit, hit != null ? list.get(hit.subHit) : null);
    }

    public static RayTraceResult getCollision(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB aabb, boolean adjust) {
        if (adjust) {
            start = start.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
            end = end.func_72441_c((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        }
        return RayTraceUtils.getCollisionPreAdjusted(pos, start, end, aabb, 0);
    }

    private static RayTraceResult getCollisionPreAdjusted(BlockPos pos, Vec3d start, Vec3d end, AxisAlignedBB aabb, int subHit) {
        Vec3d vecWest = start.func_72429_b(end, aabb.field_72340_a);
        Vec3d vecEast = start.func_72429_b(end, aabb.field_72336_d);
        Vec3d vecDown = start.func_72435_c(end, aabb.field_72338_b);
        Vec3d vecUp = start.func_72435_c(end, aabb.field_72337_e);
        Vec3d vecNorth = start.func_72434_d(end, aabb.field_72339_c);
        Vec3d vecSouth = start.func_72434_d(end, aabb.field_72334_f);
        Vec3d vecHit = null;
        EnumFacing sideHit = null;
        if (RayTraceUtils.isVecInsideYZBounds(aabb, vecWest)) {
            vecHit = vecWest;
            sideHit = EnumFacing.WEST;
        }
        if (RayTraceUtils.isVecInsideYZBounds(aabb, vecEast) && (vecHit == null || start.func_72436_e(vecEast) < start.func_72436_e(vecHit))) {
            vecHit = vecEast;
            sideHit = EnumFacing.EAST;
        }
        if (RayTraceUtils.isVecInsideXZBounds(aabb, vecDown) && (vecHit == null || start.func_72436_e(vecDown) < start.func_72436_e(vecHit))) {
            vecHit = vecDown;
            sideHit = EnumFacing.DOWN;
        }
        if (RayTraceUtils.isVecInsideXZBounds(aabb, vecUp) && (vecHit == null || start.func_72436_e(vecUp) < start.func_72436_e(vecHit))) {
            vecHit = vecUp;
            sideHit = EnumFacing.UP;
        }
        if (RayTraceUtils.isVecInsideXYBounds(aabb, vecNorth) && (vecHit == null || start.func_72436_e(vecNorth) < start.func_72436_e(vecHit))) {
            vecHit = vecNorth;
            sideHit = EnumFacing.NORTH;
        }
        if (RayTraceUtils.isVecInsideXYBounds(aabb, vecSouth) && (vecHit == null || start.func_72436_e(vecSouth) < start.func_72436_e(vecHit))) {
            vecHit = vecSouth;
            sideHit = EnumFacing.SOUTH;
        }
        if (vecHit != null) {
            RayTraceResult mop = new RayTraceResult(vecHit.func_72441_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), sideHit, pos);
            mop.subHit = subHit;
            return mop;
        }
        return null;
    }

    private static boolean isVecInsideYZBounds(AxisAlignedBB aabb, Vec3d point) {
        return point != null && point.field_72448_b >= aabb.field_72338_b && point.field_72448_b <= aabb.field_72337_e && point.field_72449_c >= aabb.field_72339_c && point.field_72449_c <= aabb.field_72334_f;
    }

    private static boolean isVecInsideXZBounds(AxisAlignedBB aabb, Vec3d point) {
        return point != null && point.field_72450_a >= aabb.field_72340_a && point.field_72450_a <= aabb.field_72336_d && point.field_72449_c >= aabb.field_72339_c && point.field_72449_c <= aabb.field_72334_f;
    }

    private static boolean isVecInsideXYBounds(AxisAlignedBB aabb, Vec3d point) {
        return point != null && point.field_72450_a >= aabb.field_72340_a && point.field_72450_a <= aabb.field_72336_d && point.field_72448_b >= aabb.field_72338_b && point.field_72448_b <= aabb.field_72337_e;
    }

    public static class Result {
        public final AxisAlignedBB box;
        public final RayTraceResult hit;

        public Result(RayTraceResult mop, AxisAlignedBB box) {
            this.hit = mop;
            this.box = box;
        }

        public boolean valid() {
            return this.hit != null && this.box != null;
        }
    }
}

