/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.render.sprite;

import com.google.common.collect.ImmutableSet;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import pl.asie.charset.lib.render.sprite.TextureAtlasSpriteCustom;
import pl.asie.charset.lib.utils.RenderUtils;

public class PixelOperationSprite
extends TextureAtlasSpriteCustom {
    private final ResourceLocation location;
    private final Operator operator;
    private final Collection<ResourceLocation> deps;
    private boolean forceReadFromFile;
    private boolean useLargestSize;

    public static Operator combine(Operator ... ops) {
        return (pixels, width, getter) -> {
            for (Operator o : ops) {
                o.apply(pixels, width, getter);
            }
        };
    }

    public static Operator forEach(OperatorForEach op) {
        return (pixels, width, getter) -> {
            int i = 0;
            for (int y = 0; y < pixels.length / width; ++y) {
                int x = 0;
                while (x < width) {
                    pixels[i] = op.apply(x, y, pixels[i]);
                    ++x;
                    ++i;
                }
            }
        };
    }

    public static OperatorForEach multiply(int color) {
        return (x, y, value) -> RenderUtils.multiplyColor(value, color);
    }

    public PixelOperationSprite forceReadFromFile(boolean value) {
        this.forceReadFromFile = value;
        return this;
    }

    public PixelOperationSprite useLargestSize(boolean value) {
        this.useLargestSize = value;
        return this;
    }

    public PixelOperationSprite(String entry, ResourceLocation location, Operator operator, ResourceLocation ... deps) {
        super(entry);
        this.location = location;
        this.operator = operator;
        ImmutableSet.Builder depBuilder = new ImmutableSet.Builder();
        if (!entry.equals(location.toString())) {
            depBuilder.add((Object)location);
        }
        for (ResourceLocation dep : deps) {
            depBuilder.add((Object)dep);
        }
        this.deps = depBuilder.build();
        this.forceReadFromFile = false;
        this.useLargestSize = false;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager manager, ResourceLocation loc, Function<ResourceLocation, TextureAtlasSprite> getter) {
        int[] pixels = null;
        int width = 0;
        int height = 0;
        if (this.deps.contains(this.location) && !this.forceReadFromFile) {
            TextureAtlasSprite sprite = getter.apply(this.location);
            try {
                if (sprite != null && sprite.func_94211_a() == sprite.func_94216_b() && sprite.func_110970_k() > 0) {
                    int frameSize = sprite.func_94211_a() * sprite.func_94216_b();
                    pixels = new int[frameSize * sprite.func_110970_k()];
                    for (int i = 0; i < sprite.func_110970_k(); ++i) {
                        System.arraycopy(sprite.func_147965_a(i)[0], 0, pixels, i * frameSize, frameSize);
                    }
                    width = sprite.func_94211_a();
                    height = sprite.func_94216_b() * sprite.func_110970_k();
                }
            }
            catch (Exception e) {
                pixels = null;
            }
        }
        if (pixels == null) {
            BufferedImage image = RenderUtils.getTextureImage(this.location, !this.forceReadFromFile ? getter : null);
            if (image == null) {
                return false;
            }
            width = image.getWidth();
            height = image.getHeight();
            if (this.useLargestSize) {
                for (ResourceLocation depLoc : this.deps) {
                    TextureAtlasSprite sprite = getter.apply(depLoc);
                    if (sprite.func_94211_a() <= width || sprite.func_94216_b() <= height) continue;
                    width = sprite.func_94211_a();
                    height = sprite.func_94216_b();
                }
            }
            if (width != image.getWidth() || height != image.getHeight()) {
                BufferedImage oldImage = image;
                image = new BufferedImage(width, height, image.getType());
                Graphics2D g = image.createGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                g.drawImage(oldImage, 0, 0, width, height, 0, 0, oldImage.getWidth(), oldImage.getHeight(), null);
                g.dispose();
            }
            pixels = new int[width * height];
            image.getRGB(0, 0, width, height, pixels, 0, width);
        }
        this.operator.apply(pixels, width, getter);
        try {
            this.addFrameTextureData(width, height, pixels, manager.func_110536_a(RenderUtils.toTextureFilePath(this.location)));
        }
        catch (IOException e) {
            e.printStackTrace();
            this.addFrameTextureData(width, height, pixels);
        }
        return false;
    }

    public Collection<ResourceLocation> getDependencies() {
        return this.deps;
    }

    @FunctionalInterface
    public static interface OperatorForEach {
        public int apply(int var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface Operator {
        public void apply(int[] var1, int var2, Function<ResourceLocation, TextureAtlasSprite> var3);
    }
}

