/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.notify;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import pl.asie.charset.lib.notify.NoticeStyle;
import pl.asie.charset.lib.notify.NotificationCoord;
import pl.asie.charset.lib.notify.component.NotificationComponent;

class ClientMessage {
    World world;
    Object locus;
    private NotificationComponent msg;
    String msgRendered;
    Collection<NoticeStyle> style;
    long creationTime;
    long lifeTime;
    boolean position_important = false;
    boolean show_item = false;
    static final int SHORT_TIME = 6;
    static final int LONG_TIME = 11;
    static final int VERY_LONG_TIME = 60;

    public ClientMessage(World world, Object locus, Collection<NoticeStyle> styles, NotificationComponent msg) {
        this.world = world;
        this.locus = locus;
        this.msg = msg;
        this.style = styles;
        this.creationTime = System.currentTimeMillis();
        this.lifeTime = this.style.contains((Object)NoticeStyle.LONG) ? 11000L : 6000L;
        this.position_important = this.style.contains((Object)NoticeStyle.EXACTPOSITION);
        this.show_item = this.style.contains((Object)NoticeStyle.DRAWITEM);
        this.translate();
    }

    void setMessage(NotificationComponent msg) {
        this.msg = msg;
        this.translate();
    }

    void translate() {
        this.msgRendered = this.msg.toString().replace("\\n", "\n");
    }

    static double interp(double old, double new_, float partial) {
        return old * (double)(1.0f - partial) + new_ * (double)partial;
    }

    Vec3d getPosition(float partial) {
        if (this.locus instanceof Vec3d) {
            return (Vec3d)this.locus;
        }
        if (this.locus instanceof Entity) {
            Entity e = (Entity)this.locus;
            double w = e.field_70130_N * -1.0f;
            double x = ClientMessage.interp(e.field_70142_S, e.field_70165_t, partial) + w / 2.0;
            double y = ClientMessage.interp(e.field_70137_T, e.field_70163_u, partial) + (double)e.field_70131_O;
            double z = ClientMessage.interp(e.field_70136_U, e.field_70161_v, partial) + w / 2.0;
            return new Vec3d(x, y, z);
        }
        if (this.locus instanceof TileEntity) {
            TileEntity te = (TileEntity)this.locus;
            return new Vec3d((Vec3i)te.func_174877_v());
        }
        if (this.locus instanceof NotificationCoord) {
            return new Vec3d((Vec3i)((NotificationCoord)this.locus).getPos());
        }
        return null;
    }

    boolean stillValid() {
        if (this.locus instanceof Entity) {
            Entity e = (Entity)this.locus;
            return !e.field_70128_L;
        }
        if (this.locus instanceof TileEntity) {
            TileEntity te = (TileEntity)this.locus;
            return !te.func_145837_r();
        }
        return true;
    }

    @Nullable
    public NotificationCoord asCoord() {
        if (this.locus instanceof TileEntity) {
            TileEntity te = (TileEntity)this.locus;
            return new NotificationCoord(te.func_145831_w(), te.func_174877_v());
        }
        if (this.locus instanceof NotificationCoord) {
            return new NotificationCoord(((NotificationCoord)this.locus).getWorld(), ((NotificationCoord)this.locus).getPos());
        }
        return null;
    }

    public NotificationComponent getMessage() {
        return this.msg;
    }
}

