/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.handlers;

import gnu.trove.list.array.TIntArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import pl.asie.charset.lib.handlers.ShiftScrollHandler;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.utils.ItemUtils;

public class PacketRequestScroll
extends Packet {
    private int currPos;
    private int wheel;

    public PacketRequestScroll(int currPos, int wheel) {
        this.currPos = currPos;
        this.wheel = wheel;
    }

    public PacketRequestScroll() {
    }

    @Override
    public void readData(INetHandler handler, PacketBuffer buf) {
        this.currPos = buf.readUnsignedByte();
        this.wheel = buf.readInt();
    }

    @Override
    public void apply(INetHandler handler) {
        EntityPlayer player = PacketRequestScroll.getPlayer(handler);
        ItemStack currStack = player.field_71071_by.func_70301_a(this.currPos);
        ShiftScrollHandler.Provider provider = ShiftScrollHandler.INSTANCE.getMatchingProvider(currStack);
        if (!currStack.func_190926_b() && provider != null) {
            if (player.func_184812_l_()) {
                ItemStack compStack;
                int i;
                NonNullList stacks = NonNullList.func_191196_a();
                provider.addAllMatching((NonNullList<ItemStack>)stacks);
                int id = -1;
                for (i = 0; i < stacks.size(); ++i) {
                    compStack = (ItemStack)stacks.get(i);
                    if (!ItemUtils.equals(currStack, compStack, false, currStack.func_77981_g(), true)) continue;
                    id = i;
                    break;
                }
                if (id < 0) {
                    for (i = 0; i < stacks.size(); ++i) {
                        compStack = (ItemStack)stacks.get(i);
                        if (!ItemUtils.equals(currStack, compStack, false, currStack.func_77981_g(), false)) continue;
                        id = i;
                        break;
                    }
                }
                if (id >= 0) {
                    int newPos;
                    for (newPos = (id + (this.wheel < 0 ? 1 : -1)) % stacks.size(); newPos < 0; newPos += stacks.size()) {
                    }
                    ItemStack newStack = ((ItemStack)stacks.get(newPos)).func_77946_l();
                    newStack.func_190920_e(currStack.func_190916_E());
                    player.func_184611_a(EnumHand.MAIN_HAND, newStack);
                    return;
                }
            } else {
                NonNullList mainInv = player.field_71071_by.field_70462_a;
                TIntArrayList intList = new TIntArrayList(mainInv.size());
                for (int i = 0; i < mainInv.size(); ++i) {
                    int pos;
                    for (pos = (player.field_71071_by.field_70461_c + (this.wheel < 0 ? -i : i)) % mainInv.size(); pos < 0; pos += mainInv.size()) {
                    }
                    ItemStack compStack = (ItemStack)mainInv.get(pos);
                    if (!provider.matches(compStack)) continue;
                    intList.add(pos);
                }
                if (intList.size() >= 2) {
                    ItemStack temp = null;
                    for (int i = 0; i < intList.size() + 1; ++i) {
                        int pos = intList.get(i % intList.size());
                        if (temp == null) {
                            temp = (ItemStack)mainInv.get(pos);
                            continue;
                        }
                        ItemStack target = (ItemStack)mainInv.get(pos);
                        player.field_71071_by.func_70299_a(pos, temp);
                        temp = target;
                    }
                }
            }
        }
    }

    @Override
    public void writeData(PacketBuffer buf) {
        buf.writeByte(this.currPos);
        buf.writeInt(this.wheel);
    }

    @Override
    public boolean isAsynchronous() {
        return false;
    }
}

