/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.audio.types;

import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import pl.asie.charset.api.audio.AudioSink;
import pl.asie.charset.lib.utils.Utils;

public class AudioSinkBlock
extends AudioSink {
    private World world;
    private Vec3d pos;

    public AudioSinkBlock() {
    }

    public AudioSinkBlock(World world, BlockPos pos) {
        this.world = world;
        this.pos = new Vec3d((Vec3i)pos);
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public Vec3d getPos() {
        return this.pos;
    }

    @Override
    public float getDistance() {
        return 32.0f;
    }

    @Override
    public float getVolume() {
        return 1.0f;
    }

    @Override
    public void writeData(ByteBuf buf) {
        super.writeData(buf);
        buf.writeInt(this.world.field_73011_w.getDimension());
        buf.writeDouble(this.pos.field_72450_a);
        buf.writeDouble(this.pos.field_72448_b);
        buf.writeDouble(this.pos.field_72449_c);
    }

    @Override
    public void readData(ByteBuf buf) {
        super.readData(buf);
        int dimId = buf.readInt();
        double xPos = buf.readDouble();
        double yPos = buf.readDouble();
        double zPos = buf.readDouble();
        this.world = Utils.getLocalWorld(dimId);
        this.pos = new Vec3d(xPos, yPos, zPos);
    }
}

