/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.network;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.core.network.FluidNetwork;

public class FluidChannel
implements IFluidHandler {
    final FluidNetwork network;
    final int channel;

    FluidChannel(FluidNetwork network, int channel) {
        this.network = network;
        this.channel = channel;
    }

    public IFluidTankProperties[] getTankProperties() {
        ArrayList properties = Lists.newArrayList();
        for (IPositionedAddonsNetwork.PrioritizedPartPos partPos : this.network.getPositions(this.channel)) {
            IFluidHandler fluidHandler = this.network.getFluidHandler(partPos);
            if (fluidHandler == null) continue;
            this.network.disablePosition(partPos.getPartPos());
            properties.addAll(Lists.newArrayList((Object[])fluidHandler.getTankProperties()));
            this.network.enablePosition(partPos.getPartPos());
        }
        return properties.toArray(new IFluidTankProperties[properties.size()]);
    }

    public int fill(FluidStack resource, boolean doFill) {
        int amount = FluidHelpers.getAmount((FluidStack)resource);
        int toFill = amount = Math.min(amount, GeneralConfig.fluidRateLimit);
        IPositionedAddonsNetwork.PositionsIterator it = this.network.getPositionIterator(this.channel);
        while (it.hasNext() && toFill > 0) {
            IPositionedAddonsNetwork.PrioritizedPartPos partPos = it.next();
            IFluidHandler fluidHandler = this.network.getFluidHandler(partPos);
            if (fluidHandler == null) continue;
            this.network.disablePosition(partPos.getPartPos());
            this.network.enablePosition(partPos.getPartPos());
            if ((toFill -= fluidHandler.fill(resource, doFill)) > 0) continue;
            break;
        }
        if (doFill) {
            this.network.setPositionIterator(it, this.channel);
        }
        return amount - toFill;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        int drained;
        resource = resource.copy();
        int maxDrain = FluidHelpers.getAmount((FluidStack)resource);
        maxDrain = Math.min(maxDrain, GeneralConfig.fluidRateLimit);
        FluidStack fluid = null;
        IPositionedAddonsNetwork.PositionsIterator it = this.network.getPositionIterator(this.channel);
        while (it.hasNext() && resource.amount > 0) {
            IPositionedAddonsNetwork.PrioritizedPartPos partPos = it.next();
            IFluidHandler fluidHandler = this.network.getFluidHandler(partPos);
            if (fluidHandler == null) continue;
            this.network.disablePosition(partPos.getPartPos());
            FluidStack drainedFluid = fluidHandler.drain(resource, doDrain);
            this.network.enablePosition(partPos.getPartPos());
            resource.amount -= FluidHelpers.getAmount((FluidStack)drainedFluid);
            if (drainedFluid != null) {
                fluid = drainedFluid;
            }
            if (resource.amount > 0) continue;
            break;
        }
        if (doDrain) {
            this.network.setPositionIterator(it, this.channel);
        }
        return (drained = maxDrain - resource.amount) <= 0 ? null : new FluidStack(fluid, drained);
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        int drained;
        int toDrain = maxDrain = Math.min(maxDrain, GeneralConfig.fluidRateLimit);
        FluidStack fluid = null;
        IPositionedAddonsNetwork.PositionsIterator it = this.network.getPositionIterator(this.channel);
        while (it.hasNext() && toDrain > 0) {
            IPositionedAddonsNetwork.PrioritizedPartPos partPos = it.next();
            IFluidHandler fluidHandler = this.network.getFluidHandler(partPos);
            if (fluidHandler == null) continue;
            this.network.disablePosition(partPos.getPartPos());
            FluidStack drainedFluid = fluidHandler.drain(toDrain, doDrain);
            this.network.enablePosition(partPos.getPartPos());
            toDrain -= FluidHelpers.getAmount((FluidStack)drainedFluid);
            if (drainedFluid != null) {
                fluid = drainedFluid;
            }
            if (toDrain > 0) continue;
            break;
        }
        if (doDrain) {
            this.network.setPositionIterator(it, this.channel);
        }
        return (drained = maxDrain - toDrain) <= 0 ? null : new FluidStack(fluid, drained);
    }
}

