/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;

public class TileEntityFeeder
extends TileEntityInventoryBase {
    public static final int THRESHOLD = 30;
    private static final int TIME = 100;
    public int currentTimer;
    public int currentAnimalAmount;
    private int lastAnimalAmount;
    private int lastTimer;

    public TileEntityFeeder() {
        super(1, "feeder");
    }

    public int getCurrentTimerToScale(int i) {
        return this.currentTimer * i / 100;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        compound.func_74768_a("Timer", this.currentTimer);
        if (type == TileEntityBase.NBTType.SYNC) {
            compound.func_74768_a("Animals", this.currentAnimalAmount);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.currentTimer = compound.func_74762_e("Timer");
        if (type == TileEntityBase.NBTType.SYNC) {
            this.currentAnimalAmount = compound.func_74762_e("Animals");
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        this.currentTimer = MathHelper.func_76125_a((int)(++this.currentTimer), (int)0, (int)100);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int range = 5;
        ItemStack stack = this.inv.getStackInSlot(0);
        if (!stack.func_190926_b() && this.currentTimer >= 100) {
            Optional<EntityAnimal> opt;
            List animals = this.field_145850_b.func_72872_a(EntityAnimal.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - range), (double)(this.field_174879_c.func_177956_o() - range), (double)(this.field_174879_c.func_177952_p() - range), (double)(this.field_174879_c.func_177958_n() + range), (double)(this.field_174879_c.func_177956_o() + range), (double)(this.field_174879_c.func_177952_p() + range)));
            this.currentAnimalAmount = animals.size();
            if (this.currentAnimalAmount >= 2 && this.currentAnimalAmount < 30 && (opt = animals.stream().filter(e -> TileEntityFeeder.canBeFed(stack, e)).findAny()).isPresent()) {
                TileEntityFeeder.feedAnimal(opt.get());
                stack.func_190918_g(1);
                this.currentTimer = 0;
                this.func_70296_d();
            }
        }
        if ((this.lastAnimalAmount != this.currentAnimalAmount || this.lastTimer != this.currentTimer) && this.sendUpdateWithInterval()) {
            this.lastAnimalAmount = this.currentAnimalAmount;
            this.lastTimer = this.currentTimer;
        }
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> !automation;
    }

    private static void feedAnimal(EntityAnimal animal) {
        animal.func_146082_f(null);
        for (int i = 0; i < 7; ++i) {
            double d = animal.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            double d1 = animal.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            double d2 = animal.field_70170_p.field_73012_v.nextGaussian() * 0.02;
            animal.field_70170_p.func_175688_a(EnumParticleTypes.HEART, animal.field_70165_t + (double)(animal.field_70170_p.field_73012_v.nextFloat() * animal.field_70130_N * 2.0f) - (double)animal.field_70130_N, animal.field_70163_u + 0.5 + (double)(animal.field_70170_p.field_73012_v.nextFloat() * animal.field_70131_O), animal.field_70161_v + (double)(animal.field_70170_p.field_73012_v.nextFloat() * animal.field_70130_N * 2.0f) - (double)animal.field_70130_N, d, d1, d2, new int[0]);
        }
    }

    private static boolean canBeFed(ItemStack stack, EntityAnimal animal) {
        if (animal instanceof EntityHorse && ((EntityHorse)animal).func_110248_bS()) {
            Item item = stack.func_77973_b();
            return animal.func_70874_b() == 0 && !animal.func_70880_s() && (item == Items.field_151153_ao || item == Items.field_151150_bK);
        }
        return animal.func_70874_b() == 0 && !animal.func_70880_s() && animal.func_70877_b(stack);
    }
}

