/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.recipe.CoffeeIngredient;
import de.ellpeck.actuallyadditions.mod.items.InitItems;
import de.ellpeck.actuallyadditions.mod.items.ItemCoffee;
import de.ellpeck.actuallyadditions.mod.items.metalists.TheMiscItems;
import de.ellpeck.actuallyadditions.mod.misc.SoundHandler;
import de.ellpeck.actuallyadditions.mod.network.gui.IButtonReactor;
import de.ellpeck.actuallyadditions.mod.tile.CustomEnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.ISharingFluidHandler;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.ItemStackHandlerAA;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCoffeeMachine
extends TileEntityInventoryBase
implements IButtonReactor,
ISharingFluidHandler {
    public static final int SLOT_COFFEE_BEANS = 0;
    public static final int SLOT_INPUT = 1;
    public static final int SLOT_OUTPUT = 2;
    public static final int CACHE_USE = 35;
    public static final int ENERGY_USED = 150;
    public static final int WATER_USE = 500;
    public static final int COFFEE_CACHE_MAX_AMOUNT = 300;
    private static final int TIME_USED = 500;
    public final CustomEnergyStorage storage = new CustomEnergyStorage(300000, 250, 0);
    public final FluidTank tank = new FluidTank(4000){

        public boolean canDrain() {
            return false;
        }

        public boolean canFillFluidType(FluidStack fluid) {
            return fluid.getFluid() == FluidRegistry.WATER;
        }
    };
    public int coffeeCacheAmount;
    public int brewTime;
    private int lastEnergy;
    private int lastTank;
    private int lastCoffeeAmount;
    private int lastBrewTime;

    public TileEntityCoffeeMachine() {
        super(11, "coffeeMachine");
    }

    @SideOnly(value=Side.CLIENT)
    public int getCoffeeScaled(int i) {
        return this.coffeeCacheAmount * i / 300;
    }

    @SideOnly(value=Side.CLIENT)
    public int getWaterScaled(int i) {
        return this.tank.getFluidAmount() * i / this.tank.getCapacity();
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @SideOnly(value=Side.CLIENT)
    public int getBrewScaled(int i) {
        return this.brewTime * i / 500;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
        this.tank.writeToNBT(compound);
        compound.func_74768_a("Cache", this.coffeeCacheAmount);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("Time", this.brewTime);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
        this.tank.readFromNBT(compound);
        this.coffeeCacheAmount = compound.func_74762_e("Cache");
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.brewTime = compound.func_74762_e("Time");
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            this.storeCoffee();
            if (this.brewTime > 0 || this.isRedstonePowered) {
                this.brew();
            }
            if ((this.coffeeCacheAmount != this.lastCoffeeAmount || this.storage.getEnergyStored() != this.lastEnergy || this.tank.getFluidAmount() != this.lastTank || this.brewTime != this.lastBrewTime) && this.sendUpdateWithInterval()) {
                this.lastCoffeeAmount = this.coffeeCacheAmount;
                this.lastEnergy = this.storage.getEnergyStored();
                this.lastTank = this.tank.getFluidAmount();
                this.lastBrewTime = this.brewTime;
            }
        }
    }

    @Override
    public ItemStackHandlerAA.IAcceptor getAcceptor() {
        return (slot, stack, automation) -> slot >= 3 && ItemCoffee.getIngredientFromStack(stack) != null || slot == 0 && stack.func_77973_b() == InitItems.itemCoffeeBean || slot == 1 && stack.func_77973_b() == InitItems.itemMisc && stack.func_77952_i() == TheMiscItems.CUP.ordinal();
    }

    @Override
    public ItemStackHandlerAA.IRemover getRemover() {
        return (slot, automation) -> slot == 2 || slot >= 3 && slot < this.inv.getSlots() && ItemCoffee.getIngredientFromStack(this.inv.getStackInSlot(slot)) == null;
    }

    public void storeCoffee() {
        int toAdd;
        if (StackUtil.isValid(this.inv.getStackInSlot(0)) && this.inv.getStackInSlot(0).func_77973_b() == InitItems.itemCoffeeBean && (toAdd = 2) <= 300 - this.coffeeCacheAmount) {
            this.inv.setStackInSlot(0, StackUtil.shrink(this.inv.getStackInSlot(0), 1));
            this.coffeeCacheAmount += toAdd;
        }
    }

    public void brew() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack input = this.inv.getStackInSlot(1);
            if (StackUtil.isValid(input) && input.func_77973_b() == InitItems.itemMisc && input.func_77952_i() == TheMiscItems.CUP.ordinal() && !StackUtil.isValid(this.inv.getStackInSlot(2)) && this.coffeeCacheAmount >= 35 && this.tank.getFluid() != null && this.tank.getFluid().getFluid() == FluidRegistry.WATER && this.tank.getFluidAmount() >= 500) {
                if (this.storage.getEnergyStored() >= 150) {
                    if (this.brewTime % 30 == 0) {
                        this.field_145850_b.func_184148_a(null, (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), SoundHandler.coffeeMachine, SoundCategory.BLOCKS, 0.35f, 1.0f);
                    }
                    ++this.brewTime;
                    this.storage.extractEnergyInternal(150, false);
                    if (this.brewTime >= 500) {
                        this.brewTime = 0;
                        ItemStack output = new ItemStack(InitItems.itemCoffee);
                        for (int i = 3; i < this.inv.getSlots(); ++i) {
                            CoffeeIngredient ingredient;
                            if (!StackUtil.isValid(this.inv.getStackInSlot(i)) || (ingredient = ItemCoffee.getIngredientFromStack(this.inv.getStackInSlot(i))) == null || !ingredient.effect(output)) continue;
                            this.inv.setStackInSlot(i, StackUtil.shrinkForContainer(this.inv.getStackInSlot(i), 1));
                        }
                        this.inv.setStackInSlot(2, output.func_77946_l());
                        this.inv.getStackInSlot(1).func_190918_g(1);
                        this.coffeeCacheAmount -= 35;
                        this.tank.drainInternal(500, true);
                    }
                }
            } else {
                this.brewTime = 0;
            }
        }
    }

    @Override
    public void onButtonPressed(int buttonID, EntityPlayer player) {
        if (buttonID == 0 && this.brewTime <= 0) {
            this.brew();
        }
    }

    public FluidTank getFluidHandler(EnumFacing facing) {
        return this.tank;
    }

    @Override
    public int getMaxFluidAmountToSplitShare() {
        return 0;
    }

    @Override
    public boolean doesShareFluid() {
        return false;
    }

    @Override
    public EnumFacing[] getFluidShareSides() {
        return null;
    }

    @Override
    public IEnergyStorage getEnergyStorage(EnumFacing facing) {
        return this.storage;
    }
}

