/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.recipe;

import de.ellpeck.actuallyadditions.api.ActuallyAdditionsAPI;
import de.ellpeck.actuallyadditions.api.recipe.CrusherRecipe;
import de.ellpeck.actuallyadditions.mod.ActuallyAdditions;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigStringListValues;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;

public final class CrusherRecipeRegistry {
    public static final ArrayList<SearchCase> SEARCH_CASES = new ArrayList();

    public static void registerFinally() {
        ArrayList<String> oresNoResult = new ArrayList<String>();
        int recipeStartedAt = ActuallyAdditionsAPI.CRUSHER_RECIPES.size();
        for (String ore : OreDictionary.getOreNames()) {
            if (CrusherRecipeRegistry.hasException(ore)) continue;
            for (SearchCase theCase : SEARCH_CASES) {
                if (ore.length() <= theCase.theCase.length() || !ore.substring(0, theCase.theCase.length()).equals(theCase.theCase)) continue;
                String outputOre = theCase.resultPreString + ore.substring(theCase.theCase.length());
                NonNullList outputs = OreDictionary.getOres((String)outputOre, (boolean)false);
                ItemStack output = outputs.isEmpty() ? ItemStack.field_190927_a : ((ItemStack)outputs.get(0)).func_77946_l();
                output.func_190920_e(theCase.resultAmount);
                if (output.func_190926_b()) {
                    if (oresNoResult.contains(ore)) continue;
                    oresNoResult.add(ore);
                    continue;
                }
                ActuallyAdditionsAPI.addCrusherRecipe((Ingredient)new OreIngredient(ore), output, StackUtil.getEmpty(), 0);
            }
        }
        ArrayList<String> addedRecipes = new ArrayList<String>();
        for (int i = recipeStartedAt; i < ActuallyAdditionsAPI.CRUSHER_RECIPES.size(); ++i) {
            CrusherRecipe recipe = ActuallyAdditionsAPI.CRUSHER_RECIPES.get(i);
            addedRecipes.add(recipe.getInput().func_193365_a() + " -> " + recipe.getOutputOne());
        }
        ActuallyAdditions.LOGGER.debug("Added " + addedRecipes.size() + " Crusher Recipes automatically: " + addedRecipes);
        ActuallyAdditions.LOGGER.debug("Couldn't add " + oresNoResult.size() + " Crusher Recipes automatically, either because the inputs were missing outputs, or because they exist already: " + oresNoResult);
        CrusherRecipeRegistry.removeDuplicateRecipes();
    }

    public static void removeDuplicateRecipes() {
        ArrayList<CrusherRecipe> usable = new ArrayList<CrusherRecipe>();
        ArrayList<CrusherRecipe> removed = new ArrayList<CrusherRecipe>();
        for (CrusherRecipe r : ActuallyAdditionsAPI.CRUSHER_RECIPES) {
            boolean canUse = true;
            if (r.getInput().func_193365_a().length == 0) {
                canUse = false;
            } else {
                for (CrusherRecipe re : usable) {
                    if (!re.getInput().apply(r.getInput().func_193365_a()[0])) continue;
                    canUse = false;
                }
            }
            if (canUse) {
                usable.add(r);
                continue;
            }
            removed.add(r);
        }
        ActuallyAdditionsAPI.CRUSHER_RECIPES.clear();
        ActuallyAdditionsAPI.CRUSHER_RECIPES.addAll(usable);
        ActuallyAdditions.LOGGER.debug(String.format("Removed %s crusher recipes that had dupliate inputs, %s remain.", removed.size(), usable.size()));
    }

    public static boolean hasBlacklistedOutput(ItemStack output, String[] config) {
        Item item;
        if (StackUtil.isValid(output) && (item = output.func_77973_b()) != null) {
            String reg = item.getRegistryName().toString();
            String[] stringArray = config;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String conf;
                String confReg = conf = stringArray[i];
                int meta = 0;
                if (conf.contains("@")) {
                    try {
                        String[] split = conf.split("@");
                        confReg = split[0];
                        meta = Integer.parseInt(split[1]);
                    }
                    catch (Exception e) {
                        ActuallyAdditions.LOGGER.warn("A config option appears to be incorrect: The entry " + conf + " can't be parsed!");
                    }
                }
                if (!reg.equals(confReg) || output.func_77952_i() != meta) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean hasException(String ore) {
        for (String conf : ConfigStringListValues.CRUSHER_RECIPE_EXCEPTIONS.getValue()) {
            if (!conf.equals(ore)) continue;
            return true;
        }
        return false;
    }

    public static CrusherRecipe getRecipeFromInput(ItemStack input) {
        for (CrusherRecipe recipe : ActuallyAdditionsAPI.CRUSHER_RECIPES) {
            if (!recipe.matches(input)) continue;
            return recipe;
        }
        return null;
    }

    public static class SearchCase {
        final String theCase;
        final int resultAmount;
        final String resultPreString;

        public SearchCase(String theCase, int resultAmount) {
            this(theCase, resultAmount, "dust");
        }

        public SearchCase(String theCase, int resultAmount, String resultPreString) {
            this.theCase = theCase;
            this.resultAmount = resultAmount;
            this.resultPreString = resultPreString;
        }
    }
}

