/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.util;

import com.feed_the_beast.ftblib.events.player.ForgePlayerLoggedInEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamCreatedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamDataEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamDeletedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamLoadedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamPlayerJoinedEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamPlayerLeftEvent;
import com.feed_the_beast.ftblib.events.team.ForgeTeamSavedEvent;
import com.feed_the_beast.ftblib.lib.data.ForgePlayer;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.TeamData;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.net.MessageChangedTeam;
import com.feed_the_beast.ftbquests.net.MessageClaimRewardResponse;
import com.feed_the_beast.ftbquests.net.MessageCreateTeamData;
import com.feed_the_beast.ftbquests.net.MessageDeleteTeamData;
import com.feed_the_beast.ftbquests.net.MessageSyncQuests;
import com.feed_the_beast.ftbquests.net.MessageUpdateTaskProgress;
import com.feed_the_beast.ftbquests.net.MessageUpdateVariable;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.QuestReward;
import com.feed_the_beast.ftbquests.quest.QuestVariable;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTaskData;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="ftbquests")
public class FTBQuestsTeamData
extends TeamData
implements ITeamData {
    private final Map<QuestTask, QuestTaskData> taskData = new HashMap<QuestTask, QuestTaskData>();
    public final Map<UUID, IntOpenHashSet> claimedPlayerRewards = new HashMap<UUID, IntOpenHashSet>();
    public final IntOpenHashSet claimedTeamRewards = new IntOpenHashSet();
    public final Object2LongOpenHashMap<QuestVariable> variables = new Object2LongOpenHashMap();

    public static FTBQuestsTeamData get(ForgeTeam team) {
        return (FTBQuestsTeamData)team.getData().get("ftbquests");
    }

    @SubscribeEvent
    public static void registerTeamData(ForgeTeamDataEvent event) {
        event.register((TeamData)new FTBQuestsTeamData(event.getTeam()));
    }

    @SubscribeEvent
    public static void onTeamSaved(ForgeTeamSavedEvent event) {
        NBTTagCompound nbt = new NBTTagCompound();
        FTBQuestsTeamData data = FTBQuestsTeamData.get(event.getTeam());
        data.writeData(nbt);
        File file = event.getTeam().getDataFile("ftbquests");
        if (nbt.func_82582_d()) {
            FileUtils.delete((File)file);
        } else {
            NBTUtils.writeNBTSafe((File)file, (NBTTagCompound)nbt);
        }
    }

    @SubscribeEvent
    public static void onTeamLoaded(ForgeTeamLoadedEvent event) {
        FTBQuestsTeamData data = FTBQuestsTeamData.get(event.getTeam());
        for (QuestTask task : ServerQuestFile.INSTANCE.allTasks) {
            data.createTaskData(task);
        }
        NBTTagCompound nbt = NBTUtils.readNBT((File)event.getTeam().getDataFile("ftbquests"));
        data.readData(nbt == null ? new NBTTagCompound() : nbt);
    }

    @SubscribeEvent
    public static void onTeamCreated(ForgeTeamCreatedEvent event) {
        FTBQuestsTeamData data = FTBQuestsTeamData.get(event.getTeam());
        for (QuestTask task : ServerQuestFile.INSTANCE.allTasks) {
            data.createTaskData(task);
        }
        new MessageCreateTeamData(event.getTeam().func_176610_l()).sendToAll();
    }

    @SubscribeEvent
    public static void onTeamDeleted(ForgeTeamDeletedEvent event) {
        FileUtils.delete((File)event.getTeam().getDataFile("ftbquests"));
        new MessageDeleteTeamData(event.getTeam().func_176610_l()).sendToAll();
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(ForgePlayerLoggedInEvent event) {
        Object team2;
        EntityPlayerMP player = event.getPlayer().getPlayer();
        ArrayList<MessageSyncQuests.TeamInst> teamData = new ArrayList<MessageSyncQuests.TeamInst>();
        for (Object team2 : event.getUniverse().getTeams()) {
            FTBQuestsTeamData data = FTBQuestsTeamData.get(team2);
            MessageSyncQuests.TeamInst t = new MessageSyncQuests.TeamInst();
            t.name = team2.func_176610_l();
            int size = 0;
            for (QuestTaskData taskData : data.taskData.values()) {
                if (taskData.toNBT() == null) continue;
                ++size;
            }
            t.taskKeys = new short[size];
            t.taskValues = new NBTBase[size];
            int i = 0;
            for (QuestTaskData taskData : data.taskData.values()) {
                NBTBase nbt = taskData.toNBT();
                if (nbt == null) continue;
                t.taskKeys[i] = ((QuestTask)taskData.task).index;
                t.taskValues[i] = nbt;
                ++i;
            }
            size = 0;
            for (Object2LongMap.Entry entry : data.variables.object2LongEntrySet()) {
                if (entry.getLongValue() <= 0L) continue;
                ++size;
            }
            t.variableKeys = new short[size];
            t.variableValues = new long[size];
            i = 0;
            for (Object2LongMap.Entry entry : data.variables.object2LongEntrySet()) {
                long value = entry.getLongValue();
                if (value <= 0L) continue;
                t.variableKeys[i] = ((QuestVariable)entry.getKey()).index;
                t.variableValues[i] = value;
                ++i;
            }
            teamData.add(t);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        ServerQuestFile.INSTANCE.writeData(nbt);
        team2 = FTBQuestsTeamData.get(event.getTeam());
        IntOpenHashSet rewards = team2.claimedPlayerRewards.get(event.getPlayer().getId());
        if (rewards == null) {
            rewards = team2.claimedTeamRewards;
        } else {
            rewards = new IntOpenHashSet((IntCollection)rewards);
            rewards.addAll((IntCollection)team2.claimedTeamRewards);
        }
        new MessageSyncQuests(nbt, event.getPlayer().team.func_176610_l(), teamData, FTBQuests.canEdit(player), (IntCollection)rewards).sendTo(player);
    }

    @SubscribeEvent
    public static void onPlayerLeftTeam(ForgeTeamPlayerLeftEvent event) {
        if (event.getPlayer().isOnline()) {
            new MessageChangedTeam("").sendTo(event.getPlayer().getPlayer());
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinedTeam(ForgeTeamPlayerJoinedEvent event) {
        if (event.getPlayer().isOnline()) {
            new MessageChangedTeam(event.getTeam().func_176610_l()).sendTo(event.getPlayer().getPlayer());
        }
    }

    private FTBQuestsTeamData(ForgeTeam team) {
        super(team);
        this.variables.defaultReturnValue(0L);
    }

    public String func_176610_l() {
        return "ftbquests";
    }

    @Override
    public void syncTask(QuestTaskData data) {
        this.team.markDirty();
        NBTBase nbt = data.toNBT();
        for (EntityPlayerMP player : this.team.universe.server.func_184103_al().func_181057_v()) {
            if (this.team.universe.getPlayer((ICommandSender)player).team.equalsTeam(this.team)) {
                new MessageUpdateTaskProgress("", ((QuestTask)data.task).index, nbt).sendTo(player);
                continue;
            }
            new MessageUpdateTaskProgress(this.team.func_176610_l(), ((QuestTask)data.task).index, nbt).sendTo(player);
        }
        if (!data.isComplete && ((QuestTask)data.task).isComplete(this)) {
            data.isComplete = true;
            if (((QuestTask)data.task).isComplete(this)) {
                ((QuestTask)data.task).onCompleted(this);
            }
        }
    }

    @Override
    public void removeTask(QuestTask task) {
        this.taskData.remove(task);
    }

    @Override
    public void createTaskData(QuestTask task) {
        QuestTaskData data = task.createData(this);
        this.taskData.put(task, data);
        data.isComplete = data.getProgress() >= ((QuestTask)data.task).getMaxProgress();
    }

    public void claimReward(EntityPlayer player, QuestReward reward) {
        if (reward.team) {
            if (this.claimedTeamRewards.add(reward.uid)) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)reward.stack.func_77946_l());
                this.team.markDirty();
                for (ForgePlayer player1 : this.team.getMembers()) {
                    if (!player1.isOnline()) continue;
                    new MessageClaimRewardResponse(reward.uid).sendTo(player1.getPlayer());
                }
            }
        } else {
            IntOpenHashSet set = this.claimedPlayerRewards.get(player.func_110124_au());
            if (set == null) {
                set = new IntOpenHashSet();
            }
            if (set.add(reward.uid)) {
                if (set.size() == 1) {
                    this.claimedPlayerRewards.put(player.func_110124_au(), set);
                }
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)reward.stack.func_77946_l());
                this.team.markDirty();
                new MessageClaimRewardResponse(reward.uid).sendTo((EntityPlayerMP)player);
            }
        }
    }

    @Override
    public void unclaimRewards(Collection<QuestReward> rewards) {
        for (QuestReward reward : rewards) {
            if (reward.team) {
                this.claimedTeamRewards.rem(reward.uid);
                continue;
            }
            Iterator<IntOpenHashSet> iterator = this.claimedPlayerRewards.values().iterator();
            while (iterator.hasNext()) {
                IntOpenHashSet set = iterator.next();
                if (set == null || !set.rem(reward.uid) || !set.isEmpty()) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public long getVariable(QuestVariable variable) {
        return this.variables.getLong((Object)variable);
    }

    @Override
    public void setVariable(QuestVariable variable, long value) {
        long prevValue = this.getVariable(variable);
        if (value <= 0L) {
            this.variables.removeLong((Object)variable);
        } else {
            this.variables.put((Object)variable, value);
        }
        if (prevValue != value) {
            this.team.markDirty();
            for (EntityPlayerMP player : this.team.universe.server.func_184103_al().func_181057_v()) {
                if (this.team.universe.getPlayer((ICommandSender)player).team.equalsTeam(this.team)) {
                    new MessageUpdateVariable("", variable.index, value).sendTo(player);
                    continue;
                }
                new MessageUpdateVariable(this.team.func_176610_l(), variable.index, value).sendTo(player);
            }
        }
    }

    @Nullable
    private static NBTTagCompound getTagCompound(NBTTagCompound nbt, String key) {
        NBTBase nbt1 = nbt.func_74781_a(key);
        return nbt1 instanceof NBTTagCompound ? (NBTTagCompound)nbt1 : null;
    }

    private void writeData(NBTTagCompound nbt) {
        NBTTagCompound nbt1 = new NBTTagCompound();
        for (QuestTaskData questTaskData : this.taskData.values()) {
            NBTTagCompound questTag;
            NBTBase nbt2 = questTaskData.toNBT();
            if (nbt2 == null) continue;
            NBTTagCompound chapterTag = FTBQuestsTeamData.getTagCompound(nbt1, ((QuestTask)questTaskData.task).quest.chapter.id);
            if (chapterTag == null) {
                chapterTag = new NBTTagCompound();
                nbt1.func_74782_a(((QuestTask)questTaskData.task).quest.chapter.id, (NBTBase)chapterTag);
            }
            if ((questTag = FTBQuestsTeamData.getTagCompound(chapterTag, ((QuestTask)questTaskData.task).quest.id)) == null) {
                questTag = new NBTTagCompound();
                chapterTag.func_74782_a(((QuestTask)questTaskData.task).quest.id, (NBTBase)questTag);
            }
            questTag.func_74782_a(((QuestTask)questTaskData.task).id, nbt2);
        }
        if (!nbt1.func_82582_d()) {
            nbt.func_74782_a("TaskData", (NBTBase)nbt1);
        }
        if (!this.claimedTeamRewards.isEmpty()) {
            nbt.func_74783_a("ClaimedTeamRewards", this.claimedTeamRewards.toIntArray());
        }
        if (!this.claimedPlayerRewards.isEmpty()) {
            nbt1 = new NBTTagCompound();
            for (Map.Entry entry : this.claimedPlayerRewards.entrySet()) {
                if (((IntOpenHashSet)entry.getValue()).isEmpty()) continue;
                nbt1.func_74783_a(StringUtils.fromUUID((UUID)((UUID)entry.getKey())), ((IntOpenHashSet)entry.getValue()).toIntArray());
            }
            if (!nbt1.func_82582_d()) {
                nbt.func_74782_a("ClaimedPlayerRewards", (NBTBase)nbt1);
            }
        }
        if (!this.variables.isEmpty()) {
            nbt1 = new NBTTagCompound();
            for (Object2LongMap.Entry entry : this.variables.object2LongEntrySet()) {
                nbt1.func_74772_a(((QuestVariable)entry.getKey()).id, entry.getLongValue());
            }
            nbt.func_74782_a("Variables", (NBTBase)nbt1);
        }
    }

    private void readData(NBTTagCompound nbt) {
        NBTTagCompound nbt1 = nbt.func_74775_l("TaskData");
        for (QuestTaskData data : this.taskData.values()) {
            NBTTagCompound questTag;
            NBTBase nbt2 = null;
            NBTTagCompound chapterTag = FTBQuestsTeamData.getTagCompound(nbt1, ((QuestTask)data.task).quest.chapter.id);
            if (chapterTag != null && (questTag = FTBQuestsTeamData.getTagCompound(chapterTag, ((QuestTask)data.task).quest.id)) != null) {
                nbt2 = questTag.func_74781_a(((QuestTask)data.task).id);
            }
            data.fromNBT(nbt2);
        }
        this.claimedTeamRewards.clear();
        for (Object r : (Iterator)nbt.func_74759_k("ClaimedTeamRewards")) {
            this.claimedTeamRewards.add((int)r);
        }
        this.claimedPlayerRewards.clear();
        nbt1 = nbt.func_74775_l("ClaimedPlayerRewards");
        for (String s : nbt1.func_150296_c()) {
            int[] ar;
            UUID id = StringUtils.fromString((String)s);
            if (id == null || (ar = nbt1.func_74759_k(s)).length <= 0) continue;
            IntOpenHashSet set = new IntOpenHashSet(ar.length);
            for (int r : ar) {
                set.add(r);
            }
            this.claimedPlayerRewards.put(id, set);
        }
        this.variables.clear();
        nbt1 = nbt.func_74775_l("Variables");
        for (String s : nbt1.func_150296_c()) {
            QuestVariable variable = ServerQuestFile.INSTANCE.getVariable('#' + s);
            if (variable == null) continue;
            this.variables.put((Object)variable, nbt1.func_74763_f(s));
        }
    }

    @Override
    public String getTeamID() {
        return this.team.func_176610_l();
    }

    @Override
    public QuestTaskData getQuestTaskData(QuestTask task) {
        QuestTaskData data = this.taskData.get(task);
        if (data == null) {
            return task.createData(this);
        }
        return data;
    }
}

