/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.util;

import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.io.Bits;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.gui.GuiSelectQuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ConfigQuestObject
extends ConfigString {
    public static final String ID = "ftbquests_object";
    private static final Pattern PATTERN = Pattern.compile("^(\\*|[a-z0-9_:#]{1,32})$");
    private final HashSet<QuestObjectType> types = new HashSet();

    public ConfigQuestObject(String s) {
        super(s, PATTERN);
    }

    public ConfigQuestObject addType(QuestObjectType type) {
        this.types.add(type);
        return this;
    }

    public boolean hasValidType(QuestObjectType type) {
        return this.types.contains((Object)type);
    }

    public String func_176610_l() {
        return ID;
    }

    public boolean getBoolean() {
        return false;
    }

    public int getInt() {
        return 0;
    }

    public ConfigQuestObject copy() {
        ConfigQuestObject object = new ConfigQuestObject(this.getString());
        object.types.addAll(this.types);
        return object;
    }

    public void onClicked(IOpenableGui gui, ConfigValueInstance inst, MouseButton button) {
        if (inst.getCanEdit()) {
            new GuiSelectQuestObject(this, gui).openGui();
        }
    }

    public void writeData(DataOut data) {
        data.writeString(this.getString());
        int i = 0;
        for (QuestObjectType type : this.types) {
            i |= type.getFlag();
        }
        data.writeByte(i);
    }

    public void readData(DataIn data) {
        this.setString(data.readString());
        this.types.clear();
        short i = data.readUnsignedByte();
        for (QuestObjectType type : QuestObjectType.VALUES) {
            if (!Bits.getFlag((int)i, (int)type.getFlag())) continue;
            this.types.add(type);
        }
    }

    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        QuestObject object;
        if (string.isEmpty() && this.types.contains((Object)QuestObjectType.FILE)) {
            if (!simulate) {
                this.setString("");
            }
            return true;
        }
        World world = null;
        if (sender != null) {
            world = sender.func_130014_f_();
        }
        if ((object = FTBQuests.PROXY.getQuestFile(world).get(string)) != null && this.types.contains((Object)object.getObjectType())) {
            if (!simulate) {
                this.setString(object.getID());
            }
            return true;
        }
        return false;
    }

    public void addInfo(ConfigValueInstance inst, List<String> list) {
        if (inst.getCanEdit() && !inst.getDefaultValue().isNull()) {
            list.add(TextFormatting.AQUA + "Default: " + TextFormatting.RESET + inst.getDefaultValue().getStringForGUI().func_150254_d());
        }
        if (this.types.size() == 1) {
            list.add(TextFormatting.AQUA + "Type: " + TextFormatting.RESET + I18n.func_135052_a((String)this.types.iterator().next().getTranslationKey(), (Object[])new Object[0]));
        } else {
            list.add(TextFormatting.AQUA + "Types:");
            for (QuestObjectType type : this.types) {
                list.add("> " + I18n.func_135052_a((String)type.getTranslationKey(), (Object[])new Object[0]));
            }
        }
    }

    public void setValueFromOtherValue(ConfigValue value) {
        this.setString(value.getString());
        if (value instanceof ConfigQuestObject) {
            this.types.clear();
            this.types.addAll(((ConfigQuestObject)value).types);
        }
    }
}

