/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.tile;

import com.feed_the_beast.ftblib.lib.config.ConfigBlockState;
import com.feed_the_beast.ftblib.lib.config.ConfigBoolean;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigNull;
import com.feed_the_beast.ftblib.lib.config.ConfigTeam;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.tile.EnumSaveType;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.block.BlockScreen;
import com.feed_the_beast.ftbquests.block.FTBQuestsBlocks;
import com.feed_the_beast.ftbquests.net.MessageOpenTask;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTaskData;
import com.feed_the_beast.ftbquests.tile.TileScreenBase;
import com.feed_the_beast.ftbquests.tile.TileScreenPart;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileScreenCore
extends TileScreenBase
implements IConfigCallback {
    public EnumFacing facing;
    public String team = "";
    public String quest = "";
    public String task = "";
    public int size = 0;
    public boolean indestructible = false;
    public IBlockState skin = BlockUtils.AIR_STATE;
    public boolean inputOnly = false;
    public ItemStack inputModeIcon = ItemStack.field_190927_a;
    private ITeamData cTeam;
    private QuestTask cTask;
    private QuestTaskData cTaskData;
    private Class currentCoreClass;
    private Class currentPartClass;

    protected void writeData(NBTTagCompound nbt, EnumSaveType type) {
        if (!type.item) {
            nbt.func_74778_a("Facing", this.getFacing().func_176610_l());
        }
        if (!this.team.isEmpty()) {
            nbt.func_74778_a("Team", this.team);
        }
        this.cTask = this.getTask();
        if (this.cTask != null) {
            this.quest = this.cTask.quest.getID();
            this.task = this.cTask.id;
        }
        if (!this.quest.isEmpty()) {
            nbt.func_74778_a("Quest", this.quest);
        }
        if (!this.task.isEmpty()) {
            nbt.func_74778_a("Task", this.task);
        }
        if (this.size > 0) {
            nbt.func_74774_a("Size", (byte)this.size);
        }
        if (this.indestructible) {
            nbt.func_74757_a("Indestructible", true);
        }
        if (this.skin != BlockUtils.AIR_STATE) {
            nbt.func_74778_a("Skin", BlockUtils.getNameFromState((IBlockState)this.skin));
        }
        if (this.inputOnly) {
            nbt.func_74757_a("InputOnly", true);
        }
        if (!this.inputModeIcon.func_190926_b()) {
            nbt.func_74782_a("InputModeIcon", (NBTBase)this.inputModeIcon.serializeNBT());
        }
    }

    protected void readData(NBTTagCompound nbt, EnumSaveType type) {
        if (!type.item) {
            this.facing = EnumFacing.func_176739_a((String)nbt.func_74779_i("Facing"));
        }
        this.team = nbt.func_74779_i("Team");
        this.quest = nbt.func_74779_i("Quest");
        this.task = nbt.func_74779_i("Task");
        this.size = nbt.func_74771_c("Size");
        this.indestructible = nbt.func_74767_n("Indestructible");
        this.skin = BlockUtils.getStateFromName((String)nbt.func_74779_i("Skin"));
        this.inputOnly = nbt.func_74767_n("InputOnly");
        this.inputModeIcon = new ItemStack(nbt.func_74775_l("InputModeIcon"));
        if (this.inputModeIcon.func_190926_b()) {
            this.inputModeIcon = ItemStack.field_190927_a;
        }
        this.func_145836_u();
    }

    public void writeToItem(ItemStack stack) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeData(nbt, EnumSaveType.ITEM);
        if (!nbt.func_82582_d()) {
            stack.func_77982_d(nbt);
        }
    }

    public void readFromItem(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        this.readData(nbt == null ? new NBTTagCompound() : nbt, EnumSaveType.ITEM);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        this.cTask = this.getTask();
        if (this.cTask != null && this.cTask.getMaxProgress() > 0L) {
            this.cTaskData = this.getTaskData();
            if (this.cTaskData == null) {
                return false;
            }
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this.cTask.canInsertItem() : this.cTaskData.hasCapability(capability, facing) && ((QuestTask)this.cTaskData.task).quest.canStartTasks(this.cTaskData.teamData)) {
                return true;
            }
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        this.cTask = this.getTask();
        if (this.cTask != null && this.cTask.getMaxProgress() > 0L) {
            this.cTaskData = this.getTaskData();
            if (this.cTaskData == null) {
                return null;
            }
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                if (this.cTask.canInsertItem()) {
                    return (T)this.cTaskData;
                }
            } else {
                Object object = this.cTaskData.getCapability(capability, facing);
                if (object != null && ((QuestTask)this.cTaskData.task).quest.canStartTasks(this.cTaskData.teamData)) {
                    return (T)object;
                }
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public EnumFacing getFacing() {
        if (this.facing == null) {
            IBlockState state = this.getBlockState();
            this.facing = state.func_177230_c() == FTBQuestsBlocks.SCREEN ? (EnumFacing)this.getBlockState().func_177229_b((IProperty)BlockHorizontal.field_185512_D) : EnumFacing.NORTH;
        }
        return this.facing;
    }

    @Override
    public TileScreenCore getScreen() {
        return this;
    }

    public void func_145836_u() {
        super.func_145836_u();
        this.facing = null;
        this.cTask = null;
        this.cTeam = null;
        this.cTaskData = null;
    }

    @Nullable
    public ITeamData getTeam() {
        if (this.team.isEmpty()) {
            return null;
        }
        if (this.cTeam == null) {
            this.cTeam = FTBQuests.PROXY.getQuestFile(this.field_145850_b).getData(this.team);
        }
        return this.cTeam;
    }

    @Nullable
    public QuestTask getTask() {
        if (this.quest.isEmpty()) {
            return null;
        }
        if (this.cTask == null || this.cTask.invalid) {
            QuestFile file = FTBQuests.PROXY.getQuestFile(this.field_145850_b);
            Quest q = file.getQuest(this.quest);
            this.cTask = q == null || q.tasks.isEmpty() ? null : (this.task.isEmpty() ? q.tasks.get(0) : file.getTask(q.getID() + ':' + this.task));
        }
        return this.cTask;
    }

    @Nullable
    public QuestTaskData getTaskData() {
        if (this.quest.isEmpty() || this.team.isEmpty()) {
            return null;
        }
        if (this.cTaskData == null || ((QuestTask)this.cTaskData.task).invalid) {
            this.cTask = this.getTask();
            if (this.cTask == null) {
                return null;
            }
            this.cTeam = this.getTeam();
            if (this.cTeam == null) {
                return null;
            }
            this.cTaskData = this.cTeam.getQuestTaskData(this.cTask);
        }
        return this.cTaskData;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return BlockScreen.getScreenAABB(this.field_174879_c, this.getFacing(), this.size);
    }

    public double func_145833_n() {
        double d = 32.0 * (double)(2 + this.size);
        return d * d;
    }

    public boolean isOwner(EntityPlayer player) {
        return this.team.isEmpty() || FTBLibAPI.isPlayerInTeam((UUID)player.func_110124_au(), (String)this.team);
    }

    public void onClicked(EntityPlayerMP player, EnumHand hand, double x, double y) {
        boolean editor = FTBQuests.canEdit(player);
        if (player.func_70093_af()) {
            if (editor || this.isOwner((EntityPlayer)player)) {
                this.cTask = this.getTask();
                if (this.cTask != null) {
                    this.quest = this.cTask.quest.getID();
                    this.task = this.cTask.id;
                    this.currentCoreClass = this.cTask.getScreenCoreClass();
                    this.currentPartClass = this.cTask.getScreenPartClass();
                } else {
                    this.currentCoreClass = TileScreenCore.class;
                    this.currentPartClass = TileScreenPart.class;
                }
                boolean editorOrDestructible = editor || !this.indestructible;
                ConfigGroup group0 = ConfigGroup.newGroup((String)"tile");
                group0.setDisplayName((ITextComponent)new TextComponentTranslation("tile.ftbquests.screen.name", new Object[0]));
                ConfigGroup group = group0.getGroup("ftbquests.screen");
                group.add("team", (ConfigValue)new ConfigTeam(this.team){

                    public void setString(String v) {
                        TileScreenCore.this.team = v;
                    }
                }, (ConfigValue)ConfigNull.INSTANCE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.team", new Object[0])).setCanEdit(editor);
                group.add("task", (ConfigValue)new ConfigQuestObject(this.getTask() == null ? "" : this.getTask().getID()){

                    public void setString(String v) {
                        QuestTask t = ServerQuestFile.INSTANCE.getTask(v);
                        if (t != null) {
                            TileScreenCore.this.quest = t.quest.getID();
                            TileScreenCore.this.task = t.id;
                        }
                    }
                }.addType(QuestObjectType.TASK), (ConfigValue)ConfigNull.INSTANCE).setCanEdit(editorOrDestructible).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.task", new Object[0]));
                group.add("skin", (ConfigValue)new ConfigBlockState(this.skin){

                    public void setBlockState(IBlockState v) {
                        TileScreenCore.this.skin = v;
                    }
                }, (ConfigValue)new ConfigBlockState(BlockUtils.AIR_STATE)).setCanEdit(editorOrDestructible);
                if (editor) {
                    group.add("indestructible", (ConfigValue)new ConfigBoolean(this.indestructible){

                        public void setBoolean(boolean v) {
                            TileScreenCore.this.indestructible = v;
                        }
                    }, (ConfigValue)new ConfigBoolean(false));
                }
                group.add("input_only", (ConfigValue)new ConfigBoolean(this.inputOnly){

                    public void setBoolean(boolean v) {
                        TileScreenCore.this.inputOnly = v;
                    }
                }, (ConfigValue)new ConfigBoolean(false));
                group.add("input_mode_icon", (ConfigValue)new ConfigItemStack(this.inputModeIcon){

                    public void setStack(ItemStack v) {
                        TileScreenCore.this.inputModeIcon = v;
                    }
                }, (ConfigValue)new ConfigItemStack(ItemStack.field_190927_a));
                FTBLibAPI.editServerConfig((EntityPlayerMP)player, (ConfigGroup)group0, (IConfigCallback)this);
            }
            return;
        }
        if (this.inputOnly) {
            this.insertItem(player, hand, x, y);
            return;
        }
        this.cTask = this.getTask();
        if (this.cTask == null) {
            return;
        }
        if (y >= 0.0 && y <= 0.17 && !this.indestructible && this.cTask.quest.tasks.size() > 1) {
            if (!editor && !this.isOwner((EntityPlayer)player)) {
                return;
            }
            this.currentCoreClass = this.cTask.getScreenCoreClass();
            this.currentPartClass = this.cTask.getScreenPartClass();
            this.cTask = this.cTask.quest.tasks.get((this.cTask.quest.tasks.indexOf(this.cTask) + 1) % this.cTask.quest.tasks.size());
            this.task = this.cTask.id;
            this.func_145836_u();
            this.cTask = this.getTask();
            if (this.cTask != null && (this.currentCoreClass != this.cTask.getScreenCoreClass() || this.currentPartClass != this.cTask.getScreenPartClass())) {
                this.updateTiles(this.cTask);
            }
            this.func_70296_d();
            return;
        }
        this.insertItem(player, hand, x, y);
    }

    private void insertItem(EntityPlayerMP player, EnumHand hand, double x, double y) {
        if (!this.isOwner((EntityPlayer)player)) {
            return;
        }
        String top1 = this.cTask.quest.getDisplayName().func_150260_c();
        String top2 = this.cTask.getDisplayName().func_150260_c();
        double iconY = 0.5;
        if (!top1.isEmpty() && !top1.equalsIgnoreCase(top2)) {
            iconY = 0.54;
        }
        if (y >= iconY - 0.25 && y <= iconY + 0.25 && !this.field_145850_b.field_72995_K) {
            ItemStack stack1;
            ItemStack stack;
            this.cTaskData = this.getTaskData();
            if (this.cTaskData == null) {
                return;
            }
            if (((QuestTask)this.cTaskData.task).canInsertItem() && ((QuestTask)this.cTaskData.task).getMaxProgress() > 0L && this.cTaskData.getProgress() < ((QuestTask)this.cTaskData.task).getMaxProgress() && !(stack = player.func_184586_b(hand)).func_190926_b() && stack != (stack1 = this.cTaskData.insertItem(stack, false, false, (EntityPlayer)player))) {
                player.func_184611_a(hand, stack1);
                return;
            }
            MessageOpenTask.openGUI(this.cTaskData, player, this);
        }
    }

    public void updateTiles(@Nullable QuestTask task) {
        boolean xaxis = this.getFacing().func_176740_k() == EnumFacing.Axis.X;
        for (int by = 0; by < this.size * 2 + 1; ++by) {
            for (int bx = -this.size; bx <= this.size; ++bx) {
                int offX = xaxis ? 0 : bx;
                int offZ = xaxis ? bx : 0;
                BlockPos pos1 = new BlockPos(this.field_174879_c.func_177958_n() + offX, this.field_174879_c.func_177956_o() + by, this.field_174879_c.func_177952_p() + offZ);
                this.field_145850_b.func_175713_t(pos1);
                if (bx == 0 && by == 0) {
                    TileScreenCore core = task == null ? new TileScreenCore() : task.createScreenCore(this.field_145850_b);
                    core.func_145834_a(this.field_145850_b);
                    core.func_174878_a(pos1);
                    NBTTagCompound nbt = new NBTTagCompound();
                    this.writeData(nbt, EnumSaveType.SAVE);
                    core.readData(nbt, EnumSaveType.SAVE);
                    core.func_145829_t();
                    this.field_145850_b.func_175690_a(pos1, (TileEntity)core);
                    continue;
                }
                TileScreenPart part = task == null ? new TileScreenPart() : task.createScreenPart(this.field_145850_b);
                part.func_145834_a(this.field_145850_b);
                part.func_174878_a(pos1);
                part.setOffset(offX, by, offZ);
                part.func_145829_t();
                this.field_145850_b.func_175690_a(pos1, (TileEntity)part);
            }
        }
    }

    public void onConfigSaved(ConfigGroup group, ICommandSender sender) {
        this.func_145836_u();
        this.func_70296_d();
        BlockUtils.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.field_174879_c, (IBlockState)this.getBlockState());
        this.cTask = this.getTask();
        if (this.cTask != null && (this.currentCoreClass != this.cTask.getScreenCoreClass() || this.currentPartClass != this.cTask.getScreenPartClass())) {
            this.updateTiles(this.cTask);
        }
    }

    public void onLoad() {
        if (this.func_145838_q() != FTBQuestsBlocks.SCREEN) {
            boolean xaxis = this.getFacing().func_176740_k() == EnumFacing.Axis.X;
            for (int y = 0; y < this.size * 2 + 1; ++y) {
                for (int x = -this.size; x <= this.size; ++x) {
                    int offX = xaxis ? 0 : x;
                    int offZ = xaxis ? x : 0;
                    this.field_145850_b.func_175698_g(new BlockPos(this.field_174879_c.func_177958_n() + offX, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + offZ));
                }
            }
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        this.sendDirtyUpdate();
    }
}

