/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.tasks;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftbquests.net.MessageOpenTask;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTaskData;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTaskType;
import com.feed_the_beast.ftbquests.tile.TileScreenCore;
import com.feed_the_beast.ftbquests.tile.TileScreenPart;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class QuestTask
extends QuestObject {
    public final Quest quest;
    public short index;
    private String cachedID = "";

    public QuestTask(Quest q) {
        this.quest = q;
        this.index = (short)-1;
    }

    public abstract QuestTaskData createData(ITeamData var1);

    @Override
    public final QuestFile getQuestFile() {
        return this.quest.chapter.file;
    }

    @Override
    public final QuestObjectType getObjectType() {
        return QuestObjectType.TASK;
    }

    @Override
    public final String getID() {
        if (this.cachedID.isEmpty()) {
            this.cachedID = this.quest.chapter.id + ':' + this.quest.id + ':' + this.id;
        }
        return this.cachedID;
    }

    @Override
    public final long getProgress(ITeamData data) {
        return data.getQuestTaskData(this).getProgress();
    }

    @Override
    public final int getRelativeProgress(ITeamData data) {
        return data.getQuestTaskData(this).getRelativeProgress();
    }

    @Override
    public final boolean isComplete(ITeamData data) {
        long max = this.getMaxProgress();
        return max > 0L && this.getProgress(data) >= max;
    }

    @Override
    public void onCompleted(ITeamData data) {
        super.onCompleted(data);
        if (this.quest.isComplete(data)) {
            this.quest.onCompleted(data);
        }
    }

    @Override
    public long getMaxProgress() {
        return 1L;
    }

    public String getMaxProgressString() {
        return Long.toString(this.getMaxProgress());
    }

    @Override
    public final void resetProgress(ITeamData data) {
        QuestTaskData taskData = data.getQuestTaskData(this);
        taskData.resetProgress();
        taskData.isComplete = false;
        taskData.sync();
    }

    @Override
    public void completeInstantly(ITeamData data) {
        QuestTaskData taskData = data.getQuestTaskData(this);
        taskData.completeInstantly();
        taskData.sync();
    }

    @Override
    public void deleteSelf() {
        this.quest.tasks.remove(this);
        for (ITeamData iTeamData : this.quest.chapter.file.getAllData()) {
            iTeamData.removeTask(this);
        }
        super.deleteSelf();
    }

    @Override
    public void deleteChildren() {
    }

    @Override
    public void onCreated() {
        this.quest.tasks.add(this);
        for (ITeamData iTeamData : this.quest.chapter.file.getAllData()) {
            iTeamData.createTaskData(this);
        }
    }

    @Override
    public ITextComponent getAltDisplayName() {
        return QuestTaskType.getType(this.getClass()).getDisplayName();
    }

    public Class<? extends TileScreenCore> getScreenCoreClass() {
        return TileScreenCore.class;
    }

    public Class<? extends TileScreenPart> getScreenPartClass() {
        return TileScreenPart.class;
    }

    public TileScreenCore createScreenCore(World world) {
        return new TileScreenCore();
    }

    public TileScreenPart createScreenPart(World world) {
        return new TileScreenPart();
    }

    @SideOnly(value=Side.CLIENT)
    public void drawGUI(@Nullable QuestTaskData data, int x, int y, int w, int h) {
        this.getIcon().draw(x, y, w, h);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawScreen(@Nullable QuestTaskData data) {
        this.getIcon().draw3D(Icon.EMPTY);
    }

    public boolean canInsertItem() {
        return false;
    }

    @Override
    public final void getExtraConfig(ConfigGroup config) {
        super.getExtraConfig(config);
    }

    @Override
    public Icon getAltIcon() {
        return GuiIcons.ACCEPT;
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.cachedID = "";
    }

    @Nullable
    public QuestObject getDependency() {
        return null;
    }

    public boolean hideProgressNumbers() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void addMouseOverText(List<String> list) {
        if (this.canInsertItem()) {
            list.add(TextFormatting.DARK_GRAY + I18n.func_135052_a((String)"ftbquests.task.click_to_submit", (Object[])new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onButtonClicked() {
        if (this.canInsertItem()) {
            new MessageOpenTask(this.getID()).sendToServer();
        }
    }
}

