/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.tasks;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.GuiQuest;
import com.feed_the_beast.ftbquests.gui.GuiVariables;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTaskData;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class DependencyTask
extends QuestTask {
    public String objectId;
    private QuestObject cachedDep;

    public DependencyTask(Quest quest, NBTTagCompound nbt) {
        super(quest);
        this.objectId = nbt.func_74779_i("object");
    }

    public abstract QuestObjectType getType();

    @Override
    @Nullable
    public QuestObject getDependency() {
        if (this.objectId.isEmpty()) {
            return null;
        }
        if (this.cachedDep == null || this.cachedDep.invalid) {
            this.cachedDep = this.quest.chapter.file.get(this.objectId);
        }
        if (this.cachedDep == null) {
            FTBQuests.LOGGER.warn("Removed dependency '" + this.getID() + "' with missing ID '" + this.objectId + "'");
            this.quest.chapter.file.deleteObject(this.getID());
        }
        return this.cachedDep;
    }

    @Override
    public long getMaxProgress() {
        return 1L;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        if (this.cachedDep != null) {
            this.objectId = this.cachedDep.getID();
        }
        nbt.func_74778_a("object", this.objectId);
    }

    @Override
    public Icon getAltIcon() {
        QuestObject object = this.getDependency();
        return object == null ? GuiIcons.INFO : object.getIcon();
    }

    @Override
    public ITextComponent getAltDisplayName() {
        QuestObject object = this.getDependency();
        return new TextComponentTranslation("ftbquests.dependency", new Object[0]).func_150258_a(": ").func_150257_a((ITextComponent)(object == null ? new TextComponentTranslation(this.getType().getTranslationKey(), new Object[0]) : object.getDisplayName()));
    }

    @Override
    public void getConfig(ConfigGroup group) {
        if (this.cachedDep != null) {
            this.objectId = this.cachedDep.getID();
        }
        group.add("object", (ConfigValue)new ConfigQuestObject(""){

            public String getString() {
                return DependencyTask.this.objectId;
            }

            public void setString(String v) {
                DependencyTask.this.objectId = v;
            }
        }.addType(this.getType()), (ConfigValue)new ConfigQuestObject("")).setDisplayName((ITextComponent)new TextComponentTranslation(this.getType().getTranslationKey(), new Object[0]));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addMouseOverText(List<String> list) {
        if (this.cachedDep != null) {
            this.objectId = this.cachedDep.getID();
        }
        list.add(TextFormatting.DARK_GRAY + this.objectId);
    }

    @Override
    public QuestTaskData createData(ITeamData data) {
        return new Data(this, data);
    }

    public static class Data
    extends QuestTaskData<DependencyTask> {
        private Data(DependencyTask task, ITeamData data) {
            super(task, data);
        }

        @Override
        @Nullable
        public NBTBase toNBT() {
            return null;
        }

        @Override
        public void fromNBT(@Nullable NBTBase nbt) {
        }

        @Override
        public long getProgress() {
            QuestObject object = ((DependencyTask)this.task).getDependency();
            if (object != null) {
                try {
                    if (object.isComplete(this.teamData)) {
                        return 1L;
                    }
                }
                catch (StackOverflowError error) {
                    FTBQuests.LOGGER.error("Removed looping dependency '" + ((DependencyTask)this.task).getID() + "' with erroring ID '" + ((DependencyTask)this.task).objectId + "'");
                    ((DependencyTask)this.task).quest.chapter.file.deleteObject(((DependencyTask)this.task).getID());
                }
            }
            return 0L;
        }

        @Override
        public void resetProgress() {
            QuestObject object = ((DependencyTask)this.task).getDependency();
            if (object != null) {
                object.resetProgress(this.teamData);
            }
        }

        @Override
        public void completeInstantly() {
            QuestObject object = ((DependencyTask)this.task).getDependency();
            if (object != null) {
                object.completeInstantly(this.teamData);
            }
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return false;
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            return null;
        }
    }

    public static class VariableDep
    extends DependencyTask {
        public VariableDep(Quest quest, NBTTagCompound nbt) {
            super(quest, nbt);
        }

        @Override
        public QuestObjectType getType() {
            return QuestObjectType.VARIABLE;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addMouseOverText(List<String> list) {
            super.addMouseOverText(list);
            if (this.getDependency() instanceof QuestChapter) {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.variable", (Object[])new Object[0]) + ": " + QuestObjectType.VARIABLE.getColor() + this.getDependency().getDisplayName().func_150260_c());
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onButtonClicked() {
            new GuiVariables().openGui();
        }
    }

    public static class ChapterDep
    extends DependencyTask {
        public ChapterDep(Quest quest, NBTTagCompound nbt) {
            super(quest, nbt);
        }

        @Override
        public QuestObjectType getType() {
            return QuestObjectType.CHAPTER;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addMouseOverText(List<String> list) {
            super.addMouseOverText(list);
            if (this.getDependency() instanceof QuestChapter) {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.chapter", (Object[])new Object[0]) + ": " + QuestObjectType.CHAPTER.getColor() + this.getDependency().getDisplayName().func_150260_c());
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onButtonClicked() {
            if (this.getDependency() instanceof QuestChapter) {
                ClientQuestFile.INSTANCE.questTreeGui.openGui();
                ClientQuestFile.INSTANCE.questTreeGui.selectChapter((QuestChapter)this.getDependency());
            }
        }
    }

    public static class QuestDep
    extends DependencyTask {
        public QuestDep(Quest quest, NBTTagCompound nbt) {
            super(quest, nbt);
        }

        @Override
        public QuestObjectType getType() {
            return QuestObjectType.QUEST;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addMouseOverText(List<String> list) {
            super.addMouseOverText(list);
            if (this.getDependency() instanceof Quest) {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.quest", (Object[])new Object[0]) + ": " + QuestObjectType.QUEST.getColor() + this.getDependency().getDisplayName().func_150260_c());
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.chapter", (Object[])new Object[0]) + ": " + QuestObjectType.CHAPTER.getColor() + ((Quest)this.getDependency()).chapter.getDisplayName().func_150260_c());
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onButtonClicked() {
            if (this.getDependency() instanceof Quest) {
                new GuiQuest(ClientQuestFile.INSTANCE.questTreeGui, (Quest)this.getDependency()).openGui();
            }
        }
    }

    public static class TaskDep
    extends DependencyTask {
        public TaskDep(Quest quest, NBTTagCompound nbt) {
            super(quest, nbt);
        }

        @Override
        public QuestObjectType getType() {
            return QuestObjectType.TASK;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addMouseOverText(List<String> list) {
            super.addMouseOverText(list);
            if (this.getDependency() instanceof QuestTask) {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.task", (Object[])new Object[0]) + ": " + QuestObjectType.TASK.getColor() + this.getDependency().getDisplayName().func_150260_c());
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.quest", (Object[])new Object[0]) + ": " + QuestObjectType.QUEST.getColor() + ((QuestTask)this.getDependency()).quest.getDisplayName().func_150260_c());
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.chapter", (Object[])new Object[0]) + ": " + QuestObjectType.CHAPTER.getColor() + ((QuestTask)this.getDependency()).quest.chapter.getDisplayName().func_150260_c());
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onButtonClicked() {
            if (this.getDependency() instanceof QuestTask) {
                new GuiQuest(ClientQuestFile.INSTANCE.questTreeGui, ((QuestTask)this.getDependency()).quest).openGui();
            }
        }
    }
}

