/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftbquests.net.edit.MessageDeleteObjectResponse;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.util.FTBQuestsTeamData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class ServerQuestFile
extends QuestFile {
    public static ServerQuestFile INSTANCE;
    public final File file;
    public boolean shouldSave = false;

    public ServerQuestFile(File f) {
        this.file = f;
    }

    public boolean load() {
        NBTTagCompound nbt;
        if (!this.file.exists()) {
            NBTUtils.writeNBT((File)this.file, (NBTTagCompound)new NBTTagCompound());
        }
        this.readData((nbt = NBTUtils.readNBT((File)this.file)) == null ? new NBTTagCompound() : nbt);
        return nbt != null;
    }

    @Override
    @Nullable
    public ITeamData getData(String team) {
        if (Universe.loaded()) {
            ForgeTeam t = Universe.get().getTeam(team);
            return t.isValid() ? FTBQuestsTeamData.get(t) : null;
        }
        return null;
    }

    public Collection<FTBQuestsTeamData> getAllData() {
        if (Universe.loaded()) {
            Collection teams = Universe.get().getTeams();
            ArrayList<FTBQuestsTeamData> list = new ArrayList<FTBQuestsTeamData>(teams.size());
            for (ForgeTeam team : teams) {
                if (!team.isValid()) continue;
                list.add(FTBQuestsTeamData.get(team));
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public void deleteObject(String id) {
        QuestObject object = this.get(id);
        if (object != null) {
            object.deleteChildren();
            object.deleteSelf();
            this.clearCachedData();
            this.save();
        }
        new MessageDeleteObjectResponse(id).sendToAll();
    }

    public void save() {
        this.shouldSave = true;
        Universe.get().markDirty();
    }

    public void saveNow() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeData(nbt);
        NBTUtils.writeNBTSafe((File)this.file, (NBTTagCompound)nbt);
    }

    public void unload() {
        if (this.shouldSave) {
            this.saveNow();
            this.shouldSave = false;
        }
        this.deleteChildren();
        this.deleteSelf();
    }
}

