/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.item.ItemStackSerializer;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class QuestVariable
extends QuestObject {
    public final QuestFile file;
    public long maxValue;
    public boolean team;
    public short index;
    private String cachedID = "";

    public QuestVariable(QuestFile f, NBTTagCompound nbt) {
        this.file = f;
        this.title = nbt.func_74779_i("title");
        this.icon = ItemStackSerializer.read((NBTTagCompound)nbt.func_74775_l("icon"));
        this.completionCommand = nbt.func_74779_i("completion_command");
        this.maxValue = nbt.func_74763_f("max");
        if (this.maxValue < 1L) {
            this.maxValue = 1L;
        }
        this.team = nbt.func_74767_n("team");
        this.index = (short)-1;
        this.readID(nbt);
    }

    @Override
    public QuestFile getQuestFile() {
        return this.file;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.VARIABLE;
    }

    @Override
    public String getID() {
        if (this.cachedID.isEmpty()) {
            this.cachedID = '#' + this.id;
        }
        return this.cachedID;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        nbt.func_74778_a("id", this.id);
        if (!this.title.isEmpty()) {
            nbt.func_74778_a("title", this.title);
        }
        if (!this.icon.func_190926_b()) {
            nbt.func_74782_a("icon", (NBTBase)ItemStackSerializer.write((ItemStack)this.icon));
        }
        if (!this.completionCommand.isEmpty()) {
            nbt.func_74778_a("completion_command", this.completionCommand);
        }
        nbt.func_74772_a("max", this.maxValue);
        if (this.team) {
            nbt.func_74757_a("team", true);
        }
    }

    @Override
    public Icon getAltIcon() {
        return GuiIcons.CONTROLLER;
    }

    @Override
    public long getProgress(ITeamData data) {
        return data.getVariable(this);
    }

    @Override
    public long getMaxProgress() {
        return this.maxValue;
    }

    @Override
    public void resetProgress(ITeamData data) {
        data.setVariable(this, 0L);
    }

    @Override
    public void completeInstantly(ITeamData data) {
        data.setVariable(this, this.maxValue);
    }

    @Override
    public int getRelativeProgress(ITeamData data) {
        if (this.maxValue <= 0L) {
            return 100;
        }
        long value = data.getVariable(this);
        if (value <= 0L) {
            return 0;
        }
        if (value >= this.maxValue) {
            return 100;
        }
        return (int)(value * 100L / this.maxValue);
    }

    @Override
    public boolean isComplete(ITeamData data) {
        return data.getVariable(this) >= this.maxValue;
    }

    @Override
    public ITextComponent getAltDisplayName() {
        return new TextComponentString(this.getID());
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.file.variables.remove(this);
    }

    @Override
    public void onCreated() {
        this.file.variables.add(this);
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        this.cachedID = "";
    }
}

