/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigList;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigTimer;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconAnimation;
import com.feed_the_beast.ftblib.lib.item.ItemStackSerializer;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftbquests.item.LootRarity;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.QuestReward;
import com.feed_the_beast.ftbquests.quest.QuestVariable;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTaskType;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class QuestFile
extends QuestObject {
    public final List<QuestChapter> chapters;
    public final List<QuestVariable> variables;
    public final Map<String, QuestObject> map;
    public QuestTask[] allTasks;
    public final Int2ObjectOpenHashMap<QuestReward> allRewards;
    public final List<ItemStack> emergencyItems;
    public Ticks emergencyItemsCooldown;
    public String soundTask;
    public String soundQuest;
    public String soundChapter;
    public String soundFile;
    public final ResourceLocation[] lootTables;
    public int lootSize;

    public QuestFile() {
        this.id = "*";
        this.chapters = new ArrayList<QuestChapter>();
        this.variables = new ArrayList<QuestVariable>();
        this.map = new HashMap<String, QuestObject>();
        this.allTasks = new QuestTask[0];
        this.allRewards = new Int2ObjectOpenHashMap();
        this.emergencyItems = new ArrayList<ItemStack>();
        this.emergencyItems.add(new ItemStack(Items.field_151034_e));
        this.emergencyItemsCooldown = Ticks.MINUTE.x(5L);
        this.soundTask = "";
        this.soundQuest = "";
        this.soundChapter = "";
        this.soundFile = "minecraft:ui.toast.challenge_complete";
        this.lootTables = new ResourceLocation[LootRarity.VALUES.length];
        for (LootRarity rarity : LootRarity.VALUES) {
            this.lootTables[rarity.ordinal()] = rarity.getLootTable();
        }
        this.lootSize = 9;
    }

    @Override
    public QuestFile getQuestFile() {
        return this;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.FILE;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public long getProgress(ITeamData data) {
        long progress = 0L;
        for (QuestChapter chapter : this.chapters) {
            progress += chapter.getProgress(data);
        }
        return progress;
    }

    @Override
    public long getMaxProgress() {
        long maxProgress = 0L;
        for (QuestChapter chapter : this.chapters) {
            maxProgress += chapter.getMaxProgress();
        }
        return maxProgress;
    }

    @Override
    public int getRelativeProgress(ITeamData data) {
        int progress = 0;
        for (QuestChapter chapter : this.chapters) {
            progress += chapter.getRelativeProgress(data);
        }
        return QuestFile.fixRelativeProgress(progress, this.chapters.size());
    }

    @Override
    public boolean isComplete(ITeamData data) {
        for (QuestChapter chapter : this.chapters) {
            if (chapter.isComplete(data)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void resetProgress(ITeamData data) {
        for (QuestChapter chapter : this.chapters) {
            chapter.resetProgress(data);
        }
    }

    @Override
    public void completeInstantly(ITeamData data) {
        for (QuestChapter chapter : this.chapters) {
            chapter.completeInstantly(data);
        }
    }

    @Override
    public void deleteSelf() {
        this.invalid = true;
    }

    @Override
    public void deleteChildren() {
        for (QuestChapter chapter : this.chapters) {
            chapter.deleteChildren();
            chapter.invalid = true;
        }
        this.chapters.clear();
        for (QuestVariable variable : this.variables) {
            variable.deleteChildren();
            variable.invalid = true;
        }
        this.variables.clear();
    }

    @Nullable
    public QuestObject get(String id) {
        if (id.isEmpty()) {
            return null;
        }
        if (id.charAt(0) == '*') {
            return this;
        }
        QuestObject object = this.map.get(id);
        return object == null || object.invalid ? null : object;
    }

    @Nullable
    public QuestObject remove(String id) {
        QuestObject object = this.map.remove(id);
        if (object != null) {
            object.invalid = true;
            this.refreshIDMap();
            return object;
        }
        return null;
    }

    @Nullable
    public QuestChapter getChapter(String id) {
        QuestObject object = this.get(id);
        return object instanceof QuestChapter ? (QuestChapter)object : null;
    }

    @Nullable
    public Quest getQuest(String id) {
        QuestObject object = this.get(id);
        return object instanceof Quest ? (Quest)object : null;
    }

    @Nullable
    public QuestTask getTask(String id) {
        QuestObject object = this.get(id);
        return object instanceof QuestTask ? (QuestTask)object : null;
    }

    @Nullable
    public QuestVariable getVariable(String id) {
        QuestObject object = this.get(id);
        return object instanceof QuestVariable ? (QuestVariable)object : null;
    }

    /*
     * WARNING - void declaration
     */
    public void refreshIDMap() {
        void var2_7;
        this.map.clear();
        this.map.put("*", this);
        for (QuestChapter questChapter : this.chapters) {
            this.map.put(questChapter.getID(), questChapter);
            for (Quest quest : questChapter.quests) {
                this.map.put(quest.getID(), quest);
                for (QuestTask task : quest.tasks) {
                    this.map.put(task.getID(), task);
                }
            }
        }
        for (QuestVariable questVariable : this.variables) {
            this.map.put(questVariable.getID(), questVariable);
        }
        ArrayList<QuestTask> tasks = new ArrayList<QuestTask>();
        for (QuestChapter chapter : this.chapters) {
            for (Quest quest : chapter.quests) {
                for (QuestTask task : quest.tasks) {
                    task.index = (short)tasks.size();
                    tasks.add(task);
                }
            }
        }
        this.allTasks = tasks.toArray(new QuestTask[0]);
        boolean bl = false;
        while (var2_7 < this.variables.size()) {
            this.variables.get((int)var2_7).index = (short)var2_7;
            ++var2_7;
        }
        this.allRewards.clear();
        for (QuestChapter chapter : this.chapters) {
            for (Quest quest : chapter.quests) {
                for (QuestReward reward : quest.rewards) {
                    this.allRewards.put(reward.uid, (Object)reward);
                }
            }
        }
    }

    @Nullable
    public QuestObject create(QuestObjectType type, String parent, NBTTagCompound nbt) {
        switch (type) {
            case CHAPTER: {
                return new QuestChapter(this, nbt);
            }
            case QUEST: {
                QuestChapter chapter = this.getChapter(parent);
                if (chapter != null) {
                    return new Quest(chapter, nbt);
                }
                return null;
            }
            case TASK: {
                Quest quest = this.getQuest(parent);
                if (quest != null) {
                    return QuestTaskType.createTask(quest, nbt);
                }
                return null;
            }
            case VARIABLE: {
                return new QuestVariable(this, nbt);
            }
        }
        return null;
    }

    @Override
    public final void writeData(NBTTagCompound nbt) {
        if (!this.title.isEmpty()) {
            nbt.func_74778_a("title", this.title);
        }
        if (!this.icon.func_190926_b()) {
            nbt.func_74782_a("icon", (NBTBase)ItemStackSerializer.write((ItemStack)this.icon));
        }
        if (!this.completionCommand.isEmpty()) {
            nbt.func_74778_a("completion_command", this.completionCommand);
        }
        NBTTagList list = new NBTTagList();
        for (QuestChapter chapter : this.chapters) {
            NBTTagCompound chapterNBT = new NBTTagCompound();
            chapter.writeData(chapterNBT);
            chapterNBT.func_74778_a("id", chapter.id);
            list.func_74742_a((NBTBase)chapterNBT);
        }
        nbt.func_74782_a("chapters", (NBTBase)list);
        list = new NBTTagList();
        for (QuestVariable variable : this.variables) {
            NBTTagCompound variableNBT = new NBTTagCompound();
            variable.writeData(variableNBT);
            variableNBT.func_74778_a("id", variable.id);
            list.func_74742_a((NBTBase)variableNBT);
        }
        nbt.func_74782_a("variables", (NBTBase)list);
        list = new NBTTagList();
        for (ItemStack stack : this.emergencyItems) {
            list.func_74742_a((NBTBase)ItemStackSerializer.write((ItemStack)stack));
        }
        nbt.func_74782_a("emergency_items", (NBTBase)list);
        nbt.func_74778_a("emergency_items_cooldown", this.emergencyItemsCooldown.toString());
        for (Iterator<QuestObject> iterator : LootRarity.VALUES) {
            if (this.lootTables[((Enum)((Object)iterator)).ordinal()].equals((Object)((LootRarity)((Object)iterator)).getLootTable())) continue;
            nbt.func_74778_a(((LootRarity)((Object)iterator)).func_176610_l() + "_loot_table", this.lootTables[((Enum)((Object)iterator)).ordinal()].toString());
        }
        nbt.func_74777_a("loot_size", (short)this.lootSize);
    }

    protected final void readData(NBTTagCompound nbt) {
        int i;
        this.title = nbt.func_74779_i("title");
        this.icon = ItemStackSerializer.read((NBTTagCompound)nbt.func_74775_l("icon"));
        this.completionCommand = nbt.func_74779_i("completion_command");
        this.chapters.clear();
        NBTTagList list = nbt.func_150295_c("chapters", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            QuestChapter chapter = new QuestChapter(this, list.func_150305_b(i));
            chapter.chapterIndex = this.chapters.size();
            this.chapters.add(chapter);
        }
        this.variables.clear();
        list = nbt.func_150295_c("variables", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            QuestVariable variable = new QuestVariable(this, list.func_150305_b(i));
            variable.index = (short)this.variables.size();
            this.variables.add(variable);
        }
        this.refreshIDMap();
        this.emergencyItems.clear();
        list = nbt.func_150295_c("emergency_items", 10);
        for (i = 0; i < list.func_74745_c(); ++i) {
            ItemStack stack = ItemStackSerializer.read((NBTTagCompound)list.func_150305_b(i));
            if (stack.func_190926_b()) continue;
            this.emergencyItems.add(stack);
        }
        Ticks t = Ticks.get((String)nbt.func_74779_i("emergency_items_cooldown"));
        this.emergencyItemsCooldown = t.hasTicks() ? t : Ticks.MINUTE.x(5L);
        for (LootRarity rarity : LootRarity.VALUES) {
            String s = nbt.func_74779_i(rarity.func_176610_l() + "_loot_table");
            this.lootTables[rarity.ordinal()] = s.isEmpty() ? rarity.getLootTable() : new ResourceLocation(s);
        }
        this.lootSize = nbt.func_74765_d("loot_size") & 0xFFFF;
        if (this.lootSize == 0) {
            this.lootSize = 9;
        }
    }

    @Nullable
    public abstract ITeamData getData(String var1);

    public abstract Collection<? extends ITeamData> getAllData();

    public abstract void deleteObject(String var1);

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (QuestChapter chapter : this.chapters) {
            list.add(chapter.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public ITextComponent getAltDisplayName() {
        return new TextComponentTranslation("ftbquests.file", new Object[0]);
    }

    @Override
    public void getConfig(ConfigGroup config) {
        config.add("emergency_items", (ConfigValue)new ConfigList<ConfigItemStack>(new ConfigItemStack(ItemStack.field_190927_a)){

            public void writeToList() {
                this.list.clear();
                for (ItemStack stack : QuestFile.this.emergencyItems) {
                    this.list.add(new ConfigItemStack(stack));
                }
            }

            public void readFromList() {
                QuestFile.this.emergencyItems.clear();
                for (ConfigItemStack value : this.list) {
                    QuestFile.this.emergencyItems.add(value.getStack());
                }
            }
        }, (ConfigValue)new ConfigList((ConfigValue)new ConfigItemStack(new ItemStack(Items.field_151034_e))));
        config.add("emergency_items_cooldown", (ConfigValue)new ConfigTimer(Ticks.NO_TICKS){

            public Ticks getTimer() {
                return QuestFile.this.emergencyItemsCooldown;
            }

            public void setTimer(Ticks t) {
                QuestFile.this.emergencyItemsCooldown = t;
            }
        }, (ConfigValue)new ConfigTimer(Ticks.MINUTE.x(5L)));
        ConfigGroup lootGroup = config.getGroup("loot_tables");
        Pattern pattern = Pattern.compile("[a-z0-9_]+:.+");
        for (final LootRarity rarity : LootRarity.VALUES) {
            lootGroup.add(rarity.func_176610_l(), (ConfigValue)new ConfigString("", pattern){

                public String getString() {
                    return QuestFile.this.lootTables[rarity.ordinal()].toString();
                }

                public void setString(String v) {
                    QuestFile.this.lootTables[rarity.ordinal()] = v.equals(rarity.getLootTable().toString()) ? rarity.getLootTable() : new ResourceLocation(v);
                }
            }, (ConfigValue)new ConfigString(rarity.getLootTable().toString())).setDisplayName((ITextComponent)new TextComponentTranslation(rarity.getTranslationKey(), new Object[0]));
        }
        config.add("loot_size", (ConfigValue)new ConfigInt(0, 1, 1024){

            public int getInt() {
                return QuestFile.this.lootSize;
            }

            public void setInt(int v) {
                QuestFile.this.lootSize = v;
            }
        }, (ConfigValue)new ConfigInt(9));
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (QuestChapter chapter : this.chapters) {
            chapter.clearCachedData();
        }
    }
}

