/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.config.ConfigEnum;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigList;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconAnimation;
import com.feed_the_beast.ftblib.lib.item.ItemStackSerializer;
import com.feed_the_beast.ftbquests.quest.EnumQuestVisibilityType;
import com.feed_the_beast.ftbquests.quest.EnumVisibility;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public final class QuestChapter
extends QuestObject {
    public final QuestFile file;
    public int chapterIndex;
    public EnumQuestVisibilityType visibilityType;
    public final List<Quest> quests;
    public final List<String> description;

    public QuestChapter(QuestFile f, NBTTagCompound nbt) {
        this.file = f;
        this.readID(nbt);
        this.title = nbt.func_74779_i("title");
        this.description = new ArrayList<String>();
        this.icon = ItemStackSerializer.read((NBTTagCompound)nbt.func_74775_l("icon"));
        this.completionCommand = nbt.func_74779_i("completion_command");
        this.visibilityType = (EnumQuestVisibilityType)((Object)EnumQuestVisibilityType.NAME_MAP.get(nbt.func_74779_i("visibility")));
        this.quests = new ArrayList<Quest>();
        NBTTagList desc = nbt.func_150295_c("description", 8);
        for (int i = 0; i < desc.func_74745_c(); ++i) {
            this.description.add(desc.func_150307_f(i));
        }
        NBTTagList questsList = nbt.func_150295_c("quests", 10);
        for (int j = 0; j < questsList.func_74745_c(); ++j) {
            this.quests.add(new Quest(this, questsList.func_150305_b(j)));
        }
    }

    @Override
    public QuestFile getQuestFile() {
        return this.file;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.CHAPTER;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        if (!this.title.isEmpty()) {
            nbt.func_74778_a("title", this.title);
        }
        if (!this.icon.func_190926_b()) {
            nbt.func_74782_a("icon", (NBTBase)ItemStackSerializer.write((ItemStack)this.icon));
        }
        if (!this.completionCommand.isEmpty()) {
            nbt.func_74778_a("completion_command", this.completionCommand);
        }
        if (this.visibilityType != EnumQuestVisibilityType.NORMAL) {
            nbt.func_74778_a("type", this.visibilityType.func_176610_l());
        }
        if (!this.description.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (String v : this.description) {
                list.func_74742_a((NBTBase)new NBTTagString(v));
            }
            nbt.func_74782_a("description", (NBTBase)list);
        }
        if (!this.quests.isEmpty()) {
            NBTTagList questsList = new NBTTagList();
            for (Quest quest : this.quests) {
                NBTTagCompound questNBT = new NBTTagCompound();
                quest.writeData(questNBT);
                questNBT.func_74778_a("id", quest.id);
                questsList.func_74742_a((NBTBase)questNBT);
            }
            nbt.func_74782_a("quests", (NBTBase)questsList);
        }
    }

    @Override
    public long getProgress(ITeamData data) {
        long progress = 0L;
        for (Quest quest : this.quests) {
            progress += quest.getProgress(data);
        }
        return progress;
    }

    @Override
    public long getMaxProgress() {
        long maxProgress = 0L;
        for (Quest quest : this.quests) {
            maxProgress += quest.getMaxProgress();
        }
        return maxProgress;
    }

    @Override
    public int getRelativeProgress(ITeamData data) {
        int progress = 0;
        for (Quest quest : this.quests) {
            progress += quest.getRelativeProgress(data);
        }
        return QuestChapter.fixRelativeProgress(progress, this.quests.size());
    }

    @Override
    public boolean isComplete(ITeamData data) {
        for (Quest quest : this.quests) {
            if (quest.isComplete(data)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onCompleted(ITeamData data) {
        super.onCompleted(data);
        if (this.file.isComplete(data)) {
            this.file.onCompleted(data);
        }
    }

    @Override
    public void resetProgress(ITeamData data) {
        for (Quest quest : this.quests) {
            quest.resetProgress(data);
        }
    }

    @Override
    public void completeInstantly(ITeamData data) {
        for (Quest quest : this.quests) {
            quest.completeInstantly(data);
        }
    }

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (Quest quest : this.quests) {
            list.add(quest.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public ITextComponent getAltDisplayName() {
        return new TextComponentTranslation("ftbquests.unnamed", new Object[0]);
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.file.chapters.remove(this);
    }

    @Override
    public void deleteChildren() {
        for (Quest quest : this.quests) {
            quest.deleteChildren();
            quest.invalid = true;
        }
        this.quests.clear();
    }

    @Override
    public void onCreated() {
        this.file.chapters.add(this);
    }

    @Override
    public void getConfig(ConfigGroup group) {
        group.add("description", (ConfigValue)new ConfigList<ConfigString>(new ConfigString("")){

            public void readFromList() {
                QuestChapter.this.description.clear();
                for (ConfigString value : this.list) {
                    QuestChapter.this.description.add(value.getString());
                }
            }

            public void writeToList() {
                this.list.clear();
                for (String value : QuestChapter.this.description) {
                    this.list.add(new ConfigString(value));
                }
            }
        }, (ConfigValue)new ConfigList((ConfigValue)new ConfigString("")));
        group.add("visibility", (ConfigValue)new ConfigEnum<EnumQuestVisibilityType>(EnumQuestVisibilityType.NAME_MAP){

            public EnumQuestVisibilityType getValue() {
                return QuestChapter.this.visibilityType;
            }

            public void setValue(EnumQuestVisibilityType v) {
                QuestChapter.this.visibilityType = v;
            }
        }, (ConfigValue)new ConfigEnum(EnumQuestVisibilityType.NAME_MAP));
    }

    public EnumVisibility getVisibility(@Nullable ITeamData data) {
        Quest quest;
        EnumVisibility v = EnumVisibility.VISIBLE;
        Iterator<Quest> iterator = this.quests.iterator();
        while (iterator.hasNext() && !(v = v.weakest((quest = iterator.next()).getVisibility(data))).isInvisible()) {
        }
        return v;
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (Quest quest : this.quests) {
            quest.clearCachedData();
        }
    }
}

