/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.net.edit;

import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToServer;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.net.edit.FTBQuestsEditNetHandler;
import com.feed_the_beast.ftbquests.net.edit.MessageCreateObjectResponse;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class MessageCreateObject
extends MessageToServer {
    private QuestObjectType type;
    private String parent;
    private NBTTagCompound nbt;

    public MessageCreateObject() {
    }

    public MessageCreateObject(QuestObjectType t, String p, NBTTagCompound n) {
        this.type = t;
        this.parent = p;
        this.nbt = n;
    }

    public NetworkWrapper getWrapper() {
        return FTBQuestsEditNetHandler.EDIT;
    }

    public void writeData(DataOut data) {
        data.writeByte(this.type.ordinal());
        data.writeString(this.parent);
        data.writeNBT(this.nbt);
    }

    public void readData(DataIn data) {
        this.type = QuestObjectType.VALUES[data.readUnsignedByte()];
        this.parent = data.readString();
        this.nbt = data.readNBT();
    }

    public void onMessage(EntityPlayerMP player) {
        QuestObject object;
        if (FTBQuests.canEdit(player) && (object = ServerQuestFile.INSTANCE.create(this.type, this.parent, this.nbt)) != null) {
            object.onCreated();
            ServerQuestFile.INSTANCE.refreshIDMap();
            ServerQuestFile.INSTANCE.clearCachedData();
            object.writeData(this.nbt);
            this.nbt.func_74778_a("id", object.id);
            new MessageCreateObjectResponse(this.type, this.parent, this.nbt).sendToAll();
            ServerQuestFile.INSTANCE.save();
        }
    }
}

