/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.net;

import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToClient;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.net.FTBQuestsNetHandler;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.util.Collection;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageSyncQuests
extends MessageToClient {
    public NBTTagCompound quests;
    public String team;
    public Collection<TeamInst> teamData;
    public boolean editingMode;
    public IntCollection rewards;

    public MessageSyncQuests() {
    }

    public MessageSyncQuests(NBTTagCompound n, String t, Collection<TeamInst> td, boolean e, IntCollection r) {
        this.quests = n;
        this.team = t;
        this.teamData = td;
        this.editingMode = e;
        this.rewards = r;
    }

    public NetworkWrapper getWrapper() {
        return FTBQuestsNetHandler.GENERAL;
    }

    public void writeData(DataOut data) {
        data.writeNBT(this.quests);
        data.writeString(this.team);
        data.writeCollection(this.teamData, TeamInst.SERIALIZER);
        data.writeBoolean(this.editingMode);
        data.writeIntList(this.rewards);
    }

    public void readData(DataIn data) {
        this.quests = data.readNBT();
        this.team = data.readString();
        this.teamData = data.readCollection(TeamInst.DESERIALIZER);
        this.editingMode = data.readBoolean();
        this.rewards = data.readIntList();
    }

    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        if (ClientQuestFile.INSTANCE != null) {
            ClientQuestFile.INSTANCE.deleteChildren();
            ClientQuestFile.INSTANCE.deleteSelf();
        }
        ClientQuestFile.INSTANCE = new ClientQuestFile(this, ClientQuestFile.INSTANCE);
    }

    public static class TeamInst {
        public static final DataOut.Serializer<TeamInst> SERIALIZER = (data, t) -> {
            int i;
            data.writeString(t.name);
            data.writeShort(t.taskKeys.length);
            for (i = 0; i < t.taskKeys.length; ++i) {
                data.writeShort((int)t.taskKeys[i]);
                data.writeNBTBase(t.taskValues[i]);
            }
            data.writeShort(t.variableKeys.length);
            for (i = 0; i < t.variableKeys.length; ++i) {
                data.writeShort((int)t.variableKeys[i]);
                data.writeLong(t.variableValues[i]);
            }
        };
        public static final DataIn.Deserializer<TeamInst> DESERIALIZER = data -> {
            int i;
            TeamInst t = new TeamInst();
            t.name = data.readString();
            t.taskKeys = new short[data.readUnsignedShort()];
            t.taskValues = new NBTBase[t.taskKeys.length];
            for (i = 0; i < t.taskKeys.length; ++i) {
                t.taskKeys[i] = data.readShort();
                t.taskValues[i] = data.readNBTBase();
            }
            t.variableKeys = new short[data.readUnsignedShort()];
            t.variableValues = new long[t.variableKeys.length];
            for (i = 0; i < t.variableKeys.length; ++i) {
                t.variableKeys[i] = data.readShort();
                t.variableValues[i] = data.readLong();
            }
            return t;
        };
        public String name;
        public short[] taskKeys;
        public NBTBase[] taskValues;
        public short[] variableKeys;
        public long[] variableValues;
    }
}

