/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui;

import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.QuestVariable;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;

public class GuiSelectQuestObject
extends GuiButtonListBase {
    public final ConfigQuestObject config;
    public final IOpenableGui callback;

    public GuiSelectQuestObject(ConfigQuestObject c, IOpenableGui g) {
        this.setTitle(I18n.func_135052_a((String)"ftbquests.gui.select_quest_object", (Object[])new Object[0]));
        this.setHasSearchBox(true);
        this.config = c;
        this.callback = g;
    }

    public void addButtons(Panel panel) {
        if (this.config.hasValidType(QuestObjectType.FILE)) {
            panel.add((Widget)new ButtonQuestObject(panel, ClientQuestFile.INSTANCE));
        }
        if (this.config.hasValidType(QuestObjectType.VARIABLE)) {
            for (QuestVariable variable : ClientQuestFile.INSTANCE.variables) {
                panel.add((Widget)new ButtonQuestObject(panel, variable));
            }
        }
        boolean addChapters = this.config.hasValidType(QuestObjectType.CHAPTER);
        boolean addQuests = this.config.hasValidType(QuestObjectType.QUEST);
        boolean addTasks = this.config.hasValidType(QuestObjectType.TASK);
        for (QuestChapter chapter : ClientQuestFile.INSTANCE.chapters) {
            if (addChapters) {
                panel.add((Widget)new ButtonQuestObject(panel, chapter));
            }
            for (Quest quest : chapter.quests) {
                if (addQuests) {
                    panel.add((Widget)new ButtonQuestObject(panel, quest));
                }
                if (!addTasks) continue;
                for (QuestTask task : quest.tasks) {
                    panel.add((Widget)new ButtonQuestObject(panel, task));
                }
            }
        }
    }

    public class ButtonQuestObject
    extends SimpleTextButton {
        public final QuestObject object;

        public ButtonQuestObject(Panel panel, QuestObject o) {
            super(panel, o.getObjectType().getColor() + o.getDisplayName().func_150260_c(), o.getIcon());
            this.object = o;
            this.setSize(200, 14);
        }

        public void addMouseOverText(List<String> list) {
            list.add(this.object.getDisplayName().func_150254_d());
            list.add(TextFormatting.GRAY + "ID: " + TextFormatting.DARK_GRAY + this.object.getID());
            list.add(TextFormatting.GRAY + "Type: " + this.object.getObjectType().getColor() + I18n.func_135052_a((String)this.object.getObjectType().getTranslationKey(), (Object[])new Object[0]));
            if (this.object instanceof Quest) {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.chapter", (Object[])new Object[0]) + ": " + QuestObjectType.CHAPTER.getColor() + ((Quest)this.object).chapter.getDisplayName().func_150260_c());
            } else if (this.object instanceof QuestTask) {
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.chapter", (Object[])new Object[0]) + ": " + QuestObjectType.CHAPTER.getColor() + ((QuestTask)this.object).quest.chapter.getDisplayName().func_150260_c());
                list.add(TextFormatting.GRAY + I18n.func_135052_a((String)"ftbquests.quest", (Object[])new Object[0]) + ": " + QuestObjectType.QUEST.getColor() + ((QuestTask)this.object).quest.getDisplayName().func_150260_c());
            }
        }

        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            GuiSelectQuestObject.this.config.setString(this.object.getID());
            GuiSelectQuestObject.this.callback.openGui();
        }
    }
}

