/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.client;

import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestReward;
import com.feed_the_beast.ftbquests.quest.QuestVariable;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTaskData;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.TextFormatting;

public class ClientQuestProgress
implements ITeamData {
    private final String teamID;
    public final Map<QuestTask, QuestTaskData> taskData;
    public final Object2LongOpenHashMap<QuestVariable> variables;

    public ClientQuestProgress(String t) {
        this.teamID = t;
        this.taskData = new HashMap<QuestTask, QuestTaskData>();
        this.variables = new Object2LongOpenHashMap();
        this.variables.defaultReturnValue(0L);
    }

    @Override
    public String getTeamID() {
        return this.teamID;
    }

    @Override
    public QuestTaskData getQuestTaskData(QuestTask task) {
        QuestTaskData data = this.taskData.get(task);
        if (data == null) {
            return task.createData(this);
        }
        return data;
    }

    @Override
    public void syncTask(QuestTaskData data) {
    }

    @Override
    public void removeTask(QuestTask task) {
        this.taskData.remove(task);
    }

    @Override
    public void createTaskData(QuestTask task) {
        this.taskData.put(task, task.createData(this));
    }

    @Override
    public void unclaimRewards(Collection<QuestReward> rewards) {
        for (QuestReward reward : rewards) {
            ClientQuestFile.INSTANCE.rewards.rem(reward.uid);
        }
    }

    @Override
    public long getVariable(QuestVariable variable) {
        return this.variables.getLong((Object)variable);
    }

    @Override
    public void setVariable(QuestVariable variable, long value) {
        if (value <= 0L) {
            this.variables.removeLong((Object)variable);
        } else {
            this.variables.put((Object)variable, value);
        }
    }

    public static String getCompletionSuffix(@Nullable ClientQuestProgress progress, QuestObject object) {
        if (!GuiScreen.func_146272_n() && !(object instanceof QuestTask)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(TextFormatting.DARK_GRAY);
        if (progress == null) {
            builder.append(' ');
            builder.append("???");
        } else if (object instanceof QuestTask) {
            QuestTask task = (QuestTask)object;
            if (!task.hideProgressNumbers()) {
                QuestTaskData data = progress.getQuestTaskData(task);
                builder.append(" [");
                builder.append(data.getProgressString());
                builder.append(" / ");
                builder.append(task.getMaxProgressString());
                builder.append(']');
            }
        } else {
            builder.append(' ');
            builder.append(object.getRelativeProgress(progress));
            builder.append('%');
        }
        if (GuiScreen.func_146271_m()) {
            builder.append(' ');
            builder.append(object.getID());
        }
        return builder.toString();
    }
}

