/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.client;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftbquests.client.ClientQuestProgress;
import com.feed_the_beast.ftbquests.gui.GuiQuest;
import com.feed_the_beast.ftbquests.gui.GuiQuestTree;
import com.feed_the_beast.ftbquests.gui.GuiVariables;
import com.feed_the_beast.ftbquests.net.MessageSyncQuests;
import com.feed_the_beast.ftbquests.net.edit.MessageDeleteObject;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestReward;
import com.feed_the_beast.ftbquests.quest.tasks.QuestTask;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class ClientQuestFile
extends QuestFile {
    public static ClientQuestFile INSTANCE;
    public final Map<String, ClientQuestProgress> teamData;
    public ClientQuestProgress self;
    public GuiQuestTree questTreeGui;
    public GuiBase questGui;
    public boolean editingMode;
    public final IntCollection rewards;

    public static boolean exists() {
        return INSTANCE != null && !ClientQuestFile.INSTANCE.invalid;
    }

    public static boolean existsWithTeam() {
        return ClientQuestFile.exists() && ClientQuestFile.INSTANCE.self != null;
    }

    public ClientQuestFile(MessageSyncQuests message, @Nullable ClientQuestFile prev) {
        this.readData(message.quests);
        this.teamData = new HashMap<String, ClientQuestProgress>();
        for (MessageSyncQuests.TeamInst team : message.teamData) {
            int i;
            ClientQuestProgress data = new ClientQuestProgress(team.name);
            for (QuestTask task : this.allTasks) {
                data.createTaskData(task);
            }
            for (i = 0; i < team.taskKeys.length; ++i) {
                data.getQuestTaskData(this.allTasks[team.taskKeys[i]]).fromNBT(team.taskValues[i]);
            }
            for (i = 0; i < team.variableKeys.length; ++i) {
                data.variables.put(this.variables.get(team.variableKeys[i]), team.variableValues[i]);
            }
            this.teamData.put(data.getTeamID(), data);
        }
        this.self = message.team.isEmpty() ? null : this.teamData.get(message.team);
        this.editingMode = message.editingMode;
        this.rewards = new IntOpenHashSet(message.rewards);
        this.refreshGui(prev);
    }

    public boolean canEdit() {
        return this.editingMode;
    }

    public void refreshGui(@Nullable ClientQuestFile prev) {
        GuiQuest guiQuest;
        boolean guiOpen = false;
        int scrollX = 0;
        int scrollY = 0;
        String selectedChapter = "";
        if (prev != null) {
            scrollX = prev.questTreeGui.quests.getScrollX();
            scrollY = prev.questTreeGui.quests.getScrollY();
            String string = selectedChapter = prev.questTreeGui.selectedChapter == null ? "" : prev.questTreeGui.selectedChapter.getID();
            if (ClientUtils.getCurrentGuiAs(GuiQuestTree.class) != null) {
                guiOpen = true;
            }
        }
        this.questTreeGui = new GuiQuestTree(this);
        this.questGui = this.questTreeGui;
        if (prev != null) {
            this.questTreeGui.selectChapter(this.getChapter(selectedChapter));
            if (guiOpen) {
                this.questTreeGui.openGui();
            }
        }
        if ((guiQuest = (GuiQuest)((Object)ClientUtils.getCurrentGuiAs(GuiQuest.class))) != null) {
            guiQuest.refreshWidgets();
        } else {
            GuiQuestTree guiQuestTree = (GuiQuestTree)((Object)ClientUtils.getCurrentGuiAs(GuiQuestTree.class));
            if (guiQuestTree != null) {
                guiQuestTree.refreshWidgets();
            } else {
                GuiVariables guiVariables = (GuiVariables)((Object)ClientUtils.getCurrentGuiAs(GuiVariables.class));
                if (guiVariables != null) {
                    guiVariables.refreshWidgets();
                }
            }
        }
        if (prev != null) {
            this.questTreeGui.quests.setScrollX(scrollX);
            this.questTreeGui.quests.setScrollY(scrollY);
        }
    }

    public void openQuestGui() {
        this.questGui.openGui();
    }

    @Override
    @Nullable
    public ClientQuestProgress getData(String team) {
        return this.teamData.get(team);
    }

    public Collection<ClientQuestProgress> getAllData() {
        return this.teamData.values();
    }

    @Override
    public void deleteObject(String id) {
        new MessageDeleteObject(id).sendToServer();
    }

    public boolean isRewardClaimed(QuestReward reward) {
        return this.rewards.contains(reward.uid);
    }
}

