/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.thermalexpansion;

import cofh.thermalexpansion.util.managers.machine.RefineryManager;
import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.WeightedItemStack;
import crafttweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.Refinery")
@ModOnly(value="thermalexpansion")
@ZenRegister
public class Refinery {
    @ZenMethod
    public static void addRecipe(ILiquidStack output, WeightedItemStack outputItem, ILiquidStack input, int energy) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toFluid((ILiquidStack)output), InputHelper.toFluid((ILiquidStack)input), outputItem, energy));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack input) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(InputHelper.toFluid((ILiquidStack)input)));
    }

    private static class Remove
    extends BaseAction {
        private FluidStack input;

        public Remove(FluidStack input) {
            super("Refinery");
            this.input = input;
        }

        public void apply() {
            if (!RefineryManager.recipeExists((FluidStack)this.input)) {
                CraftTweakerAPI.logError((String)("No Refinery recipe exists for: " + this.input));
                return;
            }
            RefineryManager.removeRecipe((FluidStack)this.input);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((FluidStack)this.input);
        }
    }

    private static class Add
    extends BaseAction {
        private FluidStack output;
        private FluidStack input;
        private WeightedItemStack outputItem;
        private int energy;

        public Add(FluidStack output, FluidStack input, WeightedItemStack outputItem, int energy) {
            super("Refinery");
            this.output = output;
            this.input = input;
            this.outputItem = outputItem;
            this.energy = energy;
        }

        public void apply() {
            if (this.outputItem == null) {
                RefineryManager.addRecipe((int)this.energy, (FluidStack)this.input, (FluidStack)this.output);
            } else {
                RefineryManager.addRecipe((int)this.energy, (FluidStack)this.input, (FluidStack)this.output, (ItemStack)InputHelper.toStack((IItemStack)this.outputItem.getStack()), (int)((int)this.outputItem.getPercent()));
            }
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((FluidStack)this.output);
        }
    }
}

