/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.compat.thermalexpansion;

import cofh.thermalexpansion.util.managers.machine.SmelterManager;
import com.blamejared.ModTweaker;
import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.utils.BaseAction;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.thermalexpansion.InductionSmelter")
@ModOnly(value="thermalexpansion")
@ZenRegister
public class InductionSmelter {
    @ZenMethod
    public static void addRecipe(IItemStack primaryOutput, IItemStack primaryInput, IItemStack secondaryInput, int energy, @Optional IItemStack secondaryOutput, @Optional int secondaryChance) {
        ModTweaker.LATE_ADDITIONS.add((IAction)new Add(InputHelper.toStack((IItemStack)primaryOutput), InputHelper.toStack((IItemStack)primaryInput), InputHelper.toStack((IItemStack)secondaryInput), energy, InputHelper.toStack((IItemStack)secondaryOutput), secondaryChance));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack primaryInput, IItemStack secondaryInput) {
        ModTweaker.LATE_REMOVALS.add((IAction)new Remove(InputHelper.toStack((IItemStack)primaryInput), InputHelper.toStack((IItemStack)secondaryInput)));
    }

    private static class Remove
    extends BaseAction {
        private ItemStack primaryInput;
        private ItemStack secondaryInput;

        public Remove(ItemStack primaryInput, ItemStack secondaryInput) {
            super("InductionSmelter");
            this.primaryInput = primaryInput;
            this.secondaryInput = secondaryInput;
        }

        public void apply() {
            if (!SmelterManager.recipeExists((ItemStack)this.primaryInput, (ItemStack)this.secondaryInput)) {
                CraftTweakerAPI.logError((String)("No InductionSmelter recipe exists for: " + this.primaryInput + " and " + this.secondaryInput));
                return;
            }
            SmelterManager.removeRecipe((ItemStack)this.primaryInput, (ItemStack)this.secondaryInput);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.primaryInput) + " and " + LogHelper.getStackDescription((Object)this.secondaryInput);
        }
    }

    private static class Add
    extends BaseAction {
        private ItemStack primaryOutput;
        private ItemStack primaryInput;
        private ItemStack secondaryInput;
        private ItemStack secondaryOutput;
        private int energy;
        private int secondaryChance;

        public Add(ItemStack primaryOutput, ItemStack primaryInput, ItemStack secondaryInput, int energy, ItemStack secondaryOutput, int secondaryChance) {
            super("InductionSmelter");
            this.primaryOutput = primaryOutput;
            this.primaryInput = primaryInput;
            this.secondaryInput = secondaryInput;
            this.secondaryOutput = secondaryOutput;
            this.energy = energy;
            this.secondaryChance = secondaryChance;
            if (!secondaryOutput.func_190926_b() && secondaryChance <= 0) {
                this.secondaryChance = 100;
            }
        }

        public void apply() {
            SmelterManager.addRecipe((int)this.energy, (ItemStack)this.primaryInput, (ItemStack)this.secondaryInput, (ItemStack)this.primaryOutput, (ItemStack)this.secondaryOutput, (int)this.secondaryChance);
        }

        protected String getRecipeInfo() {
            return LogHelper.getStackDescription((Object)this.primaryOutput);
        }
    }
}

