/*
 * Decompiled with CFR 0.152.
 */
package modfix;

import java.io.File;
import java.io.IOException;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.world.World;
import org.apache.commons.io.FileUtils;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ModFixCT
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (name.equals("net.xalcon.torchmaster.common.TorchRegistry")) {
            ClassNode classNode = this.readClassFromBytes(basicClass);
            classNode.methods.stream().filter(methodNode -> methodNode.name.equals("registerTorch")).forEach(methodNode -> {
                System.out.println("Found registerTorch method");
                InsnList insnList = new InsnList();
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                String desc = "(Lnet/minecraft/world/World;)Z";
                insnList.add((AbstractInsnNode)new MethodInsnNode(184, "modfix/ModFixCT", "isBroken", desc, false));
                LabelNode l1 = new LabelNode();
                insnList.add((AbstractInsnNode)new JumpInsnNode(153, l1));
                insnList.add((AbstractInsnNode)new InsnNode(177));
                insnList.add((AbstractInsnNode)l1);
                insnList.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
                methodNode.instructions.insertBefore(methodNode.instructions.getFirst(), insnList);
                System.out.println("Patched registerTorch");
            });
            try {
                FileUtils.writeByteArrayToFile((File)new File("TorchRegistry.class"), (byte[])this.writeClassToBytes(classNode));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return this.writeClassToBytes(classNode);
        }
        return basicClass;
    }

    public static boolean isBroken(World world) {
        if (world == null || world.field_73011_w == null) {
            System.out.println("Torch master tried to load a torch in a null world. Mod Fix caught this error");
            return true;
        }
        return false;
    }

    private ClassNode readClassFromBytes(byte[] bytes) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        return classNode;
    }

    private byte[] writeClassToBytes(ClassNode classNode) {
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

