/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweak;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;

@CharsetModule(name="tweak.orderedPickup", description="Makes EntityItems picked up in order from oldest to youngest.", profile=ModuleProfile.FORCED)
public class CharsetTweakOrderedPickup {
    private final Object object = new Object();
    private final Map<EntityPlayer, List<EntityItem>> itemsToAdd = new WeakHashMap<EntityPlayer, List<EntityItem>>();
    private final ThreadLocal<Integer> processingPlayer = new ThreadLocal();
    private final ThreadLocal<Object> isInLoop = new ThreadLocal();

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.isInLoop.set(this.object);
        } else if (event.phase == TickEvent.Phase.END) {
            this.isInLoop.remove();
            this.processingPlayer.set(event.player.func_145782_y());
            List<EntityItem> list = this.itemsToAdd.remove(event.player);
            if (list != null) {
                list.sort((a, b) -> b.func_174872_o() - a.func_174872_o());
                for (EntityItem item : list) {
                    item.func_70100_b_(event.player);
                }
            }
            this.processingPlayer.remove();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityItemPickup(EntityItemPickupEvent event) {
        Integer procPlayer;
        if (this.isInLoop.get() != null && event.getEntityPlayer() != null && (procPlayer = this.processingPlayer.get()) != null && procPlayer.intValue() != event.getEntityPlayer().func_145782_y()) {
            event.setCanceled(true);
            this.itemsToAdd.computeIfAbsent(event.getEntityPlayer(), p -> Collections.synchronizedList(new ArrayList())).add(event.getItem());
        }
    }
}

