/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweak;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemCompass;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.network.PacketRegistry;

@CharsetModule(name="tweak.mapCompass", description="Holding a map in one hand and a compass in another will make the compass point to the map's center.", profile=ModuleProfile.FORCED)
public class CharsetTweakMapCompass {
    private static final ResourceLocation ANGLE = new ResourceLocation("angle");
    @CharsetModule.PacketRegistry
    private static PacketRegistry packet;

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        packet.registerPacket(1, PacketCompassAngle.class);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END) {
            ItemMap mapItem;
            MapData mapData;
            EntityPlayer entityIn = event.player;
            if (entityIn.func_130014_f_().func_82737_E() % 4L != 1L) {
                return;
            }
            ItemStack heldMain = entityIn.func_184586_b(EnumHand.MAIN_HAND);
            ItemStack heldOff = entityIn.func_184586_b(EnumHand.OFF_HAND);
            ItemStack heldOther = !heldMain.func_190926_b() && heldMain.func_77973_b() instanceof ItemCompass ? heldOff : (!heldOff.func_190926_b() && heldOff.func_77973_b() instanceof ItemCompass ? heldMain : ItemStack.field_190927_a);
            if (!heldOther.func_190926_b() && heldOther.func_77973_b() instanceof ItemMap && (mapData = (mapItem = (ItemMap)heldOther.func_77973_b()).func_77873_a(heldOther, entityIn.field_70170_p)) != null) {
                int xPos = mapData.field_76201_a;
                int zPos = mapData.field_76199_b;
                double angle = Math.atan2((double)zPos - entityIn.field_70161_v, (double)xPos - entityIn.field_70165_t) / (Math.PI * 2);
                double yaw = MathHelper.func_191273_b((double)((double)entityIn.field_70177_z / 360.0), (double)1.0);
                double value = 0.5 - (yaw - 0.25 - angle);
                packet.sendTo((Packet)new PacketCompassAngle(MathHelper.func_188207_b((float)((float)value), (float)1.0f)), entityIn);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        for (Item item : event.getRegistry()) {
            IItemPropertyGetter oldGetter;
            if (!(item instanceof ItemCompass) || (oldGetter = item.func_185045_a(ANGLE)) == null || oldGetter instanceof AngleOverride) continue;
            item.func_185043_a(ANGLE, (IItemPropertyGetter)new AngleOverride(oldGetter));
        }
    }

    public static class AngleOverride
    implements IItemPropertyGetter {
        private final IItemPropertyGetter oldGetter;
        private long lastUpdateTick;
        private double lastRotation;
        private double rotDirection;

        public AngleOverride(IItemPropertyGetter oldGetter) {
            this.oldGetter = oldGetter;
        }

        @SideOnly(value=Side.CLIENT)
        private float wobble(World worldIn, float value) {
            if (worldIn.func_82737_E() != this.lastUpdateTick) {
                this.lastUpdateTick = worldIn.func_82737_E();
                double difference = (double)value - this.lastRotation;
                difference = MathHelper.func_191273_b((double)(difference + 0.5), (double)1.0) - 0.5;
                this.rotDirection = (this.rotDirection + difference * 0.1) * 0.8;
                this.lastRotation = MathHelper.func_191273_b((double)(this.lastRotation + this.rotDirection), (double)1.0);
            }
            return (float)this.lastRotation;
        }

        public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
            if (entityIn == Minecraft.func_71410_x().field_71439_g && PacketCompassAngle.currentAngle >= 0.0f) {
                if (worldIn == null) {
                    worldIn = entityIn.field_70170_p;
                }
                ItemStack heldMain = entityIn.func_184586_b(EnumHand.MAIN_HAND);
                ItemStack heldOff = entityIn.func_184586_b(EnumHand.OFF_HAND);
                ItemStack heldOther = stack == heldMain ? heldOff : (stack == heldOff ? heldMain : ItemStack.field_190927_a);
                if (!heldOther.func_190926_b() && heldOther.func_77973_b() instanceof ItemMap) {
                    float value = this.wobble(worldIn, PacketCompassAngle.currentAngle);
                    return MathHelper.func_188207_b((float)value, (float)1.0f);
                }
            }
            this.lastRotation = this.oldGetter.func_185085_a(stack, worldIn, entityIn);
            this.rotDirection = 0.0;
            return (float)this.lastRotation;
        }
    }

    public static class PacketCompassAngle
    extends Packet {
        private static float currentAngle = -1.0f;
        private float angle;

        public PacketCompassAngle() {
        }

        public PacketCompassAngle(float angle) {
            this.angle = angle;
        }

        public void readData(INetHandler handler, PacketBuffer buf) {
            this.angle = buf.readFloat();
        }

        public void apply(INetHandler handler) {
            currentAngle = this.angle;
        }

        public void writeData(PacketBuffer buf) {
            buf.writeFloat(this.angle);
        }

        public boolean isAsynchronous() {
            return true;
        }
    }
}

