/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweak;

import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockStem;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.ModCharset;
import pl.asie.charset.lib.CharsetIMC;
import pl.asie.charset.lib.config.CharsetLoadConfigEvent;
import pl.asie.charset.lib.config.ConfigUtils;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.utils.ThreeState;

@CharsetModule(name="tweak.bonemeal", description="Options to restore classic bonemeal behaviour and whitelist bonemealable blocks.", profile=ModuleProfile.FORCED)
public class CharsetTweakBonemeal {
    private boolean instantGrowthDefault;
    private boolean growthWhitelist;
    private boolean heuristicEnabled;
    @CharsetModule.Configuration
    public static Configuration config;

    @Mod.EventHandler
    public void onLoadConfig(CharsetLoadConfigEvent event) {
        this.instantGrowthDefault = ConfigUtils.getBoolean((Configuration)config, (String)"general", (String)"allowInstantGrowth", (boolean)false, (String)"Is instant growth (old-style bonemeal) the default? Setting this to true means any non-blacklisted blocks grow instantly, setting this to false means only whitelisted ones do.", (boolean)true);
        this.growthWhitelist = ConfigUtils.getBoolean((Configuration)config, (String)"general", (String)"growthRequiresWhitelisting", (boolean)false, (String)"Does bonemeal only work on whitelisted blocks?", (boolean)true);
        this.heuristicEnabled = ConfigUtils.getBoolean((Configuration)config, (String)"general", (String)"instantGrowthUseHeuristic", (boolean)true, (String)"Enables heuristic handling of modded crops. Disable if modded crops start growing strangely or too quickly - or whitelist/blacklist the individual blocks.", (boolean)true);
    }

    private Integer getMax(PropertyInteger property) {
        Collection values = property.func_177700_c();
        if (values.size() == 0) {
            return null;
        }
        Integer v = null;
        for (Integer v2 : values) {
            if (v != null && v2 <= v) continue;
            v = v2;
        }
        return v;
    }

    private IBlockState withMax(IBlockState state, PropertyInteger property) {
        Integer gm = this.getMax(property);
        if (gm != null) {
            return state.func_177226_a((IProperty)property, (Comparable)gm);
        }
        return null;
    }

    @SubscribeEvent
    public void onApplyBonemeal(BonemealEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        IBlockState state = event.getBlock();
        Block block = state.func_177230_c();
        IBlockState stateNew = null;
        ThreeState instantGrowth = CharsetIMC.INSTANCE.allows("instantBonemeal", block.getRegistryName()).otherwise(ThreeState.from((boolean)this.instantGrowthDefault));
        ThreeState growth = CharsetIMC.INSTANCE.allows("bonemeal", block.getRegistryName()).otherwise(this.growthWhitelist ? ThreeState.NO : ThreeState.YES);
        if (growth == ThreeState.NO) {
            event.setCanceled(true);
            return;
        }
        if (instantGrowth == ThreeState.NO) {
            return;
        }
        if (block instanceof BlockCrops) {
            stateNew = ((BlockCrops)block).func_185528_e(((BlockCrops)block).func_185526_g());
        } else if (state.func_177227_a().contains(BlockCocoa.field_176501_a)) {
            stateNew = this.withMax(state, BlockCocoa.field_176501_a);
        } else {
            if (block instanceof BlockMushroom) {
                ((BlockMushroom)block).func_176474_b(event.getWorld(), event.getWorld().field_73012_v, event.getPos(), state);
                event.setResult(Event.Result.ALLOW);
                return;
            }
            if (block instanceof BlockSapling) {
                ((BlockSapling)block).func_176476_e(event.getWorld(), event.getPos(), state, event.getWorld().field_73012_v);
                event.setResult(Event.Result.ALLOW);
                return;
            }
            if (state.func_177227_a().contains(BlockStem.field_176484_a)) {
                stateNew = this.withMax(state, BlockStem.field_176484_a);
            } else {
                if (block instanceof BlockDoublePlant || block instanceof BlockTallGrass) {
                    return;
                }
                if (block instanceof BlockGrass) {
                    return;
                }
                if (block instanceof IGrowable && this.heuristicEnabled) {
                    int i = 128;
                    boolean canGrow = true;
                    while (i-- > 0 && canGrow) {
                        IBlockState stateTmp = event.getWorld().func_180495_p(event.getPos());
                        Block blockTmp = stateTmp.func_177230_c();
                        if (!(blockTmp instanceof IGrowable) || !((IGrowable)blockTmp).func_176473_a(event.getWorld(), event.getPos(), event.getBlock(), false)) continue;
                        ((IGrowable)blockTmp).func_176474_b(event.getWorld(), event.getWorld().field_73012_v, event.getPos(), event.getBlock());
                        canGrow = ((IGrowable)blockTmp).func_176473_a(event.getWorld(), event.getPos(), event.getBlock(), false);
                    }
                    if (canGrow) {
                        ModCharset.logger.warn("Found block " + block.getRegistryName() + " which insists on continuing to grow! Odd. Perhaps the Charset mod author would like to know more?");
                    }
                    event.setResult(Event.Result.ALLOW);
                    return;
                }
                return;
            }
        }
        if (stateNew != null) {
            if (stateNew != state) {
                event.getWorld().func_180501_a(event.getPos(), stateNew, 2);
                event.setResult(Event.Result.ALLOW);
            } else {
                return;
            }
        }
    }
}

