/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweak;

import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.utils.ColorUtils;

@CharsetModule(name="tweak.anvilDyeItems", description="Allows dyeing item names in an anvil", antidependencies={"mod:quark"}, profile=ModuleProfile.FORCED)
public class CharsetTweakAnvilDyeItems {
    @SubscribeEvent(priority=EventPriority.LOW)
    public void onAnvilUpdate(AnvilUpdateEvent event) {
        EnumDyeColor color;
        if (!event.getLeft().func_190926_b() && !event.getRight().func_190926_b() && event.getLeft().func_190916_E() == event.getRight().func_190916_E() && (color = ColorUtils.getDyeColor((ItemStack)event.getRight())) != null) {
            event.setCost(event.getLeft().func_190916_E() * 3);
            if (event.getOutput().func_190926_b()) {
                event.setOutput(event.getLeft().func_77946_l());
            }
            NBTTagCompound compound = event.getOutput().func_190925_c("display");
            compound.func_74774_a("_chdytw_color", (byte)color.func_176767_b());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    @SideOnly(value=Side.CLIENT)
    public void onItemTooltip(ItemTooltipEvent event) {
        NBTTagCompound displayCpd;
        NBTTagCompound compound = event.getItemStack().func_77978_p();
        if (compound != null && compound.func_150297_b("display", 10) && (displayCpd = compound.func_74775_l("display")).func_74764_b("_chdytw_color")) {
            EnumDyeColor color = EnumDyeColor.func_176766_a((int)displayCpd.func_74771_c("_chdytw_color"));
            String s = event.getItemStack().func_82833_r();
            for (int i = 0; i < event.getToolTip().size(); ++i) {
                String s2 = TextFormatting.func_110646_a((String)((String)event.getToolTip().get(i)));
                if (!s.equals(s2)) continue;
                event.getToolTip().set(i, ColorUtils.getNearestTextFormatting((EnumDyeColor)color) + s2);
                return;
            }
        }
    }
}

