/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.container.transfer;

import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.container.transfer.IInventoryWrapper;
import com.raoulvdberge.refinedstorage.container.transfer.InsertionResult;
import com.raoulvdberge.refinedstorage.container.transfer.InsertionResultType;
import com.raoulvdberge.refinedstorage.container.transfer.InventoryWrapperFilter;
import com.raoulvdberge.refinedstorage.container.transfer.InventoryWrapperFilterFluid;
import com.raoulvdberge.refinedstorage.container.transfer.InventoryWrapperFilterItem;
import com.raoulvdberge.refinedstorage.container.transfer.InventoryWrapperInventory;
import com.raoulvdberge.refinedstorage.container.transfer.InventoryWrapperItemHandler;
import com.raoulvdberge.refinedstorage.inventory.fluid.FluidInventory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class TransferManager {
    private Map<IInventoryWrapper, List<IInventoryWrapper>> fromToMap = new HashMap<IInventoryWrapper, List<IInventoryWrapper>>();
    private Container container;
    @Nullable
    private Function<Integer, ItemStack> notFoundHandler;

    public TransferManager(Container container) {
        this.container = container;
    }

    public void clearTransfers() {
        this.fromToMap.clear();
    }

    public void setNotFoundHandler(@Nullable Function<Integer, ItemStack> handler) {
        this.notFoundHandler = handler;
    }

    public void addTransfer(IInventory from, IItemHandler to) {
        this.addTransfer(new InventoryWrapperInventory(from), new InventoryWrapperItemHandler(to));
    }

    public void addFilterTransfer(IInventory from, IItemHandlerModifiable itemTo, FluidInventory fluidTo, Supplier<Integer> typeGetter) {
        this.addTransfer(new InventoryWrapperInventory(from), new InventoryWrapperFilter(itemTo, fluidTo, typeGetter));
    }

    public void addItemFilterTransfer(IInventory from, IItemHandlerModifiable to) {
        this.addTransfer(new InventoryWrapperInventory(from), new InventoryWrapperFilterItem(to));
    }

    public void addFluidFilterTransfer(IInventory from, FluidInventory to) {
        this.addTransfer(new InventoryWrapperInventory(from), new InventoryWrapperFilterFluid(to));
    }

    public void addTransfer(IItemHandler from, IInventory to) {
        this.addTransfer(new InventoryWrapperItemHandler(from), new InventoryWrapperInventory(to));
    }

    public void addBiTransfer(IInventory from, IItemHandler to) {
        this.addTransfer(from, to);
        this.addTransfer(to, from);
    }

    private void addTransfer(IInventoryWrapper from, IInventoryWrapper to) {
        List toList = this.fromToMap.computeIfAbsent(from, k -> new LinkedList());
        toList.add(to);
    }

    public ItemStack transfer(int index) {
        Slot slot = this.container.func_75139_a(index);
        IInventoryWrapper key = slot instanceof SlotItemHandler ? new InventoryWrapperItemHandler(((SlotItemHandler)slot).getItemHandler()) : new InventoryWrapperInventory(slot.field_75224_c);
        List<IInventoryWrapper> toList = this.fromToMap.get(key);
        if (toList != null) {
            IInventoryWrapper to;
            InsertionResult result;
            ItemStack initial = slot.func_75211_c().func_77946_l();
            ItemStack remainder = slot.func_75211_c();
            Iterator<IInventoryWrapper> iterator = toList.iterator();
            while (iterator.hasNext() && (result = (to = iterator.next()).insert(remainder)).getType() != InsertionResultType.STOP && (result.getType() != InsertionResultType.CONTINUE_IF_POSSIBLE || !(remainder = result.getValue()).func_190926_b())) {
            }
            slot.func_75215_d(remainder);
            slot.func_75218_e();
            if (API.instance().getComparer().isEqual(remainder, initial) && this.notFoundHandler != null) {
                return this.notFoundHandler.apply(index);
            }
        } else if (this.notFoundHandler != null) {
            return this.notFoundHandler.apply(index);
        }
        return ItemStack.field_190927_a;
    }
}

