/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.container.slot.filter;

import com.raoulvdberge.refinedstorage.container.slot.SlotBase;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBlockSpecial;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.items.IItemHandler;

public class SlotFilter
extends SlotBase {
    public static final int FILTER_ALLOW_SIZE = 1;
    public static final int FILTER_ALLOW_BLOCKS = 2;
    private int flags = 0;

    public SlotFilter(IItemHandler handler, int inventoryIndex, int x, int y, int flags) {
        super(handler, inventoryIndex, x, y);
        this.flags = flags;
    }

    public SlotFilter(IItemHandler handler, int inventoryIndex, int x, int y) {
        this(handler, inventoryIndex, x, y, 0);
    }

    public boolean func_75214_a(@Nonnull ItemStack stack) {
        if (super.func_75214_a(stack)) {
            if (this.isBlockAllowed()) {
                return stack.func_77973_b() instanceof ItemBlock || stack.func_77973_b() instanceof ItemBlockSpecial || stack.func_77973_b() instanceof IPlantable || stack.func_77973_b() instanceof ItemSkull;
            }
            return true;
        }
        return false;
    }

    public void func_75215_d(@Nonnull ItemStack stack) {
        if (!stack.func_190926_b() && !this.isSizeAllowed()) {
            stack.func_190920_e(1);
        }
        super.func_75215_d(stack);
    }

    public boolean isSizeAllowed() {
        return (this.flags & 1) == 1;
    }

    public boolean isBlockAllowed() {
        return (this.flags & 2) == 2;
    }

    public int getModifiedAmount(int dragType) {
        int amount = this.func_75211_c().func_190916_E();
        if (dragType == 0) {
            amount = Math.max(1, amount - 1);
        } else if (dragType == 1) {
            amount = Math.min(this.func_75211_c().func_77976_d(), amount + 1);
        }
        return amount;
    }

    @Nullable
    public static IBlockState getBlockState(IBlockAccess world, BlockPos pos, @Nullable ItemStack stack) {
        if (stack != null) {
            Item item = stack.func_77973_b();
            if (item instanceof ItemBlockSpecial) {
                return ((ItemBlockSpecial)item).getBlock().func_176223_P();
            }
            if (item instanceof ItemBlock) {
                return ((ItemBlock)item).func_179223_d().func_176223_P();
            }
            if (item instanceof IPlantable) {
                return ((IPlantable)item).getPlant(world, pos);
            }
            if (item instanceof ItemSkull) {
                return Blocks.field_150465_bP.func_176223_P();
            }
        }
        return null;
    }
}

