/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNodeExternalStorage;
import com.raoulvdberge.refinedstorage.apiimpl.storage.externalstorage.StorageExternalFluid;
import com.raoulvdberge.refinedstorage.inventory.fluid.FluidHandlerProxy;
import com.raoulvdberge.refinedstorage.inventory.fluid.FluidInventory;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerUpgrade;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.TileFluidInterface;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class NetworkNodeFluidInterface
extends NetworkNode {
    public static final String ID = "fluid_interface";
    public static final int TANK_CAPACITY = 16000;
    private static final String NBT_TANK_IN = "TankIn";
    private static final String NBT_TANK_OUT = "TankOut";
    private static final String NBT_OUT = "Out";
    private FluidTank tankIn = new FluidTank(16000){

        protected void onContentsChanged() {
            super.onContentsChanged();
            if (!NetworkNodeFluidInterface.this.world.field_72995_K) {
                ((TileFluidInterface)NetworkNodeFluidInterface.this.world.func_175625_s(NetworkNodeFluidInterface.this.pos)).getDataManager().sendParameterToWatchers(TileFluidInterface.TANK_IN);
            }
            NetworkNodeFluidInterface.this.markDirty();
        }
    };
    private FluidTank tankOut = new FluidTank(16000);
    private FluidHandlerProxy tank = new FluidHandlerProxy(this.tankIn, this.tankOut);
    private ItemHandlerBase in = new ItemHandlerBase(1, new ListenerNetworkNode(this), stack -> StackUtils.getFluid(stack, true).getRight() != null);
    private FluidInventory out = new FluidInventory(1, 16000, new ListenerNetworkNode(this));
    private ItemHandlerUpgrade upgrades = new ItemHandlerUpgrade(4, (Consumer<Integer>)new ListenerNetworkNode(this), 2, 4, 3);

    public NetworkNodeFluidInterface(World world, BlockPos pos) {
        super(world, pos);
        this.tankIn.setCanDrain(false);
        this.tankIn.setCanFill(true);
        this.tankOut.setCanDrain(true);
        this.tankOut.setCanFill(false);
    }

    @Override
    public void update() {
        super.update();
        if (this.network != null && this.canUpdate()) {
            FluidStack remainder;
            FluidStack drained;
            Pair<ItemStack, FluidStack> result;
            ItemStack container = this.in.getStackInSlot(0);
            if (!container.func_190926_b() && (result = StackUtils.getFluid(container, true)).getValue() != null && this.tankIn.fillInternal((FluidStack)result.getValue(), false) == ((FluidStack)result.getValue()).amount) {
                result = StackUtils.getFluid(container, false);
                this.tankIn.fillInternal((FluidStack)result.getValue(), true);
                this.in.setStackInSlot(0, (ItemStack)result.getLeft());
            }
            if (this.ticks % this.upgrades.getSpeed() == 0 && (drained = this.tankIn.drainInternal(1000 * this.upgrades.getItemInteractCount(), true)) != null && (remainder = this.network.insertFluidTracked(drained, drained.amount)) != null) {
                this.tankIn.fillInternal(remainder, true);
            }
            FluidStack wanted = this.out.getFluid(0);
            FluidStack got = this.tankOut.getFluid();
            if (wanted == null) {
                if (got != null) {
                    this.tankOut.setFluid(this.network.insertFluidTracked(got, got.amount));
                    this.onTankOutChanged();
                }
            } else if (got != null && !API.instance().getComparer().isEqual(wanted, got, 2)) {
                this.tankOut.setFluid(this.network.insertFluidTracked(got, got.amount));
                this.onTankOutChanged();
            } else {
                int delta;
                int n = delta = got == null ? wanted.amount : wanted.amount - got.amount;
                if (delta > 0) {
                    boolean actingAsStorage = this.isActingAsStorage();
                    FluidStack result2 = this.network.extractFluid(wanted, delta, 2, Action.PERFORM, s -> {
                        if (!actingAsStorage) {
                            return true;
                        }
                        return !(s instanceof StorageExternalFluid) || !((StorageExternalFluid)s).isConnectedToInterface();
                    });
                    if (result2 != null) {
                        if (this.tankOut.getFluid() == null) {
                            this.tankOut.setFluid(result2);
                        } else {
                            this.tankOut.getFluid().amount += result2.amount;
                        }
                        this.onTankOutChanged();
                    }
                    if ((delta -= result2 == null ? 0 : result2.amount) > 0 && this.upgrades.hasUpgrade(3)) {
                        this.network.getCraftingManager().request(wanted, delta);
                    }
                } else if (delta < 0) {
                    FluidStack remainder2 = this.network.insertFluidTracked(got, Math.abs(delta));
                    this.tankOut.getFluid().amount = remainder2 == null ? (this.tankOut.getFluid().amount -= Math.abs(delta)) : (this.tankOut.getFluid().amount -= Math.abs(delta) - remainder2.amount);
                    this.onTankOutChanged();
                }
            }
        }
    }

    private boolean isActingAsStorage() {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            INetworkNode facingNode = API.instance().getNetworkNodeManager(this.world).getNode(this.pos.func_177972_a(facing));
            if (!(facingNode instanceof NetworkNodeExternalStorage) || !facingNode.canUpdate() || ((NetworkNodeExternalStorage)facingNode).getDirection() != facing.func_176734_d() || ((NetworkNodeExternalStorage)facingNode).getType() != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.fluidInterfaceUsage;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, 0, tag);
        StackUtils.writeItems((IItemHandler)this.in, 1, tag);
        tag.func_74782_a(NBT_TANK_IN, (NBTBase)this.tankIn.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a(NBT_TANK_OUT, (NBTBase)this.tankOut.writeToNBT(new NBTTagCompound()));
        return tag;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.upgrades, 0, tag);
        StackUtils.readItems((IItemHandlerModifiable)this.in, 1, tag);
        if (tag.func_74764_b(NBT_TANK_IN)) {
            this.tankIn.readFromNBT(tag.func_74775_l(NBT_TANK_IN));
        }
        if (tag.func_74764_b(NBT_TANK_OUT)) {
            this.tankOut.readFromNBT(tag.func_74775_l(NBT_TANK_OUT));
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74782_a(NBT_OUT, (NBTBase)this.out.writeToNbt());
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_OUT)) {
            this.out.readFromNbt(tag.func_74775_l(NBT_OUT));
        }
    }

    public ItemHandlerUpgrade getUpgrades() {
        return this.upgrades;
    }

    public ItemHandlerBase getIn() {
        return this.in;
    }

    public FluidInventory getOut() {
        return this.out;
    }

    public FluidHandlerProxy getTank() {
        return this.tank;
    }

    public FluidTank getTankIn() {
        return this.tankIn;
    }

    public FluidTank getTankOut() {
        return this.tankOut;
    }

    private void onTankOutChanged() {
        if (!this.world.field_72995_K) {
            ((TileFluidInterface)this.world.func_175625_s(this.pos)).getDataManager().sendParameterToWatchers(TileFluidInterface.TANK_OUT);
        }
        this.markDirty();
    }

    @Override
    public IItemHandler getDrops() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.in, this.upgrades});
    }

    @Override
    public boolean hasConnectivityState() {
        return true;
    }
}

