/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.item;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.IWirelessTransmitter;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItem;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemHandler;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemProvider;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class NetworkItemHandler
implements INetworkItemHandler {
    private INetwork network;
    private Map<EntityPlayer, INetworkItem> items = new ConcurrentHashMap<EntityPlayer, INetworkItem>();

    public NetworkItemHandler(INetwork network) {
        this.network = network;
    }

    @Override
    public void onOpen(EntityPlayer player, EnumHand hand) {
        boolean inRange = false;
        for (INetworkNode node : this.network.getNodeGraph().all()) {
            IWirelessTransmitter transmitter;
            double distance;
            if (!(node instanceof IWirelessTransmitter) || !node.canUpdate() || ((IWirelessTransmitter)((Object)node)).getDimension() != player.field_71093_bK || !((distance = Math.sqrt(Math.pow((double)(transmitter = (IWirelessTransmitter)((Object)node)).getOrigin().func_177958_n() - player.field_70165_t, 2.0) + Math.pow((double)transmitter.getOrigin().func_177956_o() - player.field_70163_u, 2.0) + Math.pow((double)transmitter.getOrigin().func_177952_p() - player.field_70161_v, 2.0))) < (double)transmitter.getRange())) continue;
            inRange = true;
            break;
        }
        if (!inRange) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("misc.refinedstorage:network_item.out_of_range", new Object[0]));
            return;
        }
        INetworkItem item = ((INetworkItemProvider)player.func_184586_b(hand).func_77973_b()).provide(this, player, player.func_184586_b(hand));
        if (item.onOpen(this.network, player, hand)) {
            this.items.put(player, item);
        }
    }

    @Override
    public void onClose(EntityPlayer player) {
        this.items.remove(player);
    }

    @Override
    public INetworkItem getItem(EntityPlayer player) {
        return this.items.get(player);
    }
}

