/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.step;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.extractor.CraftingExtractor;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.extractor.CraftingExtractorStack;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.inserter.CraftingInserter;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.step.CraftingStep;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public class CraftingStepCraft
extends CraftingStep {
    public static final String TYPE = "craft";
    private static final String NBT_EXTRACTOR = "Extractor";
    private static final String NBT_TOOK = "Took";
    private CraftingInserter inserter;
    private CraftingExtractor extractor;
    private NonNullList<ItemStack> took;

    public CraftingStepCraft(ICraftingPattern pattern, CraftingInserter inserter, INetwork network, List<ItemStack> toExtract, NonNullList<ItemStack> took) {
        super(pattern);
        if (pattern.isProcessing()) {
            throw new IllegalArgumentException("Cannot pass processing pattern to craft handler");
        }
        this.inserter = inserter;
        this.extractor = new CraftingExtractor(network, toExtract.stream().map(CraftingExtractorStack::new).collect(Collectors.toList()), false);
        this.took = took;
    }

    public CraftingStepCraft(ICraftingPattern pattern, CraftingInserter inserter, INetwork network, NBTTagCompound tag) throws CraftingTaskReadException {
        super(pattern);
        if (pattern.isProcessing()) {
            throw new IllegalArgumentException("Cannot pass processing pattern to craft handler");
        }
        this.inserter = inserter;
        this.extractor = new CraftingExtractor(network, tag.func_150295_c(NBT_EXTRACTOR, 10), false);
        this.took = NonNullList.func_191196_a();
        NBTTagList tookList = tag.func_150295_c(NBT_TOOK, 10);
        for (int i = 0; i < tookList.func_74745_c(); ++i) {
            this.took.add((Object)StackUtils.deserializeStackFromNbt(tookList.func_150305_b(i)));
        }
    }

    @Override
    public boolean canExecute() {
        this.extractor.updateStatus(null, null);
        return this.extractor.isAllAvailable();
    }

    @Override
    public boolean execute() {
        this.extractor.extractOne(null, null);
        boolean allExtracted = this.extractor.isAllExtracted();
        if (allExtracted) {
            this.inserter.insert(this.pattern.getOutput(this.took));
            for (ItemStack byproduct : this.pattern.getByproducts(this.took)) {
                this.inserter.insert(byproduct);
            }
        }
        return allExtracted;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound tag = super.writeToNbt();
        tag.func_74782_a(NBT_EXTRACTOR, (NBTBase)this.extractor.writeToNbt());
        NBTTagList took = new NBTTagList();
        for (ItemStack stack : this.took) {
            took.func_74742_a((NBTBase)StackUtils.serializeStackToNbt(stack));
        }
        tag.func_74782_a(NBT_TOOK, (NBTBase)took);
        return tag;
    }

    public CraftingExtractor getExtractor() {
        return this.extractor;
    }
}

