/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.step;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingTask;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.inserter.CraftingInserter;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.step.CraftingStepCraft;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.step.CraftingStepProcess;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class CraftingStep {
    private static final String NBT_PATTERN = "Pattern";
    private static final String NBT_COMPLETED = "Completed";
    private static final String NBT_TYPE = "Type";
    protected ICraftingPattern pattern;
    private boolean completed;

    public CraftingStep(ICraftingPattern pattern) {
        this.pattern = pattern;
    }

    public abstract boolean canExecute();

    public abstract boolean execute();

    public ICraftingPattern getPattern() {
        return this.pattern;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted() {
        this.completed = true;
    }

    public abstract String getType();

    public NBTTagCompound writeToNbt() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(NBT_PATTERN, (NBTBase)CraftingTask.writePatternToNbt(this.pattern));
        tag.func_74757_a(NBT_COMPLETED, this.completed);
        tag.func_74778_a(NBT_TYPE, this.getType());
        return tag;
    }

    public static CraftingStep readFromNbt(INetwork network, CraftingInserter inserter, NBTTagCompound tag) throws CraftingTaskReadException {
        CraftingStep step;
        String type;
        ICraftingPattern pattern = CraftingTask.readPatternFromNbt(tag.func_74775_l(NBT_PATTERN), network.world());
        boolean completed = tag.func_74767_n(NBT_COMPLETED);
        switch (type = tag.func_74779_i(NBT_TYPE)) {
            case "craft": {
                step = new CraftingStepCraft(pattern, inserter, network, tag);
                break;
            }
            case "process": {
                step = new CraftingStepProcess(pattern, network, tag);
                break;
            }
            default: {
                throw new CraftingTaskReadException("Unknown crafting step type");
            }
        }
        if (completed) {
            step.setCompleted();
        }
        return step;
    }
}

