/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.extractor;

import com.raoulvdberge.refinedstorage.api.autocrafting.task.CraftingTaskReadException;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.CraftingTask;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.extractor.CraftingExtractorStack;
import com.raoulvdberge.refinedstorage.apiimpl.autocrafting.task.extractor.CraftingExtractorStatus;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CraftingExtractor {
    private INetwork network;
    private List<CraftingExtractorStack> stacks;
    private boolean processing;

    public CraftingExtractor(INetwork network, List<CraftingExtractorStack> stacks, boolean processing) {
        this.network = network;
        this.stacks = stacks;
        this.processing = processing;
    }

    public CraftingExtractor(INetwork network, NBTTagList tag, boolean processing) throws CraftingTaskReadException {
        this.network = network;
        this.processing = processing;
        this.stacks = new ArrayList<CraftingExtractorStack>();
        for (int i = 0; i < tag.func_74745_c(); ++i) {
            this.stacks.add(new CraftingExtractorStack(tag.func_150305_b(i)));
        }
    }

    public List<CraftingExtractorStack> getStacks() {
        return this.stacks;
    }

    public void updateStatus(@Nullable IItemHandler processingInventory, @Nullable IFluidHandler processingFluidInventory) {
        boolean updated = false;
        for (CraftingExtractorStack stack : this.stacks) {
            FluidStack inNetwork;
            if (stack.getStatus() == CraftingExtractorStatus.EXTRACTED) continue;
            CraftingExtractorStatus previousStatus = stack.getStatus();
            if (stack.getItem() != null) {
                ItemStack item = stack.getItem();
                inNetwork = this.network.extractItem(item, item.func_190916_E(), CraftingTask.getFlags(item), Action.SIMULATE);
                if (inNetwork == null || inNetwork.func_190916_E() < item.func_190916_E()) {
                    stack.setStatus(CraftingExtractorStatus.MISSING);
                } else {
                    stack.setStatus(CraftingExtractorStatus.AVAILABLE);
                    if (this.processing) {
                        if (processingInventory == null) {
                            stack.setStatus(CraftingExtractorStatus.MACHINE_NONE);
                        } else if (!ItemHandlerHelper.insertItem((IItemHandler)processingInventory, (ItemStack)item, (boolean)true).func_190926_b()) {
                            stack.setStatus(CraftingExtractorStatus.MACHINE_DOES_NOT_ACCEPT);
                        }
                    }
                }
            } else {
                FluidStack fluid = stack.getFluid();
                inNetwork = this.network.extractFluid(fluid, fluid.amount, 2, Action.SIMULATE);
                if (inNetwork == null || inNetwork.amount < fluid.amount) {
                    stack.setStatus(CraftingExtractorStatus.MISSING);
                } else {
                    stack.setStatus(CraftingExtractorStatus.AVAILABLE);
                    if (processingFluidInventory == null) {
                        stack.setStatus(CraftingExtractorStatus.MACHINE_NONE);
                    } else if (processingFluidInventory.fill(fluid, false) != fluid.amount) {
                        stack.setStatus(CraftingExtractorStatus.MACHINE_DOES_NOT_ACCEPT);
                    }
                }
            }
            if (previousStatus == stack.getStatus()) continue;
            updated = true;
        }
        if (updated) {
            this.network.getCraftingManager().onTaskChanged();
        }
    }

    public boolean isAllAvailable() {
        return !this.stacks.isEmpty() && this.stacks.stream().allMatch(s -> s.getStatus() == CraftingExtractorStatus.AVAILABLE || s.getStatus() == CraftingExtractorStatus.EXTRACTED);
    }

    public boolean isAllExtracted() {
        return !this.stacks.isEmpty() && this.stacks.stream().allMatch(s -> s.getStatus() == CraftingExtractorStatus.EXTRACTED);
    }

    public void extractOne(@Nullable IItemHandler processingInventory, @Nullable IFluidHandler processingFluidInventory) {
        boolean changed = false;
        for (CraftingExtractorStack stack : this.stacks) {
            FluidStack extracted;
            if (stack.getStatus() != CraftingExtractorStatus.AVAILABLE) continue;
            if (stack.getItem() != null) {
                ItemStack item = stack.getItem();
                extracted = this.network.extractItem(item, item.func_190916_E(), CraftingTask.getFlags(item), Action.PERFORM);
                if (extracted == null) {
                    throw new IllegalStateException("Did not extract anything while available");
                }
                if (this.processing) {
                    if (processingInventory == null) {
                        throw new IllegalStateException("Processing inventory is null");
                    }
                    ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)processingInventory, (ItemStack)extracted, (boolean)false);
                    if (!remainder.func_190926_b()) {
                        throw new IllegalStateException("The processing inventory gave back a remainder while it previously stated it could handle all");
                    }
                }
                stack.setStatus(CraftingExtractorStatus.EXTRACTED);
                changed = true;
            } else {
                FluidStack fluid = stack.getFluid();
                extracted = this.network.extractFluid(fluid, fluid.amount, 2, Action.PERFORM);
                if (extracted == null) {
                    throw new IllegalStateException("Did not extract any fluids while available");
                }
                if (processingFluidInventory == null) {
                    throw new IllegalStateException("Processing fluid inventory is null");
                }
                int filled = processingFluidInventory.fill(fluid, true);
                if (filled != fluid.amount) {
                    throw new IllegalStateException("The processing fluid inventory gave back a remainder while it previously stated it could handle all");
                }
                stack.setStatus(CraftingExtractorStatus.EXTRACTED);
                changed = true;
            }
            if (!this.processing) {
                return;
            }
            this.updateStatus(processingInventory, processingFluidInventory);
        }
        if (changed) {
            this.network.getCraftingManager().onTaskChanged();
        }
    }

    public NBTTagList writeToNbt() {
        NBTTagList list = new NBTTagList();
        for (CraftingExtractorStack stack : this.stacks) {
            list.func_74742_a((NBTBase)stack.writeToNbt());
        }
        return list;
    }
}

