/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor;

import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CraftingMonitorElementItemRender
implements ICraftingMonitorElement {
    public static final String ID = "item_render";
    private ItemStack stack;
    private int quantity;
    private int offset;

    public CraftingMonitorElementItemRender(ItemStack stack, int quantity, int offset) {
        this.stack = stack;
        this.quantity = quantity;
        this.offset = offset;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, IElementDrawers drawers, boolean selected) {
        if (selected) {
            drawers.getOverlayDrawer().draw(x, y, -3355444);
        }
        drawers.getItemDrawer().draw(x + 2 + this.offset, y + 1, this.stack);
        float scale = drawers.getFontRenderer().func_82883_a() ? 1.0f : 0.5f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        drawers.getStringDrawer().draw(RenderUtils.getOffsetOnScale(x + 21 + this.offset, scale), RenderUtils.getOffsetOnScale(y + 7, scale), this.quantity + "x " + this.stack.func_82833_r());
        GlStateManager.func_179121_F();
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void write(ByteBuf buf) {
        StackUtils.writeItemStack(buf, this.stack);
        buf.writeInt(this.quantity);
        buf.writeInt(this.offset);
    }

    @Override
    public boolean merge(ICraftingMonitorElement element) {
        if (element.getId().equals(this.getId()) && this.elementHashCode() == element.elementHashCode()) {
            this.quantity += ((CraftingMonitorElementItemRender)element).quantity;
            return true;
        }
        return false;
    }

    @Override
    public int elementHashCode() {
        return API.instance().getItemStackHashCode(this.stack);
    }
}

