/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.autocrafting.craftingmonitor;

import com.raoulvdberge.refinedstorage.api.autocrafting.craftingmonitor.ICraftingMonitorElement;
import com.raoulvdberge.refinedstorage.api.render.IElementDrawers;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CraftingMonitorElementFluidRender
implements ICraftingMonitorElement {
    public static final String ID = "fluid_render";
    private FluidStack stack;
    private int quantity;
    private int offset;

    public CraftingMonitorElementFluidRender(FluidStack stack, int quantity, int offset) {
        this.stack = stack;
        this.quantity = quantity;
        this.offset = offset;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, IElementDrawers drawers, boolean selected) {
        if (selected) {
            drawers.getOverlayDrawer().draw(x, y, -3355444);
        }
        drawers.getFluidDrawer().draw(x + 2 + this.offset, y + 1, this.stack);
        float scale = drawers.getFontRenderer().func_82883_a() ? 1.0f : 0.5f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        drawers.getStringDrawer().draw(RenderUtils.getOffsetOnScale(x + 21 + this.offset, scale), RenderUtils.getOffsetOnScale(y + 7, scale), API.instance().getQuantityFormatter().formatInBucketForm(this.quantity) + " " + this.stack.getLocalizedName());
        GlStateManager.func_179121_F();
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void write(ByteBuf buf) {
        StackUtils.writeFluidStack(buf, this.stack);
        buf.writeInt(this.quantity);
        buf.writeInt(this.offset);
    }

    @Override
    public boolean merge(ICraftingMonitorElement element) {
        if (element.getId().equals(this.getId()) && this.elementHashCode() == element.elementHashCode()) {
            this.quantity += ((CraftingMonitorElementFluidRender)element).quantity;
            return true;
        }
        return false;
    }

    @Override
    public int elementHashCode() {
        return API.instance().getFluidStackHashCode(this.stack);
    }
}

