/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.api.network;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingManager;
import com.raoulvdberge.refinedstorage.api.energy.IEnergy;
import com.raoulvdberge.refinedstorage.api.network.INetworkNodeGraph;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IFluidGridHandler;
import com.raoulvdberge.refinedstorage.api.network.grid.handler.IItemGridHandler;
import com.raoulvdberge.refinedstorage.api.network.item.INetworkItemHandler;
import com.raoulvdberge.refinedstorage.api.network.readerwriter.IReaderWriterManager;
import com.raoulvdberge.refinedstorage.api.network.security.ISecurityManager;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCache;
import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import com.raoulvdberge.refinedstorage.api.util.Action;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public interface INetwork {
    public int getEnergyUsage();

    public BlockPos getPosition();

    public boolean canRun();

    public INetworkNodeGraph getNodeGraph();

    public ISecurityManager getSecurityManager();

    public ICraftingManager getCraftingManager();

    public IEnergy getEnergy();

    public IItemGridHandler getItemGridHandler();

    public IFluidGridHandler getFluidGridHandler();

    public INetworkItemHandler getNetworkItemHandler();

    public IStorageCache<ItemStack> getItemStorageCache();

    public IStorageCache<FluidStack> getFluidStorageCache();

    public IReaderWriterManager getReaderWriterManager();

    @Nullable
    public ItemStack insertItem(@Nonnull ItemStack var1, int var2, Action var3);

    default public ItemStack insertItemTracked(@Nonnull ItemStack stack, int size) {
        ItemStack remainder = this.insertItem(stack, size, Action.PERFORM);
        int inserted = remainder == null ? size : size - remainder.func_190916_E();
        this.getCraftingManager().track(stack, inserted);
        return remainder;
    }

    @Nullable
    public ItemStack extractItem(@Nonnull ItemStack var1, int var2, int var3, Action var4, Predicate<IStorage<ItemStack>> var5);

    @Nullable
    default public ItemStack extractItem(@Nonnull ItemStack stack, int size, int flags, Action action) {
        return this.extractItem(stack, size, flags, action, s -> true);
    }

    @Nullable
    default public ItemStack extractItem(@Nonnull ItemStack stack, int size, Action action) {
        return this.extractItem(stack, size, 3, action);
    }

    @Nullable
    public FluidStack insertFluid(@Nonnull FluidStack var1, int var2, Action var3);

    @Nullable
    default public FluidStack insertFluidTracked(@Nonnull FluidStack stack, int size) {
        FluidStack remainder = this.insertFluid(stack, size, Action.PERFORM);
        int inserted = remainder == null ? size : size - remainder.amount;
        this.getCraftingManager().track(stack, inserted);
        return remainder;
    }

    @Nullable
    public FluidStack extractFluid(@Nonnull FluidStack var1, int var2, int var3, Action var4, Predicate<IStorage<FluidStack>> var5);

    @Nullable
    default public FluidStack extractFluid(FluidStack stack, int size, int flags, Action action) {
        return this.extractFluid(stack, size, flags, action, s -> true);
    }

    @Nullable
    default public FluidStack extractFluid(FluidStack stack, int size, Action action) {
        return this.extractFluid(stack, size, 2, action);
    }

    public IStorageTracker<ItemStack> getItemStorageTracker();

    public IStorageTracker<FluidStack> getFluidStorageTracker();

    public World world();
}

