/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.util;

import com.feed_the_beast.ftblib.lib.ATHelper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.oredict.OreDictionary;

public class InvUtils {
    public static final IInventory EMPTY_INVENTORY = new InventoryBasic("[Null]", true, 0);
    public static final ItemStack ERROR_ITEM = new ItemStack(Blocks.field_180401_cv);

    @Nullable
    public static NBTTagCompound nullIfEmpty(@Nullable NBTTagCompound nbt) {
        return nbt == null || nbt.func_82582_d() ? null : nbt;
    }

    public static void dropItem(World w, double x, double y, double z, double mx, double my, double mz, ItemStack item, int delay) {
        if (!item.func_190926_b()) {
            EntityItem ei = new EntityItem(w, x, y, z, item.func_77946_l());
            ei.field_70159_w = mx;
            ei.field_70181_x = my;
            ei.field_70179_y = mz;
            ei.func_174867_a(delay);
            w.func_72838_d((Entity)ei);
        }
    }

    public static void dropItem(World w, double x, double y, double z, ItemStack item, int delay) {
        InvUtils.dropItem(w, x, y, z, w.field_73012_v.nextGaussian() * (double)0.07f, w.field_73012_v.nextFloat() * 0.05f, w.field_73012_v.nextGaussian() * (double)0.07f, item, delay);
    }

    public static void dropItem(World w, BlockPos pos, ItemStack item, int delay) {
        InvUtils.dropItem(w, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, item, delay);
    }

    public static void dropItem(Entity e, ItemStack item) {
        InvUtils.dropItem(e.field_70170_p, e.field_70165_t, e.field_70163_u, e.field_70161_v, item, 0);
    }

    public static void dropAllItems(World world, double x, double y, double z, Iterable<ItemStack> items) {
        if (!world.field_72995_K) {
            for (ItemStack item : items) {
                if (item.func_190926_b()) continue;
                InvUtils.dropItem(world, x, y, z, item, 10);
            }
        }
    }

    public static void dropAllItems(World world, double x, double y, double z, @Nullable IItemHandler itemHandler) {
        if (!world.field_72995_K && itemHandler != null && itemHandler.getSlots() > 0) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack item = itemHandler.getStackInSlot(i);
                if (item.func_190926_b()) continue;
                InvUtils.dropItem(world, x, y, z, item, 10);
            }
        }
    }

    public static void transferItems(@Nullable IItemHandler from, @Nullable IItemHandler to, int amount, Predicate<ItemStack> filter) {
        if (amount <= 0 || from == null || to == null) {
            return;
        }
        for (int i = 0; i < from.getSlots(); ++i) {
            ItemStack extracted = from.extractItem(i, amount, true);
            if (extracted.func_190926_b() || !filter.test(extracted)) continue;
            ItemStack inserted = ItemHandlerHelper.insertItem((IItemHandler)to, (ItemStack)extracted, (boolean)false);
            int s = extracted.func_190916_E() - inserted.func_190916_E();
            if (s <= 0) continue;
            from.extractItem(i, s, false);
            if ((amount -= s) > 0) continue;
            return;
        }
    }

    public static void writeItemHandler(NBTTagCompound nbt, String key, IItemHandlerModifiable itemHandler) {
        NBTTagList list = new NBTTagList();
        int slots = itemHandler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound nbt1 = stack.serializeNBT();
            nbt1.func_74768_a("Slot", i);
            list.func_74742_a((NBTBase)nbt1);
        }
        if (!list.func_82582_d()) {
            nbt.func_74782_a(key, (NBTBase)list);
        }
    }

    public static boolean stacksAreEqual(ItemStack stackA, ItemStack stackB) {
        return stackA == stackB || stackA.func_77973_b() == stackB.func_77973_b() && stackA.func_77960_j() == stackB.func_77960_j() && ItemStack.func_77970_a((ItemStack)stackA, (ItemStack)stackB);
    }

    public static Set<String> getOreNames(@Nullable Set<String> l, ItemStack is) {
        if (is.func_190926_b()) {
            return l == null ? Collections.emptySet() : l;
        }
        int[] ai = OreDictionary.getOreIDs((ItemStack)is);
        if (ai.length > 0) {
            if (l == null) {
                l = new HashSet<String>(ai.length);
            }
            for (int i : ai) {
                l.add(OreDictionary.getOreName((int)i));
            }
            return l;
        }
        return Collections.emptySet();
    }

    public static void forceUpdate(Container container) {
        for (int i = 0; i < container.field_75151_b.size(); ++i) {
            ItemStack itemstack = ((Slot)container.field_75151_b.get(i)).func_75211_c();
            ItemStack itemstack1 = itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack.func_77946_l();
            container.field_75153_a.set(i, (Object)itemstack1);
            for (IContainerListener listener : ATHelper.getContainerListeners(container)) {
                listener.func_71111_a(container, i, itemstack1);
            }
        }
    }

    public static void forceUpdate(EntityPlayer player) {
        InvUtils.forceUpdate(player.field_71069_bz);
    }

    static {
        ERROR_ITEM.func_151001_c("Broken Item!");
    }
}

