/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.item;

import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class ItemStackSerializer {
    public static ItemStack parseItemThrowingException(String input) throws Exception {
        if ((input = input.trim()).isEmpty() || input.equals("-") || input.equals("minecraft:air")) {
            return ItemStack.field_190927_a;
        }
        if (input.startsWith("{")) {
            NBTTagCompound nbt = JsonToNBT.func_180713_a((String)input);
            if (nbt.func_74771_c("Count") <= 0) {
                nbt.func_74774_a("Count", (byte)1);
            }
            return new ItemStack(nbt);
        }
        String[] s1 = input.split(" ", 4);
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(s1[0]));
        if (item == null) {
            throw new NullPointerException("Unknown item: " + s1[0]);
        }
        if (item == Items.field_190931_a) {
            return ItemStack.field_190927_a;
        }
        int stackSize = 1;
        int meta = 0;
        if (s1.length >= 2) {
            stackSize = MathHelper.func_82715_a((String)s1[1], (int)1);
        }
        if (s1.length >= 3) {
            meta = s1[2].charAt(0) == '*' ? Short.MAX_VALUE : MathHelper.func_82715_a((String)s1[2], (int)0);
        }
        ItemStack itemstack = new ItemStack(item, stackSize, meta);
        if (s1.length >= 4) {
            itemstack.func_77982_d(JsonToNBT.func_180713_a((String)s1[3]));
        }
        return itemstack;
    }

    public static ItemStack parseItem(String input) {
        try {
            return ItemStackSerializer.parseItemThrowingException(input);
        }
        catch (Exception ex) {
            return ItemStack.field_190927_a;
        }
    }

    public static String toString(ItemStack stack) {
        if (stack.func_190926_b()) {
            return "minecraft:air";
        }
        NBTTagCompound nbt = stack.serializeNBT();
        if (nbt.func_74764_b("ForgeCaps")) {
            return nbt.toString();
        }
        StringBuilder builder = new StringBuilder(String.valueOf(Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())));
        int count = stack.func_190916_E();
        int meta = stack.func_77960_j();
        NBTTagCompound tag = stack.func_77978_p();
        if (count > 1 || meta != 0 || tag != null) {
            builder.append(' ');
            builder.append(count);
        }
        if (meta != 0 || tag != null) {
            builder.append(' ');
            builder.append(meta);
        }
        if (tag != null) {
            builder.append(' ');
            builder.append(tag);
        }
        return builder.toString();
    }

    public static JsonElement serialize(ItemStack stack, boolean forceNonnull, boolean string) {
        if (!forceNonnull && stack.func_190926_b()) {
            return JsonNull.INSTANCE;
        }
        if (string) {
            return new JsonPrimitive(ItemStackSerializer.toString(stack));
        }
        NBTTagCompound nbt = stack.serializeNBT();
        JsonObject json = new JsonObject();
        json.addProperty("item", nbt.func_74779_i("id"));
        if (stack.func_77981_g()) {
            json.addProperty("data", (Number)nbt.func_74765_d("Damage"));
        }
        if (stack.func_190916_E() > 1) {
            json.addProperty("count", (Number)nbt.func_74771_c("Count"));
        }
        if (stack.func_77942_o()) {
            json.add("nbt", JsonUtils.toJson((NBTBase)nbt.func_74775_l("tag")));
        }
        if (nbt.func_74764_b("ForgeCaps")) {
            json.add("caps", JsonUtils.toJson((NBTBase)nbt.func_74775_l("ForgeCaps")));
        }
        return json;
    }

    public static ItemStack deserialize(JsonElement e) {
        ItemStack stack;
        NBTBase nbt1;
        if (e.isJsonNull()) {
            return ItemStack.field_190927_a;
        }
        if (e.isJsonPrimitive()) {
            return ItemStackSerializer.parseItem(e.getAsString());
        }
        JsonObject json = e.getAsJsonObject();
        if (!json.has("item")) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("id", json.get("item").getAsString());
        nbt.func_74777_a("Damage", json.has("data") ? json.get("data").getAsShort() : (short)0);
        nbt.func_74777_a("Count", json.has("count") ? (short)json.get("count").getAsByte() : (short)1);
        if (json.has("nbt") && (nbt1 = JsonUtils.toNBT(json.get("nbt"))) instanceof NBTTagCompound && !nbt1.func_82582_d()) {
            nbt.func_74782_a("tag", nbt1);
        }
        if (json.has("caps") && (nbt1 = JsonUtils.toNBT(json.get("caps"))) instanceof NBTTagCompound && !nbt1.func_82582_d()) {
            nbt.func_74782_a("ForgeCaps", nbt1);
        }
        return (stack = new ItemStack(nbt)).func_190926_b() ? ItemStack.field_190927_a : stack;
    }

    public static NBTTagCompound write(ItemStack stack) {
        if (stack.func_190926_b()) {
            return new NBTTagCompound();
        }
        NBTTagCompound nbt = stack.serializeNBT();
        if (!nbt.func_74764_b("ForgeCaps") && !nbt.func_74764_b("tag")) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74778_a("item", ItemStackSerializer.toString(stack));
            return nbt1;
        }
        if (nbt.func_74771_c("Count") == 1) {
            nbt.func_82580_o("Count");
        }
        if (nbt.func_74765_d("Damage") == 0) {
            nbt.func_82580_o("Damage");
        }
        return nbt;
    }

    public static ItemStack read(NBTTagCompound nbt) {
        ItemStack stack;
        if (nbt.func_82582_d()) {
            return ItemStack.field_190927_a;
        }
        if (nbt.func_150297_b("item", 8)) {
            stack = ItemStackSerializer.parseItem(nbt.func_74779_i("item"));
        } else {
            if (!nbt.func_74764_b("Count")) {
                nbt.func_74774_a("Count", (byte)1);
            }
            stack = new ItemStack(nbt);
        }
        return stack.func_190926_b() ? ItemStack.field_190927_a : stack;
    }
}

