/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui;

import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import java.util.List;

public abstract class SimpleTextButton
extends Button {
    public SimpleTextButton(Panel panel, String txt, Icon icon) {
        super(panel, txt, icon);
        this.setHeight(20);
    }

    @Override
    public SimpleTextButton setTitle(String txt) {
        super.setTitle(txt);
        this.setWidth(this.getGui().getTheme().getStringWidth(this.getTitle()) + (this.icon.isEmpty() ? 8 : 28));
        return this;
    }

    public boolean renderTitleInCenter() {
        return false;
    }

    @Override
    public void addMouseOverText(List<String> list) {
        if (this.getGui().getTheme().getStringWidth(this.getTitle()) + (this.icon.isEmpty() ? 8 : 28) > this.width) {
            list.add(this.getTitle());
        }
    }

    @Override
    public void draw(Theme theme, int x, int y, int w, int h) {
        this.drawBackground(theme, x, y, w, h);
        int s = h >= 16 ? 16 : 8;
        int off = (h - s) / 2;
        String title = this.getTitle();
        int textX = x;
        int textY = y + (h - theme.getFontHeight() + 1) / 2;
        textX = this.renderTitleInCenter() ? (textX += (w - theme.getStringWidth(title) - (this.icon.isEmpty() ? 0 : off + s)) / 2) : (textX += 4);
        if (!this.icon.isEmpty()) {
            this.icon.draw(x + off, y + off, s, s);
            textX += off + s;
        }
        theme.drawString(title, textX, textY, theme.getContentColor(this.getWidgetType()), 2);
    }
}

