/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.MismatchingParentPanelException;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;

public abstract class Panel
extends Widget {
    public static final Comparator<Widget> WIDGET_TITLE_COMPARATOR = (o1, o2) -> TextFormatting.func_110646_a((String)o1.getTitle()).compareToIgnoreCase(TextFormatting.func_110646_a((String)o2.getTitle()));
    public final List<Widget> widgets = new ArrayList<Widget>();
    private int scrollX = 0;
    private int scrollY = 0;
    private int offsetX = 0;
    private int offsetY = 0;
    private boolean unicode = false;
    private boolean onlyRenderWidgetsInside = true;
    private boolean onlyInteractWithWidgetsInside = true;

    public Panel(Panel panel) {
        super(panel);
    }

    public boolean getUnicode() {
        return this.unicode;
    }

    public void setUnicode(boolean value) {
        this.unicode = value;
    }

    public boolean getOnlyRenderWidgetsInside() {
        return this.onlyRenderWidgetsInside;
    }

    public void setOnlyRenderWidgetsInside(boolean value) {
        this.onlyRenderWidgetsInside = value;
    }

    public boolean getOnlyInteractWithWidgetsInside() {
        return this.onlyInteractWithWidgetsInside;
    }

    public void setOnlyInteractWithWidgetsInside(boolean value) {
        this.onlyInteractWithWidgetsInside = value;
    }

    public abstract void addWidgets();

    public abstract void alignWidgets();

    public void refreshWidgets() {
        this.widgets.clear();
        Theme theme = this.getGui().getTheme();
        theme.pushFontUnicode(this.getUnicode());
        try {
            this.addWidgets();
        }
        catch (MismatchingParentPanelException ex) {
            FTBLib.LOGGER.error(ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.alignWidgets();
        for (Widget widget : this.widgets) {
            if (!(widget instanceof Panel)) continue;
            ((Panel)widget).refreshWidgets();
        }
        this.alignWidgets();
        theme.popFontUnicode();
    }

    public void add(Widget widget) {
        if (widget.parent != this) {
            throw new MismatchingParentPanelException(this, widget);
        }
        this.widgets.add(widget);
    }

    public void addAll(Iterable<? extends Widget> list) {
        for (Widget widget : list) {
            this.add(widget);
        }
    }

    protected final int align(WidgetLayout layout) {
        return layout.align(this);
    }

    @Override
    public int getX() {
        return super.getX() + this.offsetX;
    }

    @Override
    public int getY() {
        return super.getY() + this.offsetY;
    }

    public void setOffset(boolean flag) {
        if (flag) {
            this.offsetX = -this.scrollX;
            this.offsetY = -this.scrollY;
        } else {
            this.offsetY = 0;
            this.offsetX = 0;
        }
    }

    public boolean isOffset() {
        return this.offsetX != 0 || this.offsetY != 0;
    }

    public void setScrollX(int scroll) {
        this.scrollX = scroll;
    }

    public void setScrollY(int scroll) {
        this.scrollY = scroll;
    }

    public int getScrollX() {
        return this.scrollX;
    }

    public int getScrollY() {
        return this.scrollY;
    }

    @Override
    public void draw(Theme theme, int x, int y, int w, int h) {
        boolean renderInside = this.getOnlyRenderWidgetsInside();
        theme.pushFontUnicode(this.getUnicode());
        this.drawBackground(theme, x, y, w, h);
        if (renderInside) {
            GuiHelper.pushScissor(this.getScreen(), x, y, w, h);
        }
        this.setOffset(true);
        this.drawOffsetBackground(theme, x + this.offsetX, y + this.offsetY, w, h);
        for (int i = 0; i < this.widgets.size(); ++i) {
            Widget widget = this.widgets.get(i);
            if (!widget.shouldDraw() || renderInside && !widget.collidesWith(x, y, w, h)) continue;
            this.drawWidget(theme, widget, i, x + this.offsetX, y + this.offsetY, w, h);
        }
        this.setOffset(false);
        if (renderInside) {
            GuiHelper.popScissor(this.getScreen());
        }
        theme.popFontUnicode();
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
    }

    public void drawOffsetBackground(Theme theme, int x, int y, int w, int h) {
    }

    public void drawWidget(Theme theme, Widget widget, int index, int x, int y, int w, int h) {
        int wx = widget.getX();
        int wy = widget.getY();
        int ww = widget.width;
        int wh = widget.height;
        widget.draw(theme, wx, wy, ww, wh);
        if (Theme.renderDebugBoxes) {
            Color4I col = Color4I.rgb(Color.HSBtoRGB((float)(widget.hashCode() & 0xFF) / 255.0f, 1.0f, 1.0f));
            GuiHelper.drawHollowRect(wx, wy, ww, wh, col.withAlpha(150), false);
            col.withAlpha(30).draw(wx + 1, wy + 1, ww - 2, wh - 2);
        }
    }

    @Override
    public void addMouseOverText(List<String> list) {
        if (!this.shouldAddMouseOverText() || this.getOnlyInteractWithWidgetsInside() && !this.isMouseOver()) {
            return;
        }
        Theme theme = this.getGui().getTheme();
        theme.pushFontUnicode(this.getUnicode());
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.shouldAddMouseOverText()) continue;
            widget.addMouseOverText(list);
            if (!Theme.renderDebugBoxes) continue;
            String s = widget.getClass().getSimpleName();
            if (s.isEmpty()) {
                s = widget.getClass().getSuperclass().getSimpleName();
            }
            list.add(TextFormatting.DARK_GRAY + s + ": " + widget.width + "x" + widget.height);
        }
        this.setOffset(false);
        theme.popFontUnicode();
    }

    @Override
    public void updateMouseOver(int mouseX, int mouseY) {
        super.updateMouseOver(mouseX, mouseY);
        this.setOffset(true);
        for (Widget widget : this.widgets) {
            widget.updateMouseOver(mouseX, mouseY);
        }
        this.setOffset(false);
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (this.getOnlyInteractWithWidgetsInside() && !this.isMouseOver()) {
            return false;
        }
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.mousePressed(button)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }

    @Override
    public void mouseReleased(MouseButton button) {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled()) continue;
            widget.mouseReleased(button);
        }
        this.setOffset(false);
    }

    @Override
    public boolean mouseScrolled(int scroll) {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.mouseScrolled(scroll)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }

    @Override
    public boolean keyPressed(int key, char keyChar) {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled() || !widget.keyPressed(key, keyChar)) continue;
            this.setOffset(false);
            return true;
        }
        this.setOffset(false);
        return false;
    }

    @Override
    public void keyReleased(int key) {
        this.setOffset(true);
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isEnabled()) continue;
            widget.keyReleased(key);
        }
        this.setOffset(false);
    }

    @Override
    public void onClosed() {
        for (Widget widget : this.widgets) {
            widget.onClosed();
        }
    }

    @Nullable
    public Widget getWidget(int index) {
        return index < 0 || index >= this.widgets.size() ? null : this.widgets.get(index);
    }
}

