/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.config;

import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigTeam;
import com.feed_the_beast.ftblib.lib.config.ConfigValueInstance;
import com.feed_the_beast.ftblib.lib.gui.IOpenableGui;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiSelectTeamValue;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.FinalIDObject;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;

public class ConfigTeamClient
extends ConfigString {
    public final Map<String, TeamInst> map = new HashMap<String, TeamInst>();

    public ConfigTeamClient(String v) {
        super(v, ConfigTeam.PATTERN);
    }

    @Override
    public String func_176610_l() {
        return "team";
    }

    @Override
    public ITextComponent getStringForGUI() {
        TeamInst inst = this.map.get(this.getString());
        if (inst != null) {
            return inst.title.func_150259_f();
        }
        return super.getStringForGUI();
    }

    @Override
    public ConfigTeamClient copy() {
        ConfigTeamClient config = new ConfigTeamClient(this.getString());
        for (TeamInst inst : this.map.values()) {
            TeamInst inst1 = new TeamInst(inst.func_176610_l());
            inst1.title = inst.title.func_150259_f();
            inst1.icon = inst.icon.copy();
            config.map.put(inst1.func_176610_l(), inst1);
        }
        return config;
    }

    @Override
    public Color4I getColor() {
        return Color4I.LIGHT_GREEN;
    }

    @Override
    public void addInfo(ConfigValueInstance inst, List<String> list) {
    }

    @Override
    public List<String> getVariants() {
        return new ArrayList<String>(this.map.keySet());
    }

    @Override
    public void onClicked(IOpenableGui gui, ConfigValueInstance inst, MouseButton button) {
        if (inst.getCanEdit()) {
            new GuiSelectTeamValue(this, gui).openGui();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, String key) {
        nbt.func_74778_a(key, this.getString());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, String key) {
        this.setString(nbt.func_74779_i(key));
    }

    @Override
    public void writeData(DataOut data) {
        throw new IllegalStateException("Can't write Team client property!");
    }

    @Override
    public void readData(DataIn data) {
        int s = data.readUnsignedShort();
        this.map.clear();
        for (int i = 0; i < s; ++i) {
            TeamInst inst = new TeamInst(data.readString());
            inst.title = data.readTextComponent();
            inst.icon = data.readIcon();
            this.map.put(inst.func_176610_l(), inst);
        }
        this.setString(data.readString());
    }

    public static class TeamInst
    extends FinalIDObject {
        public ITextComponent title;
        public Icon icon;

        public TeamInst(String id) {
            super(id);
        }
    }
}

