/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.client;

import com.feed_the_beast.ftblib.client.EnumSidebarButtonPlacement;
import com.feed_the_beast.ftblib.client.FTBLibClientConfig;
import com.feed_the_beast.ftblib.client.SidebarButtonGroup;
import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiLoading;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.JsonUtils;
import com.feed_the_beast.ftblib.lib.util.SidedUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;

public class SidebarButton
implements Comparable<SidebarButton> {
    public final ResourceLocation id;
    public final SidebarButtonGroup group;
    private Icon icon = Icon.EMPTY;
    private int x = 0;
    private boolean defaultConfig = true;
    private boolean configValue = true;
    private final List<String> requiredServerMods = new ArrayList<String>();
    private final List<String> clickEvents = new ArrayList<String>();
    private final List<String> shiftClickEvents = new ArrayList<String>();
    private boolean requiresOp;
    private boolean hideWithNEI;
    private boolean loadingScreen;
    private boolean customText;

    public SidebarButton(ResourceLocation _id, SidebarButtonGroup g, JsonObject json) {
        this.group = g;
        this.id = _id;
        if (json.has("icon")) {
            this.icon = Icon.getIcon(json.get("icon"));
        }
        if (this.icon.isEmpty()) {
            this.icon = GuiIcons.ACCEPT_GRAY;
        }
        if (json.has("click")) {
            for (JsonElement e : JsonUtils.toArray(json.get("click"))) {
                if (e.isJsonPrimitive()) {
                    this.clickEvents.add(e.getAsString());
                    continue;
                }
                this.clickEvents.add(GuiHelper.clickEventToString(JsonUtils.deserializeClickEvent(e)));
            }
        }
        if (json.has("shift_click")) {
            for (JsonElement e : JsonUtils.toArray(json.get("shift_click"))) {
                if (e.isJsonPrimitive()) {
                    this.shiftClickEvents.add(e.getAsString());
                    continue;
                }
                this.shiftClickEvents.add(GuiHelper.clickEventToString(JsonUtils.deserializeClickEvent(e)));
            }
        }
        if (json.has("config")) {
            this.defaultConfig = this.configValue = json.get("config").getAsBoolean();
        }
        if (json.has("required_server_mods")) {
            for (JsonElement e : JsonUtils.toArray(json.get("required_server_mods"))) {
                this.requiredServerMods.add(e.getAsString());
            }
        }
        if (json.has("x")) {
            this.x = json.get("x").getAsInt();
        }
        this.requiresOp = json.has("requires_op") && json.get("requires_op").getAsBoolean();
        this.hideWithNEI = json.has("hide_with_nei") && json.get("hide_with_nei").getAsBoolean();
        this.loadingScreen = json.has("loading_screen") && json.get("loading_screen").getAsBoolean();
        this.customText = json.has("custom_text") && json.get("custom_text").getAsBoolean();
    }

    public String getLangKey() {
        return "sidebar_button." + this.id.func_110624_b() + '.' + this.id.func_110623_a();
    }

    public String getTooltipLangKey() {
        return this.getLangKey() + ".tooltip";
    }

    public String toString() {
        return this.id.toString();
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final boolean equals(Object o) {
        return o == this || o instanceof SidebarButton && this.id.equals((Object)((SidebarButton)o).id);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getX() {
        return this.x;
    }

    public boolean getDefaultConfig() {
        return this.defaultConfig;
    }

    public void onClicked(boolean shift) {
        if (this.loadingScreen) {
            new GuiLoading(I18n.func_135052_a((String)this.getLangKey(), (Object[])new Object[0])).openGui();
        }
        for (String event : shift ? this.shiftClickEvents : this.clickEvents) {
            GuiHelper.BLANK_GUI.handleClick(event);
        }
    }

    public boolean isVisible() {
        return this.configValue && FTBLibClientConfig.general.action_buttons != EnumSidebarButtonPlacement.DISABLED && this.isAvailable();
    }

    public boolean isAvailable() {
        return !(this.hideWithNEI && Loader.isModLoaded((String)"nei") || this.requiresOp && !ClientUtils.isClientOP() || !SidedUtils.areAllModsLoadedOnServer(this.requiredServerMods));
    }

    public boolean hasCustomText() {
        return this.customText;
    }

    public boolean getConfig() {
        return this.configValue;
    }

    public void setConfig(boolean value) {
        this.configValue = value;
    }

    @Override
    public int compareTo(SidebarButton button) {
        return this.getX() - button.getX();
    }
}

