/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.client;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.client.EnumSidebarButtonPlacement;
import com.feed_the_beast.ftblib.client.FTBLibClient;
import com.feed_the_beast.ftblib.client.FTBLibClientConfig;
import com.feed_the_beast.ftblib.client.GuiClientConfig;
import com.feed_the_beast.ftblib.client.SidebarButton;
import com.feed_the_beast.ftblib.client.SidebarButtonGroup;
import com.feed_the_beast.ftblib.events.CustomSidebarButtonTextEvent;
import com.feed_the_beast.ftblib.events.client.CustomClickEvent;
import com.feed_the_beast.ftblib.lib.ClientATHelper;
import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.icon.AtlasSpriteIcon;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.IconPresets;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.util.InvUtils;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftblib.lib.util.SidedUtils;
import com.feed_the_beast.ftblib.lib.util.text_components.Notification;
import com.feed_the_beast.ftblib.net.MessageAdminPanelGui;
import com.feed_the_beast.ftblib.net.MessageMyTeamGui;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.chat.IChatListener;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;

@Mod.EventBusSubscriber(modid="ftblib", value={Side.CLIENT})
public class FTBLibClientEventHandler {
    private static Temp currentNotification;
    private static double sidebarButtonScale;
    private static final IChatListener CHAT_LISTENER;

    @SubscribeEvent
    public static void onConnected(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        SidedUtils.UNIVERSE_UUID_CLIENT = null;
        currentNotification = null;
        Temp.MAP.clear();
        ClientATHelper.getChatListeners().get(ChatType.GAME_INFO).clear();
        ClientATHelper.getChatListeners().get(ChatType.GAME_INFO).add(CHAT_LISTENER);
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        Set<String> ores;
        if (FTBLibClientConfig.general.item_ore_names && !(ores = InvUtils.getOreNames(null, event.getItemStack())).isEmpty()) {
            event.getToolTip().add(I18n.func_135052_a((String)"ftblib_client.general.item_ore_names.item_tooltip", (Object[])new Object[0]));
            for (String or : ores) {
                event.getToolTip().add("> " + or);
            }
        }
        if (FTBLibClientConfig.general.item_nbt && event.getItemStack().func_77942_o() && GuiScreen.func_146272_n()) {
            event.getToolTip().add(NBTUtils.getColoredNBTString((NBTBase)event.getItemStack().func_77978_p()));
        }
    }

    @SubscribeEvent
    public static void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (FTBLibClientConfig.general.action_buttons != EnumSidebarButtonPlacement.DISABLED && event.getGui() instanceof InventoryEffectRenderer && !FTBLibClient.SIDEBAR_BUTTON_GROUPS.isEmpty()) {
            event.getButtonList().add(new GuiButtonSidebarGroup((InventoryEffectRenderer)event.getGui()));
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (ClientUtils.MC.field_71441_e == null) {
                currentNotification = null;
                Temp.MAP.clear();
            }
            if (currentNotification != null && FTBLibClientEventHandler.currentNotification.tick()) {
                currentNotification = null;
            }
            if (currentNotification == null && !Temp.MAP.isEmpty()) {
                currentNotification = new Temp((ITextComponent)Temp.MAP.values().iterator().next());
                Temp.MAP.remove(((Temp)FTBLibClientEventHandler.currentNotification).widget.id);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onGameOverlayRender(RenderGameOverlayEvent.Text event) {
        if (currentNotification != null && !FTBLibClientEventHandler.currentNotification.isImportant()) {
            currentNotification.render(event.getResolution(), event.getPartialTicks());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179098_w();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && currentNotification != null && FTBLibClientEventHandler.currentNotification.isImportant()) {
            currentNotification.render(new ScaledResolution(ClientUtils.MC), event.renderTickTime);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179098_w();
        }
    }

    @SubscribeEvent
    public static void onDebugInfoEvent(RenderGameOverlayEvent.Text event) {
        if (FTBLibClientConfig.general.debug_helper && !ClientUtils.MC.field_71474_y.field_74330_P && Keyboard.isKeyDown((int)61)) {
            event.getLeft().add(I18n.func_135052_a((String)"debug.help.help", (Object[])new Object[0]));
        }
    }

    @SubscribeEvent
    public static void onBeforeTexturesStitched(TextureStitchEvent.Pre event) {
        block3: {
            ClientUtils.SPRITE_MAP.clear();
            try {
                for (Field field : GuiIcons.class.getDeclaredFields()) {
                    field.setAccessible(true);
                    Object o = field.get(null);
                    if (!(o instanceof AtlasSpriteIcon)) continue;
                    AtlasSpriteIcon a = (AtlasSpriteIcon)o;
                    event.getMap().func_174942_a(a.name);
                    IconPresets.MAP.put(a.name.toString(), a);
                }
            }
            catch (Exception ex) {
                if (!FTBLibConfig.debugging.print_more_errors) break block3;
                ex.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onCustomClick(CustomClickEvent event) {
        if (event.getID().func_110624_b().equals("ftblib")) {
            switch (event.getID().func_110623_a()) {
                case "client_config_gui": {
                    new GuiClientConfig().openGui();
                    break;
                }
                case "my_team_gui": {
                    new MessageMyTeamGui().sendToServer();
                    break;
                }
                case "admin_panel_gui": {
                    new MessageAdminPanelGui().sendToServer();
                }
            }
            event.setCanceled(true);
        }
    }

    static {
        sidebarButtonScale = 0.0;
        CHAT_LISTENER = (type, component) -> {
            if (type == ChatType.GAME_INFO) {
                if (component instanceof Notification || FTBLibClientConfig.general.replace_vanilla_status_messages) {
                    ResourceLocation id = component instanceof Notification ? ((Notification)component).getId() : Notification.VANILLA_STATUS;
                    Temp.MAP.remove(id);
                    if (currentNotification != null && ((Temp)FTBLibClientEventHandler.currentNotification).widget.id.equals((Object)id)) {
                        currentNotification = null;
                    }
                    Temp.MAP.put(id, component);
                } else {
                    ClientUtils.MC.field_71456_v.func_110326_a(component.func_150254_d(), false);
                }
            }
        };
    }

    private static class GuiButtonSidebarGroup
    extends GuiButton {
        private final InventoryEffectRenderer gui;
        public final List<GuiButtonSidebar> buttons;
        private GuiButtonSidebar mouseOver;

        public GuiButtonSidebarGroup(InventoryEffectRenderer g) {
            super(495829, 0, 0, 0, 0, "");
            this.gui = g;
            this.buttons = new ArrayList<GuiButtonSidebar>();
        }

        public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks) {
            this.buttons.clear();
            this.mouseOver = null;
            int ry = 0;
            boolean top = FTBLibClientConfig.general.action_buttons.top() || !this.gui.field_146297_k.field_71439_g.func_70651_bq().isEmpty() || this.gui instanceof GuiInventory && ((GuiInventory)this.gui).func_194310_f().func_191878_b();
            for (SidebarButtonGroup group : FTBLibClient.SIDEBAR_BUTTON_GROUPS) {
                int rx = 0;
                boolean addedAny = false;
                for (SidebarButton sidebarButton : group.getButtons()) {
                    if (!sidebarButton.isVisible()) continue;
                    this.buttons.add(new GuiButtonSidebar(rx, ry, sidebarButton));
                    ++rx;
                    addedAny = true;
                }
                if (!addedAny) continue;
                ++ry;
            }
            int guiLeft = this.gui.getGuiLeft();
            int guiTop = this.gui.getGuiTop();
            if (top) {
                for (GuiButtonSidebar guiButtonSidebar : this.buttons) {
                    if (FTBLibClientConfig.general.collapse_sidebar_buttons) {
                        guiButtonSidebar.x = 4 + guiButtonSidebar.buttonX * 17;
                        guiButtonSidebar.y = 4 + guiButtonSidebar.buttonY * 17;
                        continue;
                    }
                    guiButtonSidebar.x = 1 + guiButtonSidebar.buttonX * 17;
                    guiButtonSidebar.y = 1 + guiButtonSidebar.buttonY * 17;
                }
            } else {
                int offsetY = 8;
                if (this.gui instanceof GuiContainerCreative) {
                    offsetY = 6;
                }
                for (GuiButtonSidebar guiButtonSidebar : this.buttons) {
                    guiButtonSidebar.x = guiLeft - 18 - guiButtonSidebar.buttonY * 17;
                    guiButtonSidebar.y = guiTop + offsetY + guiButtonSidebar.buttonX * 17;
                }
            }
            this.field_146128_h = Integer.MAX_VALUE;
            this.field_146129_i = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int n = Integer.MIN_VALUE;
            for (GuiButtonSidebar b : this.buttons) {
                if (b.x >= 0 && b.y >= 0) {
                    int n2;
                    this.field_146128_h = Math.min(this.field_146128_h, b.x);
                    this.field_146129_i = Math.min(this.field_146129_i, b.y);
                    maxX = Math.max(maxX, b.x + 16);
                    n2 = Math.max(n2, b.y + 16);
                }
                if (mx < b.x || my < b.y || mx >= b.x + 16 || my >= b.y + 16) continue;
                this.mouseOver = b;
            }
            this.field_146128_h -= 2;
            this.field_146129_i -= 2;
            this.field_146120_f = (maxX += 2) - this.field_146128_h;
            this.field_146121_g = (var12_23 += 2) - this.field_146129_i;
            if (sidebarButtonScale <= 0.0 && mx >= this.field_146128_h && my >= this.field_146129_i && mx < this.field_146128_h + 16 && my < this.field_146129_i + 16) {
                sidebarButtonScale = 0.01;
            }
            if (mx < this.field_146128_h || my < this.field_146129_i || mx >= this.field_146128_h + this.field_146120_f || my >= this.field_146129_i + this.field_146121_g) {
                sidebarButtonScale = sidebarButtonScale - (double)partialTicks * 0.3 * FTBLibClientConfig.general.sidebar_button_collapse_speed;
                if (sidebarButtonScale < 0.0) {
                    sidebarButtonScale = 0.0;
                }
            } else if (sidebarButtonScale > 0.0) {
                sidebarButtonScale = sidebarButtonScale + (double)partialTicks * 0.3 * FTBLibClientConfig.general.sidebar_button_collapse_speed;
                if (sidebarButtonScale > 1.0) {
                    sidebarButtonScale = 1.0;
                }
            }
            if (!FTBLibClientConfig.general.collapse_sidebar_buttons) {
                sidebarButtonScale = 1.0;
            }
            this.field_73735_i = 0.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
            FontRenderer fontRenderer = mc.field_71466_p;
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            if (sidebarButtonScale < 1.0) {
                double scale = Math.min(16.0 / MathUtils.lerp((double)this.field_146120_f, 16.0, sidebarButtonScale), 16.0 / MathUtils.lerp((double)this.field_146121_g, 16.0, sidebarButtonScale));
                GlStateManager.func_179139_a((double)scale, (double)scale, (double)1.0);
            }
            if (FTBLibClientConfig.general.collapse_sidebar_buttons) {
                int alpha = (int)MathUtils.lerp(50.0, 100.0, sidebarButtonScale);
                Color4I.GRAY.withAlpha(alpha).draw(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g);
                Color4I.DARK_GRAY.withAlpha(alpha).draw(this.field_146128_h + 1, this.field_146129_i + 1, this.field_146120_f - 2, this.field_146121_g - 2);
            }
            int alpha255 = (int)MathUtils.lerp(80.0, 255.0, sidebarButtonScale);
            for (GuiButtonSidebar b : this.buttons) {
                b.button.getIcon().draw(b.x, b.y, 16, 16, Color4I.WHITE.withAlpha(alpha255));
                if (sidebarButtonScale >= 1.0 && b == this.mouseOver) {
                    Color4I.WHITE.withAlpha(33).draw(b.x, b.y, 16, 16);
                }
                if (!(sidebarButtonScale >= 1.0) || !b.button.hasCustomText()) continue;
                CustomSidebarButtonTextEvent event = new CustomSidebarButtonTextEvent(b.button);
                event.post();
                if (event.getText().isEmpty()) continue;
                int nw = fontRenderer.func_78256_a(event.getText());
                int width = 16;
                Color4I.LIGHT_RED.draw(b.x + width - nw, b.y - 1, nw + 1, 9);
                fontRenderer.func_78276_b(event.getText(), b.x + width - nw + 1, b.y, -1);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (this.mouseOver != null && sidebarButtonScale >= 1.0) {
                int mx1 = mx - 4;
                int my1 = my - 12;
                String title = I18n.func_135052_a((String)this.mouseOver.button.getLangKey(), (Object[])new Object[0]);
                int tw = fontRenderer.func_78256_a(title);
                if (!FTBLibClientConfig.general.action_buttons.top()) {
                    mx1 -= tw + 8;
                    my1 += 4;
                }
                if (mx1 < 4) {
                    mx1 = 4;
                }
                if (my1 < 4) {
                    my1 = 4;
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                Color4I.DARK_GRAY.draw(mx1 - 3, my1 - 2, tw + 6, 12);
                fontRenderer.func_78276_b(title, mx1, my1, -1);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179121_F();
            this.field_73735_i = 0.0f;
        }

        public boolean func_146116_c(Minecraft mc, int mx, int my) {
            if (super.func_146116_c(mc, mx, my)) {
                if (sidebarButtonScale >= 1.0 && this.mouseOver != null) {
                    this.mouseOver.button.onClicked(GuiScreen.func_146272_n());
                    if (!(ClientUtils.MC.field_71462_r instanceof InventoryEffectRenderer)) {
                        sidebarButtonScale = 0.0;
                    }
                }
                return true;
            }
            return false;
        }
    }

    private static class GuiButtonSidebar {
        public final int buttonX;
        public final int buttonY;
        public final SidebarButton button;
        public int x;
        public int y;

        public GuiButtonSidebar(int x, int y, SidebarButton b) {
            this.buttonX = x;
            this.buttonY = y;
            this.button = b;
        }
    }

    private static class Temp {
        private static final LinkedHashMap<ResourceLocation, ITextComponent> MAP = new LinkedHashMap();
        private long tick;
        private long endTick;
        private NotificationWidget widget;

        private Temp(ITextComponent n) {
            this.widget = new NotificationWidget(n, ClientUtils.MC.field_71466_p);
            this.endTick = -1L;
            this.tick = -1L;
        }

        public void render(ScaledResolution screen, float partialTicks) {
            if (this.tick == -1L || this.tick >= this.endTick) {
                return;
            }
            int alpha = (int)Math.min(255.0f, ((float)(this.endTick - this.tick) - partialTicks) * 255.0f / 20.0f);
            if (alpha <= 2) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((int)((float)screen.func_78326_a() / 2.0f)), (float)((int)((float)screen.func_78328_b() - 68.0f)), (float)0.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int offy = -(this.widget.text.size() * 11) / 2;
            for (int i = 0; i < this.widget.text.size(); ++i) {
                String string = this.widget.text.get(i);
                this.widget.font.func_175063_a(string, (float)(-this.widget.font.func_78256_a(string) / 2), (float)(offy + i * 11), 0xFFFFFF | alpha << 24);
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
            GlStateManager.func_179126_j();
        }

        private boolean tick() {
            this.tick = ClientUtils.MC.field_71441_e.func_82737_E();
            if (this.endTick == -1L) {
                this.endTick = this.tick + this.widget.timer;
            }
            return this.tick >= this.endTick || Math.min(255.0f, (float)(this.endTick - this.tick) * 255.0f / 20.0f) <= 2.0f;
        }

        private boolean isImportant() {
            return this.widget.notification instanceof Notification && ((Notification)this.widget.notification).isImportant();
        }
    }

    public static class NotificationWidget {
        public final ITextComponent notification;
        public final ResourceLocation id;
        public final List<String> text;
        public int width;
        public int height;
        public final FontRenderer font;
        public final long timer;

        public NotificationWidget(ITextComponent n, FontRenderer f) {
            this.notification = n;
            this.id = n instanceof Notification ? ((Notification)n).getId() : Notification.VANILLA_STATUS;
            this.width = 0;
            this.font = f;
            this.text = new ArrayList<String>();
            this.timer = n instanceof Notification ? ((Notification)n).getTimer().ticks() : 60L;
            for (String s : this.font.func_78271_c(this.notification.func_150254_d(), new ScaledResolution(ClientUtils.MC).func_78326_a())) {
                for (String line : s.split("\n")) {
                    if (line.isEmpty()) continue;
                    line = line.trim();
                    this.text.add(line);
                    this.width = Math.max(this.width, this.font.func_78256_a(line));
                }
            }
            this.width += 4;
            this.height = this.text.size() * 11;
            if (this.text.isEmpty()) {
                this.width = 20;
                this.height = 20;
            }
        }
    }
}

